/*
 * Decompiled with CFR 0.152.
 */
package restringer.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.imageio.ImageIO;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DropMode;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.RowFilter;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableRowSorter;
import restringer.Game;
import restringer.Mod;
import restringer.Profile;
import restringer.Settings;
import restringer.gui.Configurator;
import restringer.gui.LogWindow;
import restringer.gui.MemoryLabel;
import restringer.gui.ModTableModel;
import restringer.gui.ModTableTransferHandler;
import restringer.gui.ProfileInfoPanel;
import restringer.gui.ProgressIndicator;
import restringer.gui.ProgressModel;
import restringer.gui.SaveWindow;
import restringer.pex.RemappingStats;

public class ModChooser
extends JFrame {
    private Profile selectedProfile;
    private final Settings SETTINGS;
    private final ModTableModel MODEL;
    private final TableRowSorter<ModTableModel> SORTER;
    private final MemoryLabel LBLMEMORY;
    private final JTable TABLE;
    private final JButton PROCESS;
    private final JButton OUTPUT_PATH;
    private final JMenuItem LOAD_MODORGANIZER;
    private final JMenuItem LOAD_SKYRIM;
    private final JMenuItem LOAD_MOD1;
    private final JMenuItem LOAD_MOD2;
    private final JMenuItem SELECT_ALL;
    private final JMenuItem SELECT_NONE;
    private final JMenuItem REMOVE_MOD;
    private final JMenuItem SET_PATCH_DIR;
    private final JMenuItem SET_MO_DIR;
    private final JMenuItem SET_SKYRIM_DIR;
    private final JMenuItem EXIT;
    private final JMenuItem CREATE_PROFILE;
    private final JMenuItem DELETE_PROFILE;
    private final JMenu MOD_MENU;
    private final JMenu PROFILE_MENU;
    private final JPopupMenu POPUP_MENU;
    private final JTextField TXTFILTER;
    private final JLabel LBLARROW;
    private final JLabel LBLFILTER;
    private final JLabel LBLPROFILE;
    private final JCheckBox CBCOMPRESS;
    private final JComboBox<Profile> CBPROFILES;
    private final DefaultComboBoxModel<Profile> PROFILESMODEL;
    private final MouseHandler MOUSEHANDLER = new MouseHandler();
    private final ActionHandler ACTIONHANDLER = new ActionHandler();
    private final KeyboardHandler KEYBOARDHANDLER = new KeyboardHandler();
    private final TableModelHandler TABLEHANDLER = new TableModelHandler();
    private final LogWindow LOGWINDOW;
    private final ProfileInfoPanel PROFILEINFO;
    private final ModTableCellRenderer RENDERER;
    private final JMenuBar MENUBAR;
    private final JPanel BOTTOMPANEL;
    private final JPanel BUTTONPANEL;
    private final JPanel FILTERPANEL;
    private final JPanel HOLDER;
    private final JScrollPane SCROLLER;
    private final JScrollPane INFOSCROLLER;
    private final JPanel MODPANEL;
    private final JPanel LOGPANEL;
    private final JPanel INFOPANEL;
    private final JPanel PROGRESSPANEL;
    private final JSplitPane MAINSPLITTER;
    private final JSplitPane RIGHTSPLITTER;
    private final SaveWindow SAVEWINDOW;
    private static final Logger LOG = Logger.getLogger(ModChooser.class.getCanonicalName());
    private static final Preferences PREFS = Preferences.userNodeForPackage(ModChooser.class);

    public ModChooser() {
        this((SaveWindow)null);
    }

    private ModChooser(SaveWindow sw) {
        Settings settingsFile;
        try {
            settingsFile = Settings.readSettings();
        }
        catch (IOException ex) {
            JOptionPane.showMessageDialog(null, "The settings file \"settings.json\" could not be read.", "Settings", 0);
            settingsFile = new Settings();
        }
        this.SETTINGS = settingsFile;
        this.selectedProfile = this.SETTINGS.getSelectedProfile();
        this.SAVEWINDOW = sw;
        this.MODEL = new ModTableModel(this.SETTINGS, this.selectedProfile);
        this.TABLE = new JTable(this.MODEL);
        this.PROCESS = new JButton("Make Patch");
        this.OUTPUT_PATH = new JButton();
        this.LOAD_MOD2 = new JMenuItem("Load a mod", 76);
        this.LOAD_MODORGANIZER = new JMenuItem("Load mods from Mod Organizer", 77);
        this.LOAD_SKYRIM = new JMenuItem("Load Skyrim DATA directory", 68);
        this.SELECT_ALL = new JMenuItem("Select all", 65);
        this.SELECT_NONE = new JMenuItem("Select none", 78);
        this.LOAD_MOD1 = new JMenuItem("Load a mod", 76);
        this.REMOVE_MOD = new JMenuItem("Remove mod", 82);
        this.SET_PATCH_DIR = new JMenuItem("Set patch directory", 80);
        this.SET_SKYRIM_DIR = new JMenuItem("Set Skyrim directory", 83);
        this.SET_MO_DIR = new JMenuItem("Set ModOrganizer directory", 68);
        this.EXIT = new JMenuItem("Exit", 69);
        this.CREATE_PROFILE = new JMenuItem("Create Profile", 67);
        this.DELETE_PROFILE = new JMenuItem("Delete Profile", 68);
        this.POPUP_MENU = new JPopupMenu("Actions");
        this.MOD_MENU = new JMenu("File");
        this.PROFILE_MENU = new JMenu("Profiles");
        this.TXTFILTER = new JTextField(20);
        this.SORTER = new TableRowSorter<ModTableModel>(this.MODEL);
        this.MENUBAR = new JMenuBar();
        this.LBLARROW = new JLabel("\u2192");
        this.LBLFILTER = new JLabel("Filter:");
        this.LBLPROFILE = new JLabel("Profile:");
        Profile[] PROFILES = new Profile[this.SETTINGS.profiles.size()];
        this.SETTINGS.profiles.toArray(PROFILES);
        this.PROFILESMODEL = new DefaultComboBoxModel<Profile>(PROFILES);
        this.CBPROFILES = new JComboBox<Profile>(this.PROFILESMODEL);
        this.CBCOMPRESS = new JCheckBox("Compress patch?", false);
        this.LOGWINDOW = new LogWindow();
        this.PROFILEINFO = new ProfileInfoPanel();
        this.HOLDER = new JPanel(new FlowLayout(3));
        this.BUTTONPANEL = new JPanel();
        this.FILTERPANEL = new JPanel(new FlowLayout(3));
        this.MODPANEL = new JPanel(new BorderLayout());
        this.LOGPANEL = new JPanel();
        this.INFOPANEL = new JPanel();
        this.PROGRESSPANEL = new JPanel(new FlowLayout(3));
        this.BOTTOMPANEL = new JPanel(new BorderLayout());
        this.SCROLLER = new JScrollPane(this.TABLE, 22, 31);
        this.INFOSCROLLER = new JScrollPane(this.INFOPANEL, 20, 30);
        this.RIGHTSPLITTER = new JSplitPane(0, this.INFOSCROLLER, this.LOGPANEL);
        this.MAINSPLITTER = new JSplitPane(1, this.MODPANEL, this.RIGHTSPLITTER);
        this.RENDERER = new ModTableCellRenderer();
        this.LBLMEMORY = new MemoryLabel();
        this.initComponents();
    }

    private void initComponents() {
        this.setTitle("ReStringer");
        try {
            InputStream INPUT = ModChooser.class.getResourceAsStream("String.png");
            BufferedImage ICON = ImageIO.read(INPUT);
            this.setIconImage(ICON);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        LOG.getParent().addHandler(this.LOGWINDOW.getHandler());
        this.TABLE.setPreferredScrollableViewportSize(new Dimension(500, 700));
        this.TABLE.setFillsViewportHeight(true);
        this.TABLE.setTransferHandler(new ModTableTransferHandler(this.MODEL));
        this.TABLE.setDropMode(DropMode.ON_OR_INSERT_ROWS);
        this.TABLE.setSelectionMode(2);
        this.TABLE.setDragEnabled(true);
        this.TABLE.getColumn(this.TABLE.getColumnName(0)).setMaxWidth(25);
        this.TABLE.getColumn(this.TABLE.getColumnName(0)).setMinWidth(25);
        this.TABLE.getColumn(this.TABLE.getColumnName(2)).setMaxWidth(50);
        this.TABLE.getColumn(this.TABLE.getColumnName(2)).setMinWidth(50);
        this.TABLE.getColumn(this.TABLE.getColumnName(3)).setMaxWidth(50);
        this.TABLE.getColumn(this.TABLE.getColumnName(3)).setMinWidth(50);
        this.TABLE.getColumn(this.TABLE.getColumnName(4)).setMaxWidth(50);
        this.TABLE.getColumn(this.TABLE.getColumnName(4)).setMinWidth(50);
        this.TABLE.getColumn(this.TABLE.getColumnName(5)).setMaxWidth(50);
        this.TABLE.getColumn(this.TABLE.getColumnName(5)).setMinWidth(50);
        this.TABLE.getColumn(this.TABLE.getColumnName(6)).setMaxWidth(50);
        this.TABLE.getColumn(this.TABLE.getColumnName(6)).setMinWidth(50);
        this.TABLE.getColumn(this.TABLE.getColumnName(7)).setMaxWidth(60);
        this.TABLE.getColumn(this.TABLE.getColumnName(7)).setMinWidth(60);
        this.PROCESS.setFont(this.PROCESS.getFont().deriveFont(1));
        this.CBPROFILES.setPrototypeDisplayValue(new Profile("RestringerProfile Goes Here"));
        this.CBPROFILES.setSelectedItem(this.selectedProfile);
        this.updateSettings();
        this.LOAD_MOD2.setAccelerator(KeyStroke.getKeyStroke(76, 2));
        this.LOAD_MODORGANIZER.setAccelerator(KeyStroke.getKeyStroke(77, 2));
        this.SELECT_ALL.setAccelerator(KeyStroke.getKeyStroke(65, 2));
        this.SELECT_NONE.setAccelerator(KeyStroke.getKeyStroke(78, 2));
        this.REMOVE_MOD.setAccelerator(KeyStroke.getKeyStroke(82, 2));
        this.SET_PATCH_DIR.setAccelerator(KeyStroke.getKeyStroke(80, 2));
        this.SET_SKYRIM_DIR.setAccelerator(KeyStroke.getKeyStroke(83, 2));
        this.SET_MO_DIR.setAccelerator(KeyStroke.getKeyStroke(68, 2));
        this.EXIT.setAccelerator(KeyStroke.getKeyStroke(69, 2));
        this.POPUP_MENU.add(this.LOAD_MOD1);
        this.POPUP_MENU.add(this.REMOVE_MOD);
        this.POPUP_MENU.add(this.SELECT_ALL);
        this.POPUP_MENU.add(this.SELECT_NONE);
        this.MOD_MENU.add(this.LOAD_MOD2);
        this.MOD_MENU.add(this.LOAD_MODORGANIZER);
        this.MOD_MENU.add(this.LOAD_SKYRIM);
        this.MOD_MENU.addSeparator();
        this.MOD_MENU.add(this.SET_PATCH_DIR);
        this.MOD_MENU.add(this.SET_SKYRIM_DIR);
        this.MOD_MENU.add(this.SET_MO_DIR);
        this.MOD_MENU.addSeparator();
        this.MOD_MENU.addSeparator();
        this.MOD_MENU.add(this.EXIT);
        this.MOD_MENU.setMnemonic('D');
        this.REMOVE_MOD.setEnabled(false);
        this.PROFILE_MENU.add(this.CREATE_PROFILE);
        this.PROFILE_MENU.add(this.DELETE_PROFILE);
        this.MENUBAR.add(this.MOD_MENU);
        this.MENUBAR.add(this.PROFILE_MENU);
        this.MAINSPLITTER.setResizeWeight(0.5);
        this.RIGHTSPLITTER.setResizeWeight(0.2);
        this.FILTERPANEL.add(this.LBLPROFILE);
        this.FILTERPANEL.add(this.CBPROFILES);
        this.FILTERPANEL.add(this.LBLFILTER);
        this.FILTERPANEL.add(this.TXTFILTER);
        this.BUTTONPANEL.setLayout(new BoxLayout(this.BUTTONPANEL, 2));
        this.BUTTONPANEL.add(this.PROCESS);
        this.BUTTONPANEL.add(this.LBLARROW);
        this.BUTTONPANEL.add(this.OUTPUT_PATH);
        this.BUTTONPANEL.add(new JLabel("     "));
        this.BUTTONPANEL.add(this.CBCOMPRESS);
        this.HOLDER.add(this.BUTTONPANEL);
        this.LBLMEMORY.setFont(new Font("Monospaced", 0, 12));
        this.PROGRESSPANEL.add(this.LBLMEMORY);
        this.BOTTOMPANEL.add("North", this.PROGRESSPANEL);
        this.BOTTOMPANEL.add("South", this.HOLDER);
        this.MODPANEL.add((Component)this.FILTERPANEL, "North");
        this.MODPANEL.add((Component)this.SCROLLER, "Center");
        this.MODPANEL.add((Component)this.BOTTOMPANEL, "South");
        this.INFOPANEL.setBorder(BorderFactory.createTitledBorder("Info"));
        this.INFOPANEL.setLayout(new GridLayout(1, 1));
        this.INFOPANEL.add(this.PROFILEINFO);
        this.PROFILEINFO.setProfile(this.SETTINGS.getSelectedProfile());
        this.LOGPANEL.setBorder(BorderFactory.createTitledBorder("Log"));
        this.LOGPANEL.setLayout(new GridLayout(1, 1));
        this.LOGPANEL.add(this.LOGWINDOW);
        this.TABLE.setDefaultRenderer(String.class, this.RENDERER);
        this.TABLE.setDefaultRenderer(Integer.class, this.RENDERER);
        this.setLayout(new BorderLayout());
        this.add((Component)this.MAINSPLITTER, "Center");
        this.setJMenuBar(this.MENUBAR);
        this.setDefaultCloseOperation(0);
        this.pack();
        this.setLocationRelativeTo(null);
        this.loadPreferences();
        this.getGlassPane().addKeyListener(this.KEYBOARDHANDLER);
        this.TABLE.getSelectionModel().addListSelectionListener(this.TABLEHANDLER);
        this.LOAD_MOD1.addActionListener(this.ACTIONHANDLER);
        this.LOAD_MOD2.addActionListener(this.ACTIONHANDLER);
        this.LOAD_MODORGANIZER.addActionListener(this.ACTIONHANDLER);
        this.LOAD_SKYRIM.addActionListener(this.ACTIONHANDLER);
        this.SELECT_ALL.addActionListener(this.ACTIONHANDLER);
        this.SELECT_NONE.addActionListener(this.ACTIONHANDLER);
        this.REMOVE_MOD.addActionListener(this.ACTIONHANDLER);
        this.SET_PATCH_DIR.addActionListener(this.ACTIONHANDLER);
        this.SET_MO_DIR.addActionListener(this.ACTIONHANDLER);
        this.EXIT.addActionListener(this.ACTIONHANDLER);
        this.PROCESS.addActionListener(this.ACTIONHANDLER);
        this.OUTPUT_PATH.addActionListener(this.ACTIONHANDLER);
        this.CREATE_PROFILE.addActionListener(this.ACTIONHANDLER);
        this.DELETE_PROFILE.addActionListener(this.ACTIONHANDLER);
        this.SET_SKYRIM_DIR.addActionListener(this.ACTIONHANDLER);
        this.CBCOMPRESS.addActionListener(this.ACTIONHANDLER);
        this.SCROLLER.addMouseListener(this.MOUSEHANDLER);
        this.TABLE.addMouseListener(this.MOUSEHANDLER);
        this.TABLE.setRowSorter(this.SORTER);
        this.MODEL.addTableModelListener(this.TABLEHANDLER);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                ModChooser.this.exit();
            }
        });
        this.CBPROFILES.addActionListener(e -> {
            if (e.getSource() == this.CBPROFILES) {
                int index;
                this.selectedProfile = (Profile)this.CBPROFILES.getSelectedItem();
                this.SETTINGS.selectedProfile = index = this.SETTINGS.profiles.indexOf(this.selectedProfile);
                this.MODEL.setProfile(this.selectedProfile);
                this.PROFILEINFO.setProfile(this.SETTINGS.getSelectedProfile());
            }
        });
        this.TXTFILTER.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                ModChooser.this.filter();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                ModChooser.this.filter();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                ModChooser.this.filter();
            }
        });
        this.TABLE.getInputMap().put(KeyStroke.getKeyStroke(127, 0), "deleteSelected");
        this.TABLE.getActionMap().put("deleteSelected", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ModChooser.this.removeMod();
            }
        });
        this.TABLE.getInputMap().put(KeyStroke.getKeyStroke(36, 0), "selectFirstRow");
        this.TABLE.getInputMap().put(KeyStroke.getKeyStroke(35, 0), "selectLastRow");
        this.TABLE.getInputMap().put(KeyStroke.getKeyStroke(36, 64), "selectToFirstRow");
        this.TABLE.getInputMap().put(KeyStroke.getKeyStroke(35, 64), "selectToLastRow");
        this.TABLE.getInputMap().put(KeyStroke.getKeyStroke(32, 0), "toggleChecksOnSelection");
        this.TABLE.getActionMap().put("selectToFirstRow", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ModChooser.this.TABLE.getSelectionModel().setLeadSelectionIndex(0);
            }
        });
        this.TABLE.getActionMap().put("selectToLastRow", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int last = ModChooser.this.TABLE.getRowCount() - 1;
                ModChooser.this.TABLE.getSelectionModel().setLeadSelectionIndex(last);
            }
        });
        this.TABLE.getActionMap().put("toggleChecksOnSelection", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int[] rows = ModChooser.this.TABLE.getSelectedRows();
                for (int i = 0; i < rows.length; ++i) {
                    rows[i] = ModChooser.this.TABLE.convertRowIndexToModel(rows[i]);
                }
                ModChooser.this.MODEL.toggleRows(rows);
            }
        });
        this.LBLMEMORY.initialize();
    }

    private void savePreferences() {
        PREFS.putInt("mods.extendedState", this.getExtendedState());
        PREFS.putInt("mods.windowWidth", this.getSize().width);
        PREFS.putInt("mods.windowHeight", this.getSize().height);
        PREFS.putInt("mods.windowX", this.getLocation().x);
        PREFS.putInt("mods.windowY", this.getLocation().y);
        PREFS.putInt("mods.mainDivider", this.MAINSPLITTER.getDividerLocation());
        PREFS.putBoolean("mods.compress", this.CBCOMPRESS.isSelected());
    }

    private void loadPreferences() {
        int state = PREFS.getInt("mods.extendedState", 6);
        int width = PREFS.getInt("mods.windowWidth", this.getSize().width);
        int height = PREFS.getInt("mods.windowHeight", this.getSize().height);
        int x = PREFS.getInt("mods.windowX", this.getLocation().x);
        int y = PREFS.getInt("mods.windowY", this.getLocation().y);
        int mainDivider = PREFS.getInt("mods.mainDivider", this.MAINSPLITTER.getDividerLocation());
        boolean compress = PREFS.getBoolean("mods.compress", false);
        this.CBCOMPRESS.setSelected(compress);
        this.setLocation(x, y);
        this.setSize(width, height);
        this.setExtendedState(state);
        this.MAINSPLITTER.setDividerLocation(mainDivider);
    }

    private void exit() {
        SwingUtilities.invokeLater(() -> {
            this.savePreferences();
            this.LBLMEMORY.terminate();
            this.setVisible(false);
            this.dispose();
        });
    }

    public final void addMods(Collection<Mod> mods) {
        this.MODEL.addAllMods(mods);
    }

    private void addSkyrim() {
        try {
            this.setCursor(Cursor.getPredefinedCursor(3));
            File skyrimDir = Configurator.getGameDirectory(Game.SKYRIM_LE);
            if (!Configurator.validateGameDirectory(Game.SKYRIM_LE, skyrimDir)) {
                skyrimDir = Configurator.selectGameDirectory(this, Game.SKYRIM_LE);
            }
            if (!Configurator.validateGameDirectory(Game.SKYRIM_LE, skyrimDir)) {
                return;
            }
            Mod SKYRIM = new Mod(Game.SKYRIM_LE, skyrimDir);
            this.MODEL.addMod(0, SKYRIM, false);
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    private void addModOrganizerMods() {
        try {
            if (this.MODEL.getRowCount() > 0) {
                String MSG = "This will overwrite the current list of mods. Is that okay?";
                int result = JOptionPane.showConfirmDialog(this, "This will overwrite the current list of mods. Is that okay?", "Overwrite?", 0);
                if (result == 1) {
                    return;
                }
            }
            this.setCursor(Cursor.getPredefinedCursor(3));
            File moDir = Configurator.getModOrganizerDirectory();
            if (!Configurator.validateModOrganizerDirectory(moDir) && !Configurator.validateModOrganizerDirectory(moDir = Configurator.selectModOrganizerDirectory(this))) {
                return;
            }
            List<Mod> MODS = Configurator.analyzeModOrganizer(Game.SKYRIM_LE, moDir);
            Collections.reverse(MODS);
            this.MODEL.removeAll();
            this.MODEL.addAllMods(MODS);
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    private void setOutputDirectory() {
        File prevOutput = this.selectedProfile.getOutputDirectory();
        File newOutput = Configurator.selectOutputDirectory(prevOutput, this);
        if (Configurator.validateOutputPath(newOutput)) {
            this.selectedProfile.setOutputDirectory(newOutput);
            this.updateSettings();
            this.saveSettings();
        }
    }

    private void updateSettings() {
        File OUTPUTDIR = this.selectedProfile.getOutputDirectory();
        if (OUTPUTDIR == null) {
            this.OUTPUT_PATH.setText("PATH FOR PATCH NEEDS TO BE SET");
            this.PROCESS.setEnabled(false);
        } else if (!Configurator.validateOutputPath(OUTPUTDIR)) {
            this.OUTPUT_PATH.setText("INVALID OUTPUT PATH");
            this.PROCESS.setEnabled(false);
        } else {
            this.OUTPUT_PATH.setText(OUTPUTDIR.getPath());
            int numSelected = this.MODEL.getNumChecked();
            if (numSelected > 0) {
                this.PROCESS.setEnabled(true);
            } else {
                this.PROCESS.setEnabled(false);
            }
        }
        this.PROFILEINFO.update();
    }

    public void saveSettings() {
        try {
            Settings.writeSettings(this.SETTINGS);
        }
        catch (IOException ex) {
            String MSG = String.format("Unable to write to \"settings.json\". Settings will not be saved.", new Object[0]);
            LOG.warning(MSG);
            JOptionPane.showMessageDialog(this.getParent(), MSG, "Settings", 0);
        }
    }

    private void createProfile() {
        String MSG = "Name for the new profile?";
        String newName = JOptionPane.showInputDialog(this, "Name for the new profile?", "Create Profile", 3);
        if (!Profile.validateName(newName)) {
            JOptionPane.showMessageDialog(this, "Invalid profile name.", "Error", 0);
            return;
        }
        for (Profile profile : this.SETTINGS.profiles) {
            if (!profile.getName().equalsIgnoreCase(newName)) continue;
            JOptionPane.showMessageDialog(this, "There is already a profile with that name.", "Error", 0);
            return;
        }
        Profile newProfile = new Profile(newName);
        this.SETTINGS.profiles.add(newProfile);
        this.PROFILESMODEL.addElement(newProfile);
        this.PROFILESMODEL.setSelectedItem(newProfile);
        this.saveSettings();
    }

    private void deleteProfile() {
        String MSG = "Are you sure you want to delete the current profile?";
        int result = JOptionPane.showConfirmDialog(this, "Are you sure you want to delete the current profile?", "Delete Profile", 0);
        if (result != 0) {
            return;
        }
        int index = this.SETTINGS.profiles.indexOf(this.selectedProfile);
        this.SETTINGS.profiles.remove(this.selectedProfile);
        this.PROFILESMODEL.removeElement(this.selectedProfile);
        if (this.SETTINGS.profiles.isEmpty()) {
            Profile newProfile = this.SETTINGS.getSelectedProfile();
            this.PROFILESMODEL.addElement(newProfile);
            this.PROFILESMODEL.setSelectedItem(newProfile);
        } else if (index > 0) {
            this.SETTINGS.selectedProfile = --index;
            Profile newProfile = this.SETTINGS.getSelectedProfile();
            this.PROFILESMODEL.setSelectedItem(newProfile);
        } else {
            this.SETTINGS.selectedProfile = index;
            Profile newProfile = this.SETTINGS.getSelectedProfile();
            this.PROFILESMODEL.setSelectedItem(newProfile);
        }
        this.saveSettings();
    }

    private void setModOrganizerDirectory() {
        Configurator.selectModOrganizerDirectory(this);
    }

    private void setSkyrimDirectory() {
        Configurator.selectGameDirectory(this, Game.SKYRIM_LE);
    }

    private void tableChanged() {
        int numSelected = this.MODEL.getNumChecked();
        String txt = String.format("MAKE PATCH! (%d mods)", numSelected);
        this.PROCESS.setText(txt);
        this.updateSettings();
    }

    private void addMod() {
        File selection = Configurator.selectMod(this);
        if (null == selection) {
            return;
        }
        Mod MOD = new Mod(Game.SKYRIM_LE, selection);
        this.addMods(Collections.singleton(MOD));
    }

    private void removeMod() {
        int[] selected = this.TABLE.getSelectedRows();
        LinkedList<Mod> MODS = new LinkedList<Mod>();
        for (int i = 0; i < selected.length; ++i) {
            int rowIndex = selected[i];
            Mod mod = this.MODEL.getMod(rowIndex);
            MODS.add(mod);
        }
        this.MODEL.removeMods(MODS);
    }

    private void filter() {
        try {
            String txt = this.TXTFILTER.getText();
            if (txt.isEmpty()) {
                RowFilter<ModTableModel, Integer> nameFilter = new RowFilter<ModTableModel, Integer>(){

                    @Override
                    public boolean include(RowFilter.Entry<? extends ModTableModel, ? extends Integer> entry) {
                        return true;
                    }
                };
                this.SORTER.setRowFilter(nameFilter);
            } else {
                String REGEX = txt;
                final Pattern PATTERN = Pattern.compile(REGEX, 2);
                RowFilter<ModTableModel, Integer> nameFilter = new RowFilter<ModTableModel, Integer>(){

                    @Override
                    public boolean include(RowFilter.Entry<? extends ModTableModel, ? extends Integer> entry) {
                        ModTableModel model = entry.getModel();
                        Mod mod = model.getMod(entry.getIdentifier());
                        String modName = mod.getName();
                        Matcher MATCHER = PATTERN.matcher(modName);
                        boolean match = MATCHER.find();
                        return match;
                    }
                };
                this.SORTER.setRowFilter(nameFilter);
            }
        }
        catch (PatternSyntaxException patternSyntaxException) {
            // empty catch block
        }
    }

    private void process() {
        if (!Configurator.validateOutputPath(this.selectedProfile.getOutputDirectory())) {
            this.setOutputDirectory();
            if (!Configurator.validateOutputPath(this.selectedProfile.getOutputDirectory())) {
                return;
            }
        }
        ProgressIndicator.startWaitCursor(this.getRootPane());
        final ProgressModel PROCESSMODEL = new ProgressModel();
        final JProgressBar BAR = new JProgressBar(PROCESSMODEL);
        BAR.setPreferredSize(new Dimension(200, BAR.getPreferredSize().height));
        this.PROGRESSPANEL.add(BAR);
        SwingWorker<RemappingStats, Object> worker = new SwingWorker<RemappingStats, Object>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected RemappingStats doInBackground() throws Exception {
                try {
                    boolean compress = ModChooser.this.CBCOMPRESS.isSelected();
                    RemappingStats stats = ModChooser.this.selectedProfile.execute2(PROCESSMODEL, compress);
                    JOptionPane.showMessageDialog(ModChooser.this, stats.toString(), "FINISHED", 1);
                    RemappingStats remappingStats = stats;
                    return remappingStats;
                }
                catch (Error | Exception ex) {
                    String MSG = String.format("Error while restringing scripts:\n%s", ex.getMessage());
                    LOG.severe(MSG);
                    LOG.severe(ex.toString());
                    JOptionPane.showMessageDialog(ModChooser.this, MSG, "Write Error", 0);
                    System.out.println(ex.getMessage());
                    ex.printStackTrace(System.out);
                    RemappingStats remappingStats = null;
                    return remappingStats;
                }
                finally {
                    ProgressIndicator.stopWaitCursor(ModChooser.this.getRootPane());
                    ModChooser.this.PROGRESSPANEL.remove(BAR);
                }
            }
        };
        worker.execute();
    }

    private final class ModTableCellRenderer
    extends DefaultTableCellRenderer {
        private ModTableCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            int index = ModChooser.this.TABLE.getRowSorter().convertRowIndexToModel(row);
            Mod mod = ModChooser.this.MODEL.getMod(index);
            Component c = column > 1 && null == value ? super.getTableCellRendererComponent(table, "(reading)", isSelected, hasFocus, row, column) : super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (mod.isEmpty()) {
                c.setFont(c.getFont().deriveFont(2));
                if (isSelected) {
                    c.setForeground(Color.LIGHT_GRAY);
                } else {
                    c.setForeground(new Color(128, 0, 0));
                }
            } else {
                c.setFont(c.getFont().deriveFont(0));
                if (isSelected) {
                    c.setForeground(Color.WHITE);
                } else {
                    c.setForeground(Color.BLACK);
                }
            }
            return c;
        }
    }

    private final class TableModelHandler
    implements TableModelListener,
    ListSelectionListener {
        private TableModelHandler() {
        }

        @Override
        public void tableChanged(TableModelEvent e) {
            if (e.getColumn() == 0 || e.getColumn() == -1) {
                ModChooser.this.tableChanged();
            }
            if (e.getColumn() == 7 || e.getColumn() == -1) {
                ModChooser.this.PROFILEINFO.update();
            }
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            int[] selection = ModChooser.this.TABLE.getSelectedRows();
            if (selection.length == 0) {
                ModChooser.this.REMOVE_MOD.setEnabled(false);
            } else {
                ModChooser.this.REMOVE_MOD.setEnabled(true);
            }
        }
    }

    private final class MouseHandler
    extends MouseAdapter {
        private MouseHandler() {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (e.isPopupTrigger()) {
                int[] selectedRows = ModChooser.this.TABLE.getSelectedRows();
                if (selectedRows == null || selectedRows.length == 0) {
                    int row = ModChooser.this.TABLE.rowAtPoint(e.getPoint());
                    ModChooser.this.TABLE.getSelectionModel().setSelectionInterval(row, row);
                }
                ModChooser.this.POPUP_MENU.show(e.getComponent(), e.getX(), e.getY());
            }
        }
    }

    private final class KeyboardHandler
    implements KeyListener {
        private KeyboardHandler() {
        }

        @Override
        public void keyTyped(KeyEvent e) {
        }

        @Override
        public void keyPressed(KeyEvent e) {
        }

        @Override
        public void keyReleased(KeyEvent e) {
        }
    }

    private final class ActionHandler
    implements ActionListener {
        private ActionHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == ModChooser.this.LOAD_MODORGANIZER) {
                ModChooser.this.addModOrganizerMods();
            } else if (e.getSource() == ModChooser.this.LOAD_MOD1) {
                ModChooser.this.addMod();
            } else if (e.getSource() == ModChooser.this.LOAD_MOD2) {
                ModChooser.this.addMod();
            } else if (e.getSource() == ModChooser.this.LOAD_SKYRIM) {
                ModChooser.this.addSkyrim();
            } else if (e.getSource() == ModChooser.this.REMOVE_MOD) {
                ModChooser.this.removeMod();
            } else if (e.getSource() == ModChooser.this.SELECT_ALL) {
                ModChooser.this.MODEL.checkAll();
            } else if (e.getSource() == ModChooser.this.SELECT_NONE) {
                ModChooser.this.MODEL.checkNone();
            } else if (e.getSource() == ModChooser.this.SET_PATCH_DIR) {
                ModChooser.this.setOutputDirectory();
            } else if (e.getSource() == ModChooser.this.SET_MO_DIR) {
                ModChooser.this.setModOrganizerDirectory();
            } else if (e.getSource() == ModChooser.this.PROCESS) {
                ModChooser.this.process();
            } else if (e.getSource() == ModChooser.this.EXIT) {
                ModChooser.this.exit();
            } else if (e.getSource() == ModChooser.this.OUTPUT_PATH) {
                ModChooser.this.setOutputDirectory();
            } else if (e.getSource() == ModChooser.this.TXTFILTER) {
                ModChooser.this.filter();
            } else if (e.getSource() == ModChooser.this.CREATE_PROFILE) {
                ModChooser.this.createProfile();
            } else if (e.getSource() == ModChooser.this.DELETE_PROFILE) {
                ModChooser.this.deleteProfile();
            } else if (e.getSource() == ModChooser.this.SET_SKYRIM_DIR) {
                ModChooser.this.setSkyrimDirectory();
            } else if (e.getSource() == ModChooser.this.CBCOMPRESS) {
                ModChooser.this.savePreferences();
            } else {
                JOptionPane.showMessageDialog(ModChooser.this, "Do something else.");
            }
        }
    }
}

