/*
 * Decompiled with CFR 0.152.
 */
package restringer.gui;

import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.ResourceBundle;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import javax.swing.SwingWorker;
import javax.swing.table.AbstractTableModel;
import restringer.Mod;
import restringer.Profile;
import restringer.Settings;

final class ModTableModel
extends AbstractTableModel {
    private Profile profile;
    private final Settings SETTINGS;
    private final Map<Mod, Mod.Analysis> ANALYSES;
    private final LinkedBlockingQueue<Mod> QUEUE;
    private static final ResourceBundle RES = ResourceBundle.getBundle("restringer/gui/General");
    private static final String[] COLUMN_NAMES = new String[]{"", RES.getString("CHOOSER MODNAME"), RES.getString("CHOOSER #"), RES.getString("CHOOSER ESPS"), RES.getString("CHOOSER BSAS"), RES.getString("CHOOSER PEXS"), RES.getString("CHOOSER SCRIPTS"), RES.getString("CHOOSER STRINGS")};
    private static final Class[] COLUMN_CLASSES = new Class[]{Boolean.class, String.class, Integer.class, Integer.class, Integer.class, Integer.class, Integer.class, Integer.class};
    private SwingWorker worker;

    public ModTableModel(Settings settings, Profile profile) {
        Objects.requireNonNull(settings);
        Objects.requireNonNull(profile);
        this.SETTINGS = settings;
        this.ANALYSES = new ConcurrentHashMap<Mod, Mod.Analysis>();
        this.QUEUE = new LinkedBlockingQueue();
        this.worker = new ModAnalyzer();
        this.setProfile(profile);
        this.worker.execute();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pauseAnalysis() {
        ModTableModel modTableModel = this;
        synchronized (modTableModel) {
            this.worker.cancel(true);
            this.worker = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resumeAnalysis() {
        ModTableModel modTableModel = this;
        synchronized (modTableModel) {
            if (null == this.worker || this.worker.isCancelled()) {
                this.worker = new ModAnalyzer();
                this.worker.execute();
            }
        }
    }

    public void setProfile(Profile newProfile) {
        Objects.requireNonNull(newProfile);
        this.profile = newProfile;
        this.ANALYSES.clear();
        this.QUEUE.addAll(this.profile.getMods());
        this.fireTableDataChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMod(int index, Mod mod, boolean checked) {
        Objects.requireNonNull(mod);
        ModTableModel modTableModel = this;
        synchronized (modTableModel) {
            int actualIndex = this.profile.addMod(index, mod);
            mod.setStatus(checked ? Mod.Status.CHECKED : Mod.Status.UNCHECKED);
            this.QUEUE.add(mod);
            super.fireTableRowsInserted(actualIndex, actualIndex);
        }
        this.saveSettings();
    }

    public void addMod(Mod mod, boolean checked) {
        this.addMod(this.profile.size(), mod, checked);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void moveMod(Mod mod, int index) {
        if (!this.profile.getMods().contains(mod)) {
            return;
        }
        ModTableModel modTableModel = this;
        synchronized (modTableModel) {
            int oldIndex = this.profile.getMods().indexOf(mod);
            if (index > oldIndex) {
                --index;
            }
            assert (0 <= oldIndex && oldIndex < this.profile.size());
            assert (0 <= index && index < this.profile.size());
            this.profile.addMod(index, mod);
            this.fireTableRowsDeleted(oldIndex, oldIndex);
            this.fireTableRowsInserted(index, index);
        }
        this.saveSettings();
    }

    public void addAllMods(Collection<Mod> mods) {
        Objects.requireNonNull(mods);
        if (mods.contains(null)) {
            throw new NullPointerException("Mods must not be null.");
        }
        mods.forEach(mod -> {
            ModTableModel modTableModel = this;
            synchronized (modTableModel) {
                int index = this.profile.addMod((Mod)mod);
                mod.setStatus(Mod.Status.UNCHECKED);
                this.QUEUE.add((Mod)mod);
                this.fireTableRowsInserted(index, index);
            }
        });
        this.saveSettings();
    }

    public void removeMods(Collection<Mod> mods) {
        Objects.requireNonNull(mods);
        mods.forEach(mod -> {
            ModTableModel modTableModel = this;
            synchronized (modTableModel) {
                if (this.profile.contains((Mod)mod)) {
                    int index = this.profile.removeMod((Mod)mod);
                    this.ANALYSES.remove(mod);
                    this.QUEUE.remove(mod);
                    this.fireTableRowsDeleted(index, index);
                }
            }
        });
        this.saveSettings();
    }

    public Mod getMod(int index) {
        if (index < 0 || index >= this.profile.size()) {
            throw new IllegalArgumentException();
        }
        return this.profile.getMods().get(index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAll() {
        ModTableModel modTableModel = this;
        synchronized (modTableModel) {
            this.profile.clear();
            this.ANALYSES.clear();
            this.QUEUE.clear();
            this.fireTableDataChanged();
        }
        this.saveSettings();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void toggleRows(int[] rows) {
        Mod.Status newStatus = Mod.Status.CHECKED;
        ModTableModel modTableModel = this;
        synchronized (modTableModel) {
            Mod mod;
            Mod.Status status;
            for (int row : rows) {
                if (0 > row || row >= this.getRowCount() || (status = (mod = this.profile.getMods().get(row)).getStatus()) != Mod.Status.CHECKED) continue;
                newStatus = Mod.Status.UNCHECKED;
            }
            for (int row : rows) {
                if (0 > row || row >= this.getRowCount() || (status = (mod = this.profile.getMods().get(row)).getStatus()) == Mod.Status.DISABLED) continue;
                mod.setStatus(newStatus);
                this.fireTableCellUpdated(row, 0);
            }
        }
        this.saveSettings();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void checkAll() {
        ModTableModel modTableModel = this;
        synchronized (modTableModel) {
            this.profile.getMods().forEach(mod -> {
                if (mod.getStatus() != Mod.Status.DISABLED) {
                    mod.setStatus(Mod.Status.CHECKED);
                }
            });
            super.fireTableDataChanged();
        }
        this.saveSettings();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void checkNone() {
        ModTableModel modTableModel = this;
        synchronized (modTableModel) {
            this.profile.getMods().forEach(mod -> {
                if (mod.getStatus() != Mod.Status.DISABLED) {
                    mod.setStatus(Mod.Status.UNCHECKED);
                }
            });
            super.fireTableDataChanged();
        }
        this.saveSettings();
    }

    final int getNumChecked() {
        return this.profile.getCheckmarkedMods().size();
    }

    public void saveSettings() {
        try {
            Settings.writeSettings(this.SETTINGS);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public int getRowCount() {
        return this.profile.size();
    }

    @Override
    public int getColumnCount() {
        return COLUMN_NAMES.length;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        Mod MOD = this.profile.getMods().get(rowIndex);
        Mod.Analysis ANALYSIS = this.ANALYSES.get(MOD);
        switch (columnIndex) {
            case 0: {
                switch (MOD.getStatus()) {
                    case CHECKED: {
                        return true;
                    }
                    case UNCHECKED: {
                        return false;
                    }
                }
                return null;
            }
            case 1: {
                return MOD.getName();
            }
            case 2: {
                return rowIndex;
            }
            case 3: {
                return MOD.getNumESPs();
            }
            case 4: {
                return MOD.getNumBSAs();
            }
            case 5: {
                return MOD.getNumLooseScripts();
            }
            case 6: {
                if (null == ANALYSIS) {
                    return null;
                }
                if (ANALYSIS == Mod.Analysis.INPROGRESS) {
                    return null;
                }
                return ANALYSIS.NUMSCRIPTS;
            }
            case 7: {
                if (null == ANALYSIS) {
                    return null;
                }
                if (ANALYSIS == Mod.Analysis.INPROGRESS) {
                    return null;
                }
                return ANALYSIS.NUMSTRINGS;
            }
        }
        return null;
    }

    @Override
    public String getColumnName(int columnIndex) {
        return COLUMN_NAMES[columnIndex];
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return COLUMN_CLASSES[columnIndex];
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return columnIndex == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        assert (columnIndex == 0);
        ModTableModel modTableModel = this;
        synchronized (modTableModel) {
            Mod MOD = this.profile.getMods().get(rowIndex);
            switch (MOD.getStatus()) {
                case CHECKED: {
                    MOD.setStatus(Mod.Status.UNCHECKED);
                    this.fireTableCellUpdated(rowIndex, columnIndex);
                    this.saveSettings();
                    break;
                }
                case UNCHECKED: {
                    MOD.setStatus(Mod.Status.CHECKED);
                    this.fireTableCellUpdated(rowIndex, columnIndex);
                    this.saveSettings();
                    break;
                }
            }
        }
    }

    private class ModAnalyzer
    extends SwingWorker {
        private ModAnalyzer() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        protected Object doInBackground() throws Exception {
            Mod mod = null;
            try {
                while (true) {
                    Thread.yield();
                    mod = (Mod)ModTableModel.this.QUEUE.take();
                    Thread.yield();
                    ModTableModel modTableModel = ModTableModel.this;
                    synchronized (modTableModel) {
                        int index = ModTableModel.this.profile.indexOf(mod);
                        if (index < 0) {
                            continue;
                        }
                        ModTableModel.this.ANALYSES.put(mod, Mod.Analysis.INPROGRESS);
                        try {
                            ModTableModel.this.fireTableCellUpdated(index, 6);
                            ModTableModel.this.fireTableCellUpdated(index, 7);
                        }
                        catch (Error | Exception e) {
                            e.printStackTrace(System.out);
                        }
                    }
                    Mod.Analysis analysis = mod.analysis();
                    Thread.yield();
                    ModTableModel modTableModel2 = ModTableModel.this;
                    synchronized (modTableModel2) {
                        int index = ModTableModel.this.profile.indexOf(mod);
                        if (index < 0) {
                            continue;
                        }
                        ModTableModel.this.ANALYSES.put(mod, analysis);
                        try {
                            ModTableModel.this.fireTableCellUpdated(index, 6);
                            ModTableModel.this.fireTableCellUpdated(index, 7);
                        }
                        catch (Error | Exception e) {
                            e.printStackTrace(System.out);
                        }
                    }
                }
            }
            catch (InterruptedException ex) {
                ModTableModel.this.QUEUE.offer(mod);
                return this;
            }
        }
    }
}

