/*
 * Decompiled with CFR 0.152.
 */
package restringer.gui;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import java.util.ResourceBundle;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.TransferHandler;
import restringer.Game;
import restringer.Mod;
import restringer.gui.ModTableModel;

class ModTableTransferHandler
extends TransferHandler {
    private final ModTableModel MODEL;
    private static final DataFlavor INTARRAYFLAVOUR = new DataFlavor(int[].class, ResourceBundle.getBundle("restringer/gui/General").getString("INTARRAY"));

    ModTableTransferHandler(ModTableModel model) {
        Objects.requireNonNull(model);
        this.MODEL = model;
    }

    @Override
    public boolean canImport(TransferHandler.TransferSupport support) {
        if (!support.isDataFlavorSupported(INTARRAYFLAVOUR) && !support.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
            return false;
        }
        JTable.DropLocation location = (JTable.DropLocation)support.getDropLocation();
        return location.isInsertRow() && 0 <= location.getRow();
    }

    @Override
    protected Transferable createTransferable(JComponent c) {
        JTable TABLE = (JTable)c;
        final int[] ROWS = TABLE.getSelectedRows();
        return new Transferable(){

            @Override
            public DataFlavor[] getTransferDataFlavors() {
                return new DataFlavor[]{INTARRAYFLAVOUR};
            }

            @Override
            public boolean isDataFlavorSupported(DataFlavor flavor) {
                return flavor.match(INTARRAYFLAVOUR);
            }

            @Override
            public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
                return ROWS;
            }
        };
    }

    @Override
    public int getSourceActions(JComponent c) {
        return 2;
    }

    @Override
    public boolean importData(TransferHandler.TransferSupport support) {
        assert (this.canImport(support));
        Transferable TRANSFERABLE = support.getTransferable();
        try {
            if (TRANSFERABLE.isDataFlavorSupported(INTARRAYFLAVOUR)) {
                int[] ROWS = (int[])TRANSFERABLE.getTransferData(INTARRAYFLAVOUR);
                if (ROWS.length == 0) {
                    return true;
                }
                JTable.DropLocation LOCATION = (JTable.DropLocation)support.getDropLocation();
                int DROPROW = LOCATION.getRow();
                int OFFSET = ROWS[0];
                for (int i = 0; i < ROWS.length; ++i) {
                    int row = ROWS[i];
                    int dest = row + DROPROW - OFFSET;
                    Mod mod = this.MODEL.getMod(row);
                    this.MODEL.moveMod(mod, dest);
                }
                return true;
            }
            if (TRANSFERABLE.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                List FILES = (List)TRANSFERABLE.getTransferData(DataFlavor.javaFileListFlavor);
                FILES.forEach(file -> {
                    try {
                        Mod mod = new Mod(Game.SKYRIM_LE, (File)file);
                        this.MODEL.addMod(mod, false);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                });
                return true;
            }
            return false;
        }
        catch (UnsupportedFlavorException | IOException ex) {
            return false;
        }
    }
}

