/*
 * Decompiled with CFR 0.152.
 */
package restringer.gui;

import it.unimi.dsi.fastutil.ints.IntRBTreeSet;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.net.JarURLConnection;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TimerTask;
import java.util.TreeSet;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import java.util.function.Predicate;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.logging.Logger;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javafx.application.Platform;
import javafx.embed.swing.JFXPanel;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.BoundedRangeModel;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.HyperlinkEvent;
import javax.swing.plaf.basic.BasicComboBoxRenderer;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;
import javax.swing.tree.TreePath;
import restringer.Analysis;
import restringer.Game;
import restringer.IString;
import restringer.Mod;
import restringer.Timer;
import restringer.ess.ChangeForm;
import restringer.ess.ChangeFormFLST;
import restringer.ess.ESS;
import restringer.ess.Element;
import restringer.ess.Plugin;
import restringer.ess.PluginInfo;
import restringer.ess.RefID;
import restringer.ess.papyrus.ActiveScript;
import restringer.ess.papyrus.ArrayInfo;
import restringer.ess.papyrus.EID;
import restringer.ess.papyrus.FunctionMessage;
import restringer.ess.papyrus.FunctionMessageData;
import restringer.ess.papyrus.Papyrus;
import restringer.ess.papyrus.QueuedUnbind;
import restringer.ess.papyrus.Reference;
import restringer.ess.papyrus.Script;
import restringer.ess.papyrus.ScriptInstance;
import restringer.ess.papyrus.ScriptMap;
import restringer.ess.papyrus.StackFrame;
import restringer.ess.papyrus.Struct;
import restringer.ess.papyrus.StructDef;
import restringer.ess.papyrus.SuspendedStack;
import restringer.ess.papyrus.TString;
import restringer.ess.papyrus.Variable;
import restringer.gui.Configurator;
import restringer.gui.FilterMaker;
import restringer.gui.FilterTree;
import restringer.gui.FilterTreeModel;
import restringer.gui.LogWindow;
import restringer.gui.MemoryLabel;
import restringer.gui.ModChooser;
import restringer.gui.ModalProgressDialog;
import restringer.gui.Opener;
import restringer.gui.ProgressIndicator;
import restringer.gui.Saver;
import restringer.gui.Scanner;
import restringer.gui.VariableTable;

public class SaveWindow
extends JFrame
implements ActionListener {
    private ESS save;
    private Analysis analysis;
    private boolean modified;
    private Predicate<FilterTreeModel.Node> filter;
    private final java.util.Timer FILTERTIMER;
    private final MemoryLabel LBLMEMORY;
    private final JLabel LBLSAVEINFO;
    private final FilterTree TREE;
    private final VariableTable TABLE;
    private final JTextPane INFOPANE;
    private final JButton CLEAR_FILTER;
    private final JScrollPane TREESCROLLER;
    private final JScrollPane DATASCROLLER;
    private final JScrollPane INFOSCROLLER;
    private final JSplitPane MAINSPLITTER;
    private final JSplitPane RIGHTSPLITTER;
    private final JPanel MAINPANEL;
    private final JPanel MODPANEL;
    private final JComboBox<Mod> MODCOMBO;
    private final JComboBox<Plugin> PLUGINCOMBO;
    private final JLabel MODLABEL;
    private final JPanel FILTERPANEL;
    private final JTextField FILTERFIELD;
    private final JPanel TOPPANEL;
    private final JPanel PROGRESSPANEL;
    private final JProgressBar PROGRESSBAR;
    private final JMenuBar MENUBAR;
    private final JMenu FILEMENU;
    private final JMenu DATAMENU;
    private final JMenu CLEANMENU;
    private final JMenu OPTIONSMENU;
    private final JMenu HELPMENU;
    private final JMenuItem MI_LOAD;
    private final JMenuItem MI_SAVE;
    private final JMenuItem MI_SAVEAS;
    private final JMenuItem MI_EXIT;
    private final JMenuItem MI_LOADESPS;
    private final JMenuItem MI_LOOKUPID;
    private final JMenuItem MI_LOOKUPBASE;
    private final JMenuItem MI_REMOVEUNATTACHED;
    private final JMenuItem MI_REMOVEUNDEFINED;
    private final JMenuItem MI_RESETHAVOK;
    private final JMenuItem MI_CLEANSEFORMLISTS;
    private final JMenuItem MI_REMOVENONEXISTENT;
    private final JMenuItem MI_BATCHCLEAN;
    private final JMenuItem MI_KILL;
    private final JCheckBoxMenuItem MI_USEMO;
    private final JCheckBoxMenuItem MI_USENMM;
    private final JCheckBoxMenuItem MI_SHOWMODS;
    private final JMenuItem MI_SHOWLOG;
    private final JMenuItem MI_ABOUT;
    private final JMenuItem MI_EXPORTPLUGINS;
    private final JCheckBoxMenuItem MI_SHOWUNATTACHED;
    private final JCheckBoxMenuItem MI_SHOWUNDEFINED;
    private final JCheckBoxMenuItem MI_SHOWNULLREFS;
    private final JCheckBoxMenuItem MI_SHOWNONEXISTENTCREATED;
    private final LogWindow LOGWINDOW;
    private final Timer TIMER;
    private static final Logger LOG = Logger.getLogger(SaveWindow.class.getCanonicalName());
    private static final Pattern URLREGEX = Pattern.compile("^(.+)://(.+)$", 2);

    public SaveWindow() {
        this((File)null);
    }

    public SaveWindow(File saveFile) {
        JFXPanel jfxPanel = new JFXPanel();
        this.TIMER = new Timer("SaveWindow timer");
        this.TIMER.start();
        this.save = null;
        this.analysis = null;
        this.filter = null;
        this.TREE = new FilterTree();
        this.TREESCROLLER = new JScrollPane(this.TREE);
        this.TOPPANEL = new JPanel();
        this.MODPANEL = new JPanel(new FlowLayout(3));
        this.MODCOMBO = new JComboBox();
        this.MODLABEL = new JLabel("Mod Filter:");
        this.PLUGINCOMBO = new JComboBox();
        this.FILTERFIELD = new JTextField(14);
        this.FILTERPANEL = new JPanel(new FlowLayout(3));
        this.MAINPANEL = new JPanel(new BorderLayout());
        this.PROGRESSPANEL = new JPanel(new FlowLayout(3));
        this.PROGRESSBAR = new JProgressBar();
        this.TABLE = new VariableTable();
        this.DATASCROLLER = new JScrollPane(this.TABLE);
        this.INFOPANE = new JTextPane();
        this.INFOSCROLLER = new JScrollPane(this.INFOPANE);
        this.RIGHTSPLITTER = new JSplitPane(0, this.INFOSCROLLER, this.DATASCROLLER);
        this.MAINSPLITTER = new JSplitPane(1, this.MAINPANEL, this.RIGHTSPLITTER);
        this.MENUBAR = new JMenuBar();
        this.FILEMENU = new JMenu("File");
        this.CLEANMENU = new JMenu("Clean");
        this.OPTIONSMENU = new JMenu("Options");
        this.DATAMENU = new JMenu("Data");
        this.HELPMENU = new JMenu("Help");
        this.MI_EXIT = new JMenuItem("Exit", 69);
        this.MI_LOAD = new JMenuItem("Open", 79);
        this.MI_LOADESPS = new JMenuItem("Parse ESP/ESMs.", 80);
        this.MI_SAVE = new JMenuItem("Save", 83);
        this.MI_SAVEAS = new JMenuItem("Save As", 65);
        this.MI_EXPORTPLUGINS = new JMenuItem("Export plugin list", 88);
        this.MI_SHOWUNATTACHED = new JCheckBoxMenuItem("Show unattached instances", false);
        this.MI_SHOWUNDEFINED = new JCheckBoxMenuItem("Show undefined elements", false);
        this.MI_SHOWNULLREFS = new JCheckBoxMenuItem("Show Formlists containg nullrefs", false);
        this.MI_SHOWNONEXISTENTCREATED = new JCheckBoxMenuItem("Show non-existent-form instances", false);
        this.MI_REMOVEUNATTACHED = new JMenuItem("Remove unattached instances", 49);
        this.MI_REMOVEUNDEFINED = new JMenuItem("Remove undefined elements", 50);
        this.MI_RESETHAVOK = new JMenuItem("Reset Havok", 51);
        this.MI_CLEANSEFORMLISTS = new JMenuItem("Purify FormLists", 52);
        this.MI_REMOVENONEXISTENT = new JMenuItem("Remove non-existent form instances", 53);
        this.MI_BATCHCLEAN = new JMenuItem("Batch Clean", 54);
        this.MI_KILL = new JMenuItem("Kill Listed");
        this.MI_USEMO = new JCheckBoxMenuItem("Integrate with Mod Organizer", false);
        this.MI_USENMM = new JCheckBoxMenuItem("Integrate with Nexus Mod Manager", false);
        this.MI_USENMM.setEnabled(false);
        this.MI_SHOWMODS = new JCheckBoxMenuItem("Show Mod Filter box", false);
        this.MI_LOOKUPID = new JMenuItem("Lookup ID by name");
        this.MI_LOOKUPBASE = new JMenuItem("Lookup base object/npc");
        this.MI_SHOWLOG = new JMenuItem("Show Log", 83);
        this.MI_ABOUT = new JMenuItem("About", 65);
        this.CLEAR_FILTER = new JButton("Clear Filters");
        this.LOGWINDOW = new LogWindow();
        this.LBLMEMORY = new MemoryLabel();
        this.LBLSAVEINFO = new JLabel();
        this.FILTERTIMER = new java.util.Timer();
        this.initComponents(saveFile);
        this.TIMER.stop();
        LOG.info(String.format("Version: %s", this.getVersion()));
        LOG.info(String.format("SaveWindow constructed; took %s.", this.TIMER.getFormattedTime()));
    }

    private void initComponents(final File saveFile) {
        this.TREE.addTreeSelectionListener(e -> this.updateContextInformation());
        this.DATASCROLLER.setBorder(BorderFactory.createTitledBorder(this.DATASCROLLER.getBorder(), "Data"));
        this.INFOPANE.setFont(this.INFOPANE.getFont().deriveFont(12.0f));
        this.INFOPANE.setEditable(false);
        this.INFOPANE.setContentType("text/html");
        this.INFOPANE.addHyperlinkListener(e -> {
            if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                String URL2 = e.getDescription();
                LOG.info(String.format("HYPERLINK: %s", URL2));
                this.findElement(URL2);
            }
        });
        this.INFOSCROLLER.setBorder(BorderFactory.createTitledBorder(this.INFOSCROLLER.getBorder(), "Information"));
        this.RIGHTSPLITTER.setResizeWeight(0.5);
        this.MAINSPLITTER.setResizeWeight(0.5);
        this.MAINPANEL.setMinimumSize(new Dimension(350, 400));
        this.PLUGINCOMBO.setRenderer(new PluginListCellRenderer());
        this.PLUGINCOMBO.setPrototypeDisplayValue(Plugin.PROTOTYPE);
        this.PLUGINCOMBO.setToolTipText("Select a plugin for filtering.");
        this.PROGRESSPANEL.add(this.LBLMEMORY);
        this.PROGRESSPANEL.add(this.LBLSAVEINFO);
        this.PROGRESSPANEL.add(this.PROGRESSBAR);
        this.PROGRESSBAR.setVisible(false);
        this.PROGRESSBAR.setEnabled(false);
        this.TREESCROLLER.getViewport().putClientProperty("EnableWindowBlit", Boolean.TRUE);
        this.FILTERFIELD.setToolTipText("Enter a regular expression for filtering.");
        this.FILTERPANEL.add(this.FILTERFIELD);
        this.FILTERPANEL.add(this.PLUGINCOMBO);
        this.FILTERPANEL.add(this.CLEAR_FILTER);
        this.MODPANEL.add(this.MODLABEL);
        this.MODPANEL.add(this.MODCOMBO);
        this.MODPANEL.setVisible(false);
        this.MODCOMBO.setRenderer(new ModListCellRenderer());
        this.MODCOMBO.setToolTipText("Select a mod for filtering.");
        this.TOPPANEL.setLayout(new BoxLayout(this.TOPPANEL, 1));
        this.TOPPANEL.add(this.MODPANEL);
        this.TOPPANEL.add(this.FILTERPANEL);
        this.MAINPANEL.add((Component)this.TREESCROLLER, "Center");
        this.MAINPANEL.add((Component)this.TOPPANEL, "First");
        this.MAINPANEL.add((Component)this.PROGRESSPANEL, "Last");
        this.FILEMENU.add(this.MI_LOAD);
        this.FILEMENU.add(this.MI_SAVE);
        this.FILEMENU.add(this.MI_SAVEAS);
        this.FILEMENU.addSeparator();
        this.FILEMENU.add(this.MI_LOADESPS);
        this.FILEMENU.addSeparator();
        this.FILEMENU.add(this.MI_EXPORTPLUGINS);
        this.FILEMENU.addSeparator();
        this.FILEMENU.add(this.MI_EXIT);
        this.FILEMENU.setMnemonic('f');
        this.CLEANMENU.add(this.MI_SHOWUNATTACHED);
        this.CLEANMENU.add(this.MI_SHOWUNDEFINED);
        this.CLEANMENU.add(this.MI_SHOWNULLREFS);
        this.CLEANMENU.add(this.MI_SHOWNONEXISTENTCREATED);
        this.CLEANMENU.addSeparator();
        this.CLEANMENU.add(this.MI_REMOVEUNATTACHED);
        this.CLEANMENU.add(this.MI_REMOVEUNDEFINED);
        this.CLEANMENU.add(this.MI_RESETHAVOK);
        this.CLEANMENU.add(this.MI_CLEANSEFORMLISTS);
        this.CLEANMENU.add(this.MI_REMOVENONEXISTENT);
        this.CLEANMENU.addSeparator();
        this.CLEANMENU.add(this.MI_BATCHCLEAN);
        this.CLEANMENU.add(this.MI_KILL);
        this.CLEANMENU.setMnemonic('c');
        this.OPTIONSMENU.add(this.MI_USEMO);
        this.OPTIONSMENU.add(this.MI_USENMM);
        this.OPTIONSMENU.add(this.MI_SHOWMODS);
        this.OPTIONSMENU.setMnemonic('o');
        this.DATAMENU.add(this.MI_LOOKUPID);
        this.DATAMENU.add(this.MI_LOOKUPBASE);
        this.DATAMENU.setMnemonic('d');
        this.DATAMENU.setEnabled(false);
        this.MI_LOOKUPID.setEnabled(false);
        this.MI_LOOKUPBASE.setEnabled(false);
        this.HELPMENU.add(this.MI_SHOWLOG);
        this.HELPMENU.add(this.MI_ABOUT);
        this.HELPMENU.setMnemonic('h');
        this.MENUBAR.add(this.FILEMENU);
        this.MENUBAR.add(this.CLEANMENU);
        this.MENUBAR.add(this.OPTIONSMENU);
        this.MENUBAR.add(this.DATAMENU);
        this.MENUBAR.add(this.HELPMENU);
        this.MI_EXIT.addActionListener(this);
        this.MI_LOAD.addActionListener(this);
        this.MI_LOADESPS.addActionListener(this);
        this.MI_SAVE.addActionListener(this);
        this.MI_SAVEAS.addActionListener(this);
        this.MI_EXPORTPLUGINS.addActionListener(this);
        this.MI_SHOWUNATTACHED.addActionListener(this);
        this.MI_SHOWUNDEFINED.addActionListener(this);
        this.MI_SHOWNULLREFS.addActionListener(this);
        this.MI_SHOWNONEXISTENTCREATED.addActionListener(this);
        this.MI_REMOVEUNATTACHED.addActionListener(this);
        this.MI_REMOVEUNDEFINED.addActionListener(this);
        this.MI_RESETHAVOK.addActionListener(this);
        this.MI_CLEANSEFORMLISTS.addActionListener(this);
        this.MI_REMOVENONEXISTENT.addActionListener(this);
        this.MI_BATCHCLEAN.addActionListener(this);
        this.MI_KILL.addActionListener(this);
        this.MI_USEMO.addActionListener(this);
        this.MI_USENMM.addActionListener(this);
        this.MI_SHOWMODS.addActionListener(this);
        this.MI_LOOKUPID.addActionListener(this);
        this.MI_LOOKUPBASE.addActionListener(this);
        this.MI_SHOWLOG.addActionListener(this);
        this.MI_ABOUT.addActionListener(this);
        this.MI_EXIT.setAccelerator(KeyStroke.getKeyStroke(69, 128));
        this.MI_LOAD.setAccelerator(KeyStroke.getKeyStroke(79, 128));
        this.MI_LOADESPS.setAccelerator(KeyStroke.getKeyStroke(80, 128));
        this.MI_SAVE.setAccelerator(KeyStroke.getKeyStroke(83, 128));
        this.MI_SAVEAS.setAccelerator(KeyStroke.getKeyStroke(65, 128));
        this.MI_REMOVEUNATTACHED.setAccelerator(KeyStroke.getKeyStroke(49, 128));
        this.MI_REMOVEUNDEFINED.setAccelerator(KeyStroke.getKeyStroke(50, 128));
        this.MI_RESETHAVOK.setAccelerator(KeyStroke.getKeyStroke(51, 128));
        this.MI_CLEANSEFORMLISTS.setAccelerator(KeyStroke.getKeyStroke(52, 128));
        this.MI_REMOVENONEXISTENT.setAccelerator(KeyStroke.getKeyStroke(53, 128));
        this.MI_BATCHCLEAN.setAccelerator(KeyStroke.getKeyStroke(54, 128));
        this.CLEAR_FILTER.addActionListener(this);
        LOG.getParent().addHandler(this.LOGWINDOW.getHandler());
        String TITLE = String.format("ReSaver %s: (no save loaded)", this.getVersion());
        this.setTitle(TITLE);
        this.setJMenuBar(this.MENUBAR);
        this.setContentPane(this.MAINSPLITTER);
        this.setDefaultCloseOperation(0);
        this.setPreferredSize(new Dimension(800, 600));
        this.pack();
        this.setLocationRelativeTo(null);
        this.loadPreferences();
        this.MI_SHOWNONEXISTENTCREATED.addItemListener(e -> {
            if (e.getStateChange() == 1) {
                String WARN = "Non-existent forms are used intentionally by some mods. Use caution when deleting them.";
                String WARN_TITLE = "Warning";
                JOptionPane.showMessageDialog(this, "Non-existent forms are used intentionally by some mods. Use caution when deleting them.", "Warning", 2);
            }
        });
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                SaveWindow.this.exitWithPrompt();
            }

            @Override
            public void windowOpened(WindowEvent evt) {
                if (null != saveFile) {
                    SaveWindow.this.open(saveFile);
                } else if (null == SaveWindow.this.save) {
                    SaveWindow.this.open(false);
                }
                SaveWindow.this.loadPreferences();
            }
        });
        try {
            InputStream INPUT = ModChooser.class.getResourceAsStream("Disk.png");
            BufferedImage ICON = ImageIO.read(INPUT);
            super.setIconImage(ICON);
        }
        catch (IOException INPUT) {
            // empty catch block
        }
        this.MODCOMBO.addItemListener(e -> this.updateFilters());
        this.PLUGINCOMBO.addItemListener(e -> this.updateFilters());
        this.TABLE.setQueryHandler(var -> this.findElement((Variable)var));
        this.TREE.setDeleteHandler(paths -> this.deletePaths((Map<Element, FilterTreeModel.Node>)paths));
        this.TREE.setDeleteFormsHandler(plugin -> this.deleteForms((Plugin)plugin));
        this.TREE.setDeleteInstancesHandler(plugin -> this.deleteInstances((Plugin)plugin));
        this.TREE.setFilterPluginsHandler(plugin -> this.PLUGINCOMBO.setSelectedItem(plugin));
        this.TREE.setZeroThreadHandler(threads -> this.zeroThreads((List<ActiveScript>)threads));
        this.TREE.setFindHandler(element -> this.findElement((Element)element));
        this.TREE.setCleanseFLSTHandler(flst -> this.cleanseFormList((ChangeFormFLST)flst));
        int DELAY = 700;
        final Timer DELAYTRACKER = new Timer("Delayer");
        this.FILTERFIELD.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent evt) {
                DELAYTRACKER.restart();
                TimerTask FILTERTASK = new TimerTask(){

                    @Override
                    public void run() {
                        long elaspsed = DELAYTRACKER.getElapsed() / 900000L;
                        if (elaspsed >= 700L) {
                            SaveWindow.this.updateFilters();
                        }
                    }
                };
                SaveWindow.this.FILTERTIMER.schedule(FILTERTASK, 700L);
            }

            @Override
            public void removeUpdate(DocumentEvent evt) {
                DELAYTRACKER.restart();
                TimerTask FILTERTASK = new TimerTask(){

                    @Override
                    public void run() {
                        long elaspsed = DELAYTRACKER.getElapsed() / 900000L;
                        if (elaspsed >= 700L) {
                            SaveWindow.this.updateFilters();
                        }
                    }
                };
                SaveWindow.this.FILTERTIMER.schedule(FILTERTASK, 700L);
            }

            @Override
            public void changedUpdate(DocumentEvent evt) {
                DELAYTRACKER.restart();
                TimerTask FILTERTASK = new TimerTask(){

                    @Override
                    public void run() {
                        long elaspsed = DELAYTRACKER.getElapsed() / 900000L;
                        if (elaspsed >= 700L) {
                            SaveWindow.this.updateFilters();
                        }
                    }
                };
                SaveWindow.this.FILTERTIMER.schedule(FILTERTASK, 700L);
            }
        });
        this.LBLMEMORY.initialize();
    }

    private String getVersion() {
        try {
            URL res = SaveWindow.class.getResource(SaveWindow.class.getSimpleName() + ".class");
            JarURLConnection conn = (JarURLConnection)res.openConnection();
            Manifest manifest = conn.getManifest();
            Attributes attr = manifest.getMainAttributes();
            return attr.getValue("Implementation-Version");
        }
        catch (IOException | ClassCastException ex) {
            return "(dev)";
        }
    }

    private String getInfoText() {
        try {
            URL res = SaveWindow.class.getResource(SaveWindow.class.getSimpleName() + ".class");
            JarURLConnection conn = (JarURLConnection)res.openConnection();
            Manifest manifest = conn.getManifest();
            Attributes attr = manifest.getMainAttributes();
            StringBuilder BUF = new StringBuilder();
            BUF.append("ReSaver was developed for YOU personally. I hope you enjoy it.\n");
            BUF.append("\nBuilt on: ");
            BUF.append(attr.getValue("Built-Date"));
            BUF.append("\nVersion: ");
            BUF.append(attr.getValue("Implementation-Version"));
            BUF.append("\nCopyright Mark Fairchild 2016.");
            BUF.append("\nDistributed under the Apache 2.0 license.");
            return BUF.toString();
        }
        catch (IOException | ClassCastException ex) {
            StringBuilder BUF = new StringBuilder();
            BUF.append("ReSaver was developed for YOU personally. I hope you enjoy it.\n");
            BUF.append("\n(development version)");
            BUF.append("\nCopyright Mark Fairchild 2016.");
            BUF.append("\nDistributed under the Apache 2.0 license.");
            return BUF.toString();
        }
    }

    void clearModified() {
        this.modified = false;
    }

    void setAnalysis(Analysis newAnalysis) {
        if (newAnalysis != this.analysis) {
            this.analysis = newAnalysis;
            this.updateContextInformation();
            this.save.addNames(this.analysis);
        }
        if (null != this.analysis) {
            this.DATAMENU.setEnabled(true);
            this.MI_LOOKUPID.setEnabled(true);
            this.MI_LOOKUPBASE.setEnabled(true);
        } else {
            this.DATAMENU.setEnabled(false);
            this.MI_LOOKUPID.setEnabled(false);
            this.MI_LOOKUPBASE.setEnabled(false);
        }
        if (null == this.analysis || !this.MI_SHOWMODS.isSelected()) {
            this.MODCOMBO.setModel(new DefaultComboBoxModel());
            this.MODPANEL.setVisible(false);
        } else {
            Mod[] MODS = new Mod[this.analysis.MODS.size()];
            this.analysis.MODS.toArray(MODS);
            Arrays.sort(MODS, (a, b) -> a.getName().compareToIgnoreCase(b.getName()));
            DefaultComboBoxModel<Mod> modModel = new DefaultComboBoxModel<Mod>(MODS);
            modModel.insertElementAt(null, 0);
            this.MODCOMBO.setModel(modModel);
            this.MODCOMBO.setSelectedIndex(0);
            this.MODPANEL.setVisible(true);
        }
        this.rebuildTree(true);
    }

    private void rebuildTree(boolean restorePath) {
        if (null == this.save) {
            return;
        }
        LOG.info("================");
        LOG.info("Re-initializing treeview.");
        this.TIMER.restart();
        if (restorePath) {
            Object[] paths = this.TREE.getSelectionPaths();
            this.TREE.setESS(this.save, this.filter);
            if (null != paths) {
                for (int i = 0; i < paths.length; ++i) {
                    paths[i] = this.TREE.getModel().rebuildPath((TreePath)paths[i]);
                }
            }
            LOG.info(String.format("Restoring path: ", Arrays.toString(paths)));
            this.TREE.setSelectionPaths((TreePath[])paths);
        } else {
            this.TREE.setESS(this.save, this.filter);
        }
        this.TIMER.stop();
        LOG.info(String.format("Treeview initialized, took %s.", this.TIMER.getFormattedTime()));
    }

    void clearESS() {
        this.MI_SAVE.setEnabled(false);
        this.MI_EXPORTPLUGINS.setEnabled(false);
        this.MI_REMOVEUNATTACHED.setEnabled(false);
        this.MI_REMOVEUNDEFINED.setEnabled(false);
        this.MI_RESETHAVOK.setEnabled(false);
        this.MI_CLEANSEFORMLISTS.setEnabled(false);
        this.MI_REMOVENONEXISTENT.setEnabled(false);
        this.PLUGINCOMBO.setModel(new DefaultComboBoxModel());
        this.save = null;
        this.clearModified();
        this.clearContextInformation();
        String TITLE = String.format("ReSaver %s: (no save loaded)", this.getVersion());
        this.setTitle(TITLE);
    }

    void setESS(File saveFile, ESS newSave) {
        Objects.requireNonNull(saveFile);
        Objects.requireNonNull(newSave);
        if (newSave.getPapyrus().getStringTable().isSTBCorrection()) {
            this.MI_SAVE.setEnabled(false);
            this.MI_SAVEAS.setEnabled(false);
        } else {
            this.MI_SAVE.setEnabled(true);
            this.MI_SAVEAS.setEnabled(true);
        }
        this.MI_EXPORTPLUGINS.setEnabled(true);
        this.MI_REMOVEUNATTACHED.setEnabled(true);
        this.MI_REMOVEUNDEFINED.setEnabled(true);
        this.MI_RESETHAVOK.setEnabled(true);
        this.MI_CLEANSEFORMLISTS.setEnabled(true);
        this.MI_REMOVENONEXISTENT.setEnabled(true);
        this.save = newSave;
        this.clearContextInformation();
        LOG.info("================");
        LOG.info("Initializing treeview.");
        this.TIMER.restart();
        List<Plugin> PLUGINS = newSave.getPluginInfo().getPlugins();
        Object[] PLUGINS_ARR = PLUGINS.toArray(new Plugin[0]);
        Arrays.sort(PLUGINS_ARR);
        DefaultComboBoxModel<Object> pluginModel = new DefaultComboBoxModel<Object>(PLUGINS_ARR);
        pluginModel.insertElementAt(null, 0);
        if (null != this.PLUGINCOMBO.getSelectedItem() && this.PLUGINCOMBO.getSelectedItem() instanceof Plugin) {
            Plugin PREV = (Plugin)this.PLUGINCOMBO.getSelectedItem();
            this.PLUGINCOMBO.setModel(pluginModel);
            this.PLUGINCOMBO.setSelectedItem(PREV);
        } else {
            this.PLUGINCOMBO.setModel(pluginModel);
            this.PLUGINCOMBO.setSelectedIndex(0);
        }
        this.TREE.setESS(this.save, this.filter);
        this.TREE.updateUI();
        TreePath path = this.TREE.getModel().getRoot().getPath();
        this.TREE.setSelectionPath(path);
        float SIZE = (float)saveFile.length() / 1048576.0f;
        Long DIGEST = newSave.getDigest();
        String fullName = saveFile.getName();
        int MAXLEN = 80;
        String NAME = fullName.length() > 80 ? fullName.substring(0, 80) + "..." : fullName;
        String TITLE = String.format("ReSaver %s: %s (%1.2f mb, dig=%08x)", this.getVersion(), NAME, Float.valueOf(SIZE), DIGEST);
        this.setTitle(TITLE);
        this.TIMER.stop();
        LOG.info(String.format("Treeview initialized, took %s.", this.TIMER.getFormattedTime()));
    }

    private void clearFilter() {
        LOG.info("Clearing filter.");
        this.MI_SHOWNONEXISTENTCREATED.setSelected(false);
        this.MI_SHOWNULLREFS.setSelected(false);
        this.MI_SHOWUNDEFINED.setSelected(false);
        this.MI_SHOWUNATTACHED.setSelected(false);
        this.FILTERFIELD.setText("");
        this.MODCOMBO.setSelectedItem(null);
        this.PLUGINCOMBO.setSelectedItem(null);
        this.filter = null;
        this.TREE.getModel().defilter();
    }

    private boolean createFilter(FilterTreeModel model) {
        LOG.info("Updating filter.");
        Mod MOD = this.MODCOMBO.getItemAt(this.MODCOMBO.getSelectedIndex());
        Plugin PLUGIN = (Plugin)this.PLUGINCOMBO.getSelectedItem();
        String TXT = this.FILTERFIELD.getText();
        PluginInfo PLUGINS = null != this.save ? this.save.getPluginInfo() : null;
        Predicate<FilterTreeModel.Node> mainfilter = FilterMaker.createFilter(MOD, PLUGIN, TXT, PLUGINS, this.analysis, this.MI_SHOWUNDEFINED.isSelected(), this.MI_SHOWUNATTACHED.isSelected(), this.MI_SHOWNULLREFS.isSelected(), this.MI_SHOWNONEXISTENTCREATED.isSelected());
        if (null == mainfilter) {
            this.filter = null;
            model.defilter();
            return true;
        }
        this.filter = mainfilter;
        model.filter(this.filter);
        return true;
    }

    private void updateFilters() {
        ProgressIndicator.startWaitCursor(this.getRootPane());
        SwingUtilities.invokeLater(() -> {
            this.TIMER.restart();
            TreePath path = this.TREE.getSelectionPath();
            boolean result = this.createFilter(this.TREE.getModel());
            if (!result) {
                return;
            }
            this.TREE.updateUI();
            if (null != path) {
                LOG.info(String.format("Updating filter: restoring path = %s", path.toString()));
                Object o = path.getLastPathComponent();
                if (null == o) {
                    this.TREE.clearSelection();
                    this.clearContextInformation();
                } else {
                    FilterTreeModel.Node node = (FilterTreeModel.Node)o;
                    if (!node.isFiltered()) {
                        this.TREE.setSelectionPath(path);
                        this.TREE.scrollPathToVisible(path);
                    } else {
                        this.TREE.clearSelection();
                        this.clearContextInformation();
                    }
                }
            }
            this.TIMER.stop();
            LOG.info(String.format("Filter updated, took %s.", this.TIMER.getFormattedTime()));
            ProgressIndicator.stopWaitCursor(this.getRootPane());
        });
    }

    void startProgressBar(BoundedRangeModel model) {
        this.PROGRESSBAR.setModel(model);
        this.PROGRESSBAR.setVisible(true);
        this.PROGRESSBAR.setEnabled(true);
    }

    void clearProgressBar() {
        this.PROGRESSBAR.setVisible(false);
        this.PROGRESSBAR.setEnabled(false);
    }

    void exit() {
        SwingUtilities.invokeLater(() -> {
            this.savePreferences();
            this.FILTERTIMER.cancel();
            this.FILTERTIMER.purge();
            this.LBLMEMORY.terminate();
            this.setVisible(false);
            this.dispose();
            Platform.exit();
        });
    }

    void exitWithPrompt() {
        if (null != this.save && this.modified) {
            int result = JOptionPane.showConfirmDialog(this, "Do you want to save the current file first?", "Save First?", 1, 3);
            switch (result) {
                case 2: {
                    return;
                }
                case 0: {
                    this.save(false, false, true);
                    break;
                }
                case 1: {
                    this.exit();
                }
            }
        }
        this.exit();
    }

    private void save(boolean promptForFile, boolean promptToOpen, boolean quitAfter) {
        if (null == this.save) {
            return;
        }
        try {
            FutureTask<File> PROMPT = new FutureTask<File>(() -> {
                File newSaveFile;
                File file = newSaveFile = promptForFile ? Configurator.selectNewSaveFile(this, this.save.getHeader().GAME) : Configurator.confirmSaveFile(this, this.save.getHeader().GAME);
                if (Configurator.validateNewSavegame(newSaveFile)) {
                    return newSaveFile;
                }
                return null;
            });
            ModalProgressDialog MODAL = new ModalProgressDialog((Frame)this, "File Selection", PROMPT);
            MODAL.setVisible(true);
            File SAVEFILE = PROMPT.get();
            if (!Configurator.validateNewSavegame(SAVEFILE)) {
                return;
            }
            Saver SAVER = new Saver(this, SAVEFILE, this.save, promptToOpen, quitAfter);
            SAVER.execute();
        }
        catch (InterruptedException | ExecutionException exception) {
            // empty catch block
        }
    }

    void open(File saveFile) {
        if (!Configurator.validateSavegame(saveFile)) {
            return;
        }
        Opener OPENER = new Opener(this, saveFile);
        OPENER.execute();
    }

    void open(boolean promptToSave) {
        if (null != this.save && this.modified && promptToSave) {
            int result = JOptionPane.showConfirmDialog(this, "Do you want to save the current file first?", "Save First?", 1, 3);
            switch (result) {
                case 0: {
                    this.save(false, true, false);
                    return;
                }
                case 2: {
                    return;
                }
            }
        }
        try {
            FutureTask<File> PROMPT = new FutureTask<File>(() -> {
                File saveFile = Configurator.selectSaveFile(this);
                return saveFile;
            });
            ModalProgressDialog MODAL = new ModalProgressDialog((Frame)this, "File Selection", PROMPT);
            MODAL.setVisible(true);
            File SAVEFILE = PROMPT.get();
            if (!Configurator.validateSavegame(SAVEFILE)) {
                return;
            }
            Opener OPENER = new Opener(this, SAVEFILE);
            OPENER.execute();
        }
        catch (InterruptedException | ExecutionException exception) {
            // empty catch block
        }
    }

    private void scanESPs() {
        if (null == this.save) {
            return;
        }
        Game GAME = this.save.getHeader().GAME;
        try {
            File NMM_DIR;
            File MO_DIR;
            FutureTask<File> PROMPT_GAMEDIR = new FutureTask<File>(() -> {
                File gameDir = Configurator.getGameDirectory(GAME);
                if (!Configurator.validateGameDirectory(GAME, gameDir)) {
                    gameDir = Configurator.selectGameDirectory(this, GAME);
                }
                if (!Configurator.validateGameDirectory(GAME, gameDir)) {
                    return null;
                }
                return gameDir;
            });
            ModalProgressDialog MODAL1 = new ModalProgressDialog((Frame)this, "File Selection", PROMPT_GAMEDIR);
            MODAL1.setVisible(true);
            File GAME_DIR = PROMPT_GAMEDIR.get();
            if (!this.MI_USEMO.isSelected()) {
                MO_DIR = null;
            } else {
                FutureTask<File> PROMPT_MO = new FutureTask<File>(() -> {
                    File moDir = Configurator.getModOrganizerDirectory();
                    if (Configurator.validateModOrganizerDirectory(moDir)) {
                        return moDir;
                    }
                    moDir = Configurator.selectModOrganizerDirectory(this);
                    if (Configurator.validateModOrganizerDirectory(moDir)) {
                        return moDir;
                    }
                    return null;
                });
                ModalProgressDialog MODAL2 = new ModalProgressDialog((Frame)this, "File Selection", PROMPT_MO);
                MODAL2.setVisible(true);
                MO_DIR = PROMPT_MO.get();
            }
            if (!this.MI_USENMM.isSelected()) {
                NMM_DIR = null;
            } else {
                FutureTask<File> PROMPT_NMM = new FutureTask<File>(() -> null);
                ModalProgressDialog MODAL3 = new ModalProgressDialog((Frame)this, "File Selection", PROMPT_NMM);
                MODAL3.setVisible(true);
                NMM_DIR = PROMPT_NMM.get();
            }
            Scanner SCANNER = new Scanner(this, this.save, GAME_DIR, MO_DIR, NMM_DIR);
            SCANNER.execute();
        }
        catch (InterruptedException | ExecutionException exception) {
            // empty catch block
        }
    }

    private void exportPlugins() {
        try {
            FutureTask<File> PROMPT = new FutureTask<File>(() -> {
                File file = Configurator.selectPluginsExport(this, this.save.getOriginalFile());
                if (Configurator.validatePluginsExport(file)) {
                    return file;
                }
                return null;
            });
            ModalProgressDialog MODAL = new ModalProgressDialog((Frame)this, "File Selection", PROMPT);
            MODAL.setVisible(true);
            File EXPORT = PROMPT.get();
            if (null == EXPORT) {
                return;
            }
            try (PrintWriter out = new PrintWriter(EXPORT);){
                this.save.getPluginInfo().getPlugins().forEach(p -> out.println(p.NAME));
                String MSG = String.format("Plugins list exported.", new Object[0]);
                JOptionPane.showMessageDialog(this, MSG, "Success", 1);
            }
            catch (IOException ex) {
                String MSG = String.format("Error while writing file \"%s\".\n%s", EXPORT.getName(), ex.getMessage());
                LOG.severe(MSG);
                LOG.severe(ex.toString());
                System.err.println(ex.getMessage());
                ex.printStackTrace(System.err);
                JOptionPane.showMessageDialog(this, MSG, "Write Error", 0);
            }
        }
        catch (InterruptedException | ExecutionException exception) {
            // empty catch block
        }
    }

    private void lookupID() {
        String MSG = "Enter the name of the object or NPC:";
        String TITLE = "Enter Name";
        String input = JOptionPane.showInputDialog(this, "Enter the name of the object or NPC:", "Enter Name", 3);
        if (null == input || input.trim().isEmpty()) {
            return;
        }
        IntRBTreeSet matches = new IntRBTreeSet(this.analysis.IDS.getID(input, this.analysis.STRINGS));
        if (matches.isEmpty()) {
            JOptionPane.showMessageDialog(this, "No matches were found.", "No matches", 0);
            return;
        }
        StringBuilder BUF = new StringBuilder();
        BUF.append("The following matches were found:\n\n");
        matches.forEach(id -> {
            BUF.append(String.format("%08x", id));
            int pluginIndex = id >>> 24;
            List<Plugin> PLUGINS = this.save.getPluginInfo().getPlugins();
            if (0 <= pluginIndex && pluginIndex < PLUGINS.size()) {
                Plugin PLUGIN = PLUGINS.get(pluginIndex);
                BUF.append(" (").append(PLUGIN).append(")");
            }
            BUF.append('\n');
        });
        JOptionPane.showMessageDialog(this, BUF.toString(), "Matches", 1);
        System.out.println(matches);
    }

    private void lookupBase() {
    }

    private void cleanUnattached() {
        try {
            if (null == this.save) {
                return;
            }
            LOG.info("Cleaning unattached instances.");
            Papyrus papyrus = this.save.getPapyrus();
            int result = papyrus.cleanUnattachedInstances();
            String msg = String.format("Removed %d orphaned script instances.", result);
            LOG.info(msg);
            JOptionPane.showMessageDialog(this, msg, "Cleaned", 1);
            if (result > 0) {
                this.rebuildTree(true);
                this.modified = true;
            }
        }
        catch (Exception ex) {
            String MSG = "Error cleaning unattached scripts.";
            String TITLE = "Cleaning Error";
            LOG.severe("Error cleaning unattached scripts.");
            LOG.severe(ex.toString());
            System.err.println(ex.getMessage());
            ex.printStackTrace(System.err);
            JOptionPane.showMessageDialog(this, "Error cleaning unattached scripts.", "Cleaning Error", 0);
        }
    }

    private void cleanUndefined() {
        try {
            if (null == this.save) {
                return;
            }
            LOG.info("Cleaning undefined elements.");
            Papyrus papyrus = this.save.getPapyrus();
            int[] result = papyrus.cleanUndefinedElements();
            StringBuilder BUF = new StringBuilder();
            if (result[0] > 0) {
                BUF.append("Removed ").append(result[0]).append(" undefined elements.");
            }
            if (result[1] > 0) {
                BUF.append("Terminated ").append(result[1]).append(" undefined threads.");
            }
            String MSG = BUF.toString();
            LOG.info(MSG);
            JOptionPane.showMessageDialog(this, MSG, "Cleaned", 1);
            if (result[0] > 0) {
                this.rebuildTree(true);
                this.modified = true;
            }
        }
        catch (Exception ex) {
            String MSG = "Error cleaning undefined elements.";
            String TITLE = "Cleaning Error";
            LOG.severe("Error cleaning undefined elements.");
            LOG.severe(ex.toString());
            System.err.println(ex.getMessage());
            ex.printStackTrace(System.err);
            JOptionPane.showMessageDialog(this, "Error cleaning undefined elements.", "Cleaning Error", 0);
        }
    }

    private void resetHavok() {
        if (null != this.save) {
            this.save.resetHavok();
            JOptionPane.showMessageDialog(this, "Not implemented yet.");
            this.modified = true;
        }
    }

    private void cleanseFormLists() {
        try {
            if (null == this.save) {
                return;
            }
            LOG.info("Cleansing formlists.");
            int[] results = this.save.cleanseFormLists();
            if (results[0] == 0) {
                String MSG = "No nullrefs were found in any formlists.";
                String TITLE = "No nullrefs found.";
                LOG.info("No nullrefs were found in any formlists.");
                JOptionPane.showMessageDialog(this, "No nullrefs were found in any formlists.", "No nullrefs found.", 1);
            } else {
                this.modified = true;
                String MSG = String.format("%d nullrefs were cleansed from %d formlists.", results[0], results[1]);
                String TITLE = "Nullrefs cleansed.";
                LOG.info(MSG);
                JOptionPane.showMessageDialog(this, MSG, "Nullrefs cleansed.", 1);
            }
            this.rebuildTree(true);
        }
        catch (Exception ex) {
            String MSG = "Error cleansing formlists.";
            String TITLE = "Cleansing Error";
            LOG.severe("Error cleansing formlists.");
            LOG.severe(ex.toString());
            System.err.println(ex.getMessage());
            ex.printStackTrace(System.err);
            JOptionPane.showMessageDialog(this, "Error cleansing formlists.", "Cleansing Error", 0);
        }
    }

    private void cleanseFormList(ChangeFormFLST flst) {
        try {
            if (null == this.save) {
                return;
            }
            LOG.info(String.format("Cleansing formlist %s.", flst));
            int result = flst.cleanse();
            if (result == 0) {
                String MSG = "No nullrefs were found.";
                String TITLE = "No nullrefs found.";
                LOG.info("No nullrefs were found.");
                JOptionPane.showMessageDialog(this, "No nullrefs were found.", "No nullrefs found.", 1);
            } else {
                this.modified = true;
                String MSG = String.format("%d nullrefs were cleansed.", result);
                String TITLE = "Nullrefs cleansed.";
                LOG.info(MSG);
                JOptionPane.showMessageDialog(this, MSG, "Nullrefs cleansed.", 1);
            }
            this.rebuildTree(true);
        }
        catch (Exception ex) {
            String MSG = "Error cleansing formlists.";
            String TITLE = "Cleansing Error";
            LOG.severe("Error cleansing formlists.");
            LOG.severe(ex.toString());
            System.err.println(ex.getMessage());
            ex.printStackTrace(System.err);
            JOptionPane.showMessageDialog(this, "Error cleansing formlists.", "Cleansing Error", 0);
        }
    }

    private void cleanNonexistent() {
        String WARN = "This cleaning operation can cause some mods to stop working. Are you sure you want to do this?";
        String WARN_TITLE = "Warning";
        int confirm = JOptionPane.showConfirmDialog(this, "This cleaning operation can cause some mods to stop working. Are you sure you want to do this?", "Warning", 0);
        if (confirm != 0) {
            return;
        }
        try {
            if (null == this.save) {
                return;
            }
            LOG.info(String.format("Removing nonexistent created forms.", new Object[0]));
            int result = this.save.removeNonexistentCreated();
            if (result == 0) {
                String MSG = "No scripts attached to non-existent created forms were found.";
                String TITLE = "No non-existent created";
                LOG.info("No scripts attached to non-existent created forms were found.");
                JOptionPane.showMessageDialog(this, "No scripts attached to non-existent created forms were found.", "No non-existent created", 1);
            } else {
                this.modified = true;
                String MSG = String.format("%d instances were removed.", result);
                String TITLE = "Instances removed.";
                LOG.info(MSG);
                JOptionPane.showMessageDialog(this, MSG, "Instances removed.", 1);
            }
            this.rebuildTree(true);
        }
        catch (Exception ex) {
            String MSG = "Error cleansing non-existent created.";
            String TITLE = "Cleansing Error";
            LOG.severe("Error cleansing non-existent created.");
            LOG.severe(ex.toString());
            System.err.println(ex.getMessage());
            ex.printStackTrace(System.err);
            JOptionPane.showMessageDialog(this, "Error cleansing non-existent created.", "Cleansing Error", 0);
        }
    }

    private void savePreferences() {
        Preferences PREFS = Preferences.userNodeForPackage(SaveWindow.class);
        PREFS.putInt("save.extendedState", this.getExtendedState());
        if (this.getExtendedState() == 0) {
            PREFS.putInt("save.windowWidth", this.getSize().width);
            PREFS.putInt("save.windowHeight", this.getSize().height);
            PREFS.putInt("save.windowX", this.getLocation().x);
            PREFS.putInt("save.windowY", this.getLocation().y);
            PREFS.putInt("save.mainDivider", this.MAINSPLITTER.getDividerLocation());
            PREFS.putInt("save.rightDivider", this.RIGHTSPLITTER.getDividerLocation());
            System.out.printf("Pos = %s\n", this.getLocation());
            System.out.printf("Size = %s\n", this.getSize());
            System.out.printf("Dividers = %d,%d\n", this.MAINSPLITTER.getDividerLocation(), this.RIGHTSPLITTER.getDividerLocation());
        } else {
            PREFS.putInt("save.mainDividerMax", this.MAINSPLITTER.getDividerLocation());
            PREFS.putInt("save.rightDividerMax", this.RIGHTSPLITTER.getDividerLocation());
            try {
                PREFS.flush();
            }
            catch (BackingStoreException ex) {
                ex.printStackTrace(System.err);
            }
        }
        PREFS.put("save.regex", this.FILTERFIELD.getText());
        PREFS.putBoolean("save.useMO", this.MI_USEMO.isSelected());
        PREFS.putBoolean("save.useNMM", this.MI_USENMM.isSelected());
        PREFS.putBoolean("save.showMods", this.MI_SHOWMODS.isSelected());
    }

    private void loadPreferences() {
        Preferences PREFS = Preferences.userNodeForPackage(SaveWindow.class);
        int state = PREFS.getInt("save.extendedState", 6);
        this.setExtendedState(state);
        if (state == 0) {
            Point pos = this.getLocation();
            Dimension size = this.getSize();
            int x = PREFS.getInt("save.windowX", pos.x);
            int y = PREFS.getInt("save.windowY", pos.y);
            int width = PREFS.getInt("save.windowWidth", size.width);
            int height = PREFS.getInt("save.windowHeight", size.height);
            this.setLocation(x, y);
            this.setSize(width, height);
            int mainDivider = this.MAINSPLITTER.getDividerLocation();
            mainDivider = PREFS.getInt("save.mainDivider", mainDivider);
            int rightDivider = this.RIGHTSPLITTER.getDividerLocation();
            rightDivider = PREFS.getInt("save.rightDivider", rightDivider);
            this.MAINSPLITTER.setDividerLocation(mainDivider);
            this.RIGHTSPLITTER.setDividerLocation(rightDivider);
        } else {
            int mainDivider = this.MAINSPLITTER.getDividerLocation();
            mainDivider = PREFS.getInt("save.mainDividerMax", mainDivider);
            int rightDivider = this.RIGHTSPLITTER.getDividerLocation();
            rightDivider = PREFS.getInt("save.rightDividerMax", rightDivider);
            this.MAINSPLITTER.setDividerLocation(mainDivider);
            this.RIGHTSPLITTER.setDividerLocation(rightDivider);
        }
        this.MI_USEMO.setSelected(PREFS.getBoolean("save.useMO", false));
        this.MI_USENMM.setSelected(PREFS.getBoolean("save.useNMM", false));
        this.MI_SHOWMODS.setSelected(PREFS.getBoolean("save.showMods", false));
        this.FILTERFIELD.setText(PREFS.get("save.regex", ""));
        this.updateFilters();
    }

    private void batchClean(String batch) {
        if (null == batch) {
            JTextArea TEXT = new JTextArea();
            TEXT.setColumns(50);
            TEXT.setRows(10);
            TEXT.setLineWrap(false);
            TEXT.setWrapStyleWord(false);
            JScrollPane SCROLLER = new JScrollPane(TEXT);
            SCROLLER.setBorder(BorderFactory.createTitledBorder("Enter Scripts"));
            String TITLE = "Batch Clean";
            int result = JOptionPane.showConfirmDialog(this, SCROLLER, "Batch Clean", 2, 3);
            if (result == 2) {
                return;
            }
            batch = TEXT.getText();
        }
        if (null == batch || batch.isEmpty()) {
            return;
        }
        String PATTERN = "^([^\\.@\\s]+)(?:\\.pex)?(?:\\s*@@\\s*(.*))?";
        Pattern REGEX = Pattern.compile("^([^\\.@\\s]+)(?:\\.pex)?(?:\\s*@@\\s*(.*))?", 2);
        String[] LINES = batch.split("\n");
        TreeSet<IString> CLEAN_NAMES = new TreeSet<IString>();
        ScriptMap SCRIPTS = this.save.getPapyrus().getScripts();
        for (String line : LINES) {
            Matcher MATCHER = REGEX.matcher(line);
            if (!MATCHER.find()) assert (false);
            LinkedList<String> groups = new LinkedList<String>();
            for (int i = 0; i <= MATCHER.groupCount(); ++i) {
                groups.add(MATCHER.group(i));
            }
            System.out.printf("Groups = %d: %s\n", MATCHER.groupCount(), groups);
            IString SCRIPT = IString.get(MATCHER.group(1).trim());
            if (!SCRIPTS.containsKey(SCRIPT)) continue;
            if (null == MATCHER.group(2)) {
                CLEAN_NAMES.add(SCRIPT);
                LOG.info(String.format("Script present, adding to cleaning list: %s", SCRIPT));
                continue;
            }
            LOG.info(String.format("Script present, prompting for deletion: %s", SCRIPT));
            String PROMPT = MATCHER.group(2).trim();
            String MSG = String.format("Delete %s?\n%s", SCRIPT, PROMPT);
            String TITLE = "Confirm";
            int result = JOptionPane.showConfirmDialog(this, MSG, "Confirm", 1, 3);
            if (result == 0) {
                CLEAN_NAMES.add(SCRIPT);
                continue;
            }
            if (result != 2) continue;
            return;
        }
        StringBuilder BUF = new StringBuilder();
        BUF.append("The following scripts will be cleaned: \n\n");
        CLEAN_NAMES.forEach(v -> BUF.append((CharSequence)v).append('\n'));
        JTextArea TEXT = new JTextArea(BUF.toString());
        TEXT.setColumns(40);
        TEXT.setEditable(false);
        JScrollPane SCROLLER = new JScrollPane(TEXT);
        String TITLE = "Batch Clean";
        int result = JOptionPane.showConfirmDialog(this, SCROLLER, "Batch Clean", 0, 3);
        if (result == 1) {
            return;
        }
        Set CLEAN = SCRIPTS.values().stream().filter(script -> CLEAN_NAMES.contains(script.getName())).collect(Collectors.toSet());
        Papyrus PAPYRUS = this.save.getPapyrus();
        long scripts = 0L;
        long instances = 0L;
        long references = 0L;
        long threads = 0L;
        this.modified = true;
        for (Script script2 : CLEAN) {
            assert (SCRIPTS.containsValue(script2));
            SCRIPTS.values().remove(script2);
            ++scripts;
            instances += (long)((int)PAPYRUS.getInstances().values().stream().filter(v -> v.getScript() == script2).count());
            references += (long)((int)PAPYRUS.getReferences().values().stream().filter(v -> v.getScript() == script2).count());
            threads += (long)((int)PAPYRUS.getActiveScripts().values().stream().filter(v -> v.hasScript(script2)).count());
            PAPYRUS.getInstances().values().removeIf(v -> v.getScript() == script2);
            PAPYRUS.getReferences().values().removeIf(v -> v.getScript() == script2);
            PAPYRUS.getActiveScripts().values().stream().filter(v -> v.hasScript(script2)).forEach(v -> v.zero());
        }
        this.rebuildTree(true);
        String MSG = String.format("Cleaned %d scripts, %d instances, and %d references. %d threads were terminated.", scripts, instances, references, threads);
        JOptionPane.showMessageDialog(this, MSG, "Batch Clean", 1);
    }

    private void kill() {
        try {
            List<Element> ELEMENTS = this.TREE.getModel().getElements();
            this.modified = true;
            this.save.removeElements(new HashSet<Element>(ELEMENTS));
            this.rebuildTree(false);
        }
        catch (Exception ex) {
            String MSG = "Error cleansing formlists.";
            String TITLE = "Cleansing Error";
            LOG.severe("Error cleansing formlists.");
            LOG.severe(ex.toString());
            System.err.println(ex.getMessage());
            ex.printStackTrace(System.err);
            JOptionPane.showMessageDialog(this, "Error cleansing formlists.", "Cleansing Error", 0);
        }
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        if (evt.getSource() == this.MI_EXIT) {
            this.exitWithPrompt();
        } else if (evt.getSource() == this.MI_SAVE) {
            this.save(false, false, false);
        } else if (evt.getSource() == this.MI_SAVEAS) {
            this.save(true, false, false);
        } else if (evt.getSource() == this.MI_LOAD) {
            this.open(true);
        } else if (evt.getSource() == this.MI_LOADESPS) {
            this.scanESPs();
        } else if (evt.getSource() == this.MI_SHOWUNATTACHED) {
            this.updateFilters();
        } else if (evt.getSource() == this.MI_SHOWUNDEFINED) {
            this.updateFilters();
        } else if (evt.getSource() == this.MI_SHOWNULLREFS) {
            this.updateFilters();
        } else if (evt.getSource() == this.MI_SHOWNONEXISTENTCREATED) {
            this.updateFilters();
        } else if (evt.getSource() == this.MI_REMOVEUNATTACHED) {
            this.cleanUnattached();
        } else if (evt.getSource() == this.MI_REMOVEUNDEFINED) {
            this.cleanUndefined();
        } else if (evt.getSource() == this.MI_RESETHAVOK) {
            this.resetHavok();
        } else if (evt.getSource() == this.MI_CLEANSEFORMLISTS) {
            this.cleanseFormLists();
        } else if (evt.getSource() == this.MI_REMOVENONEXISTENT) {
            this.cleanNonexistent();
        } else if (evt.getSource() == this.MI_BATCHCLEAN) {
            this.batchClean(null);
        } else if (evt.getSource() == this.MI_KILL) {
            this.kill();
        } else if (evt.getSource() == this.MI_EXPORTPLUGINS) {
            this.exportPlugins();
        } else if (evt.getSource() == this.MI_SHOWMODS) {
            this.setAnalysis(this.analysis);
        } else if (evt.getSource() == this.MI_SHOWLOG) {
            this.showLog();
        } else if (evt.getSource() == this.MI_LOOKUPID) {
            this.lookupID();
        } else if (evt.getSource() == this.MI_LOOKUPBASE) {
            this.lookupBase();
        } else if (evt.getSource() == this.MI_ABOUT) {
            JOptionPane.showMessageDialog(this, this.getInfoText(), "About", 1);
        } else if (evt.getSource() == this.CLEAR_FILTER) {
            this.clearFilter();
        }
    }

    private void showLog() {
        JDialog dialog = new JDialog((Frame)this, "Log");
        dialog.setContentPane(this.LOGWINDOW);
        dialog.setModalityType(Dialog.ModalityType.MODELESS);
        dialog.setDefaultCloseOperation(2);
        dialog.setPreferredSize(new Dimension(600, 400));
        dialog.setLocationRelativeTo(null);
        dialog.pack();
        dialog.setVisible(true);
    }

    private void findElement(String url) {
        Objects.requireNonNull(url);
        if (null == this.save) {
            return;
        }
        Matcher MATCHER = URLREGEX.matcher(url);
        if (!MATCHER.matches()) {
            return;
        }
        String TYPE2 = MATCHER.group(1).toLowerCase();
        String LABEL = MATCHER.group(2);
        Papyrus PAPYRUS = this.save.getPapyrus();
        switch (TYPE2) {
            case "script": {
                this.findElement((Element)PAPYRUS.getScripts().get(IString.get(LABEL)));
                break;
            }
            case "structdef": {
                this.findElement((Element)PAPYRUS.getStructDefs().get(IString.get(LABEL)));
                break;
            }
            case "instance": {
                long VAL = Long.parseUnsignedLong(LABEL, 16);
                EID proto = ((ScriptInstance)this.save.getPapyrus().getInstances().values().stream().findAny().get()).getID();
                EID ID2 = proto.derive(VAL);
                this.findElement((Element)PAPYRUS.getInstances().get(ID2));
                break;
            }
            case "struct": {
                long VAL = Long.parseUnsignedLong(LABEL, 16);
                EID proto = ((Struct)this.save.getPapyrus().getStructs().values().stream().findAny().get()).getID();
                EID ID3 = proto.derive(VAL);
                this.findElement((Element)PAPYRUS.getStructs().get(ID3));
                break;
            }
            case "reference": {
                long VAL = Long.parseUnsignedLong(LABEL, 16);
                EID proto = ((Reference)this.save.getPapyrus().getReferences().values().stream().findAny().get()).getID();
                EID ID4 = proto.derive(VAL);
                this.findElement((Element)PAPYRUS.getReferences().get(ID4));
                break;
            }
            case "plugin": {
                List<Plugin> PLUGINS = this.save.getPluginInfo().getPlugins();
                PLUGINS.stream().filter(v -> v.NAME.equalsIgnoreCase(LABEL)).findAny().ifPresent(v -> this.findElement((Element)v));
                break;
            }
            case "array": {
                long VAL = Long.parseUnsignedLong(LABEL, 16);
                EID proto = ((ArrayInfo)this.save.getPapyrus().getArrays().values().stream().findAny().get()).getID();
                EID ID5 = proto.derive(VAL);
                this.findElement((Element)PAPYRUS.getArrays().get(ID5));
                break;
            }
            case "refid": {
                long VAL = Long.parseUnsignedLong(LABEL, 16);
                EID ID6 = EID.make8Byte(VAL);
                RefID REFID = new RefID(ID6);
                this.findElement(this.save.getChangeForms().get(REFID));
                break;
            }
        }
    }

    private void findElement(Element element) {
        if (null == element) {
            return;
        }
        TreePath path = this.TREE.findPath(element);
        if (null == path) {
            JOptionPane.showMessageDialog(this, "The element was not found.", "Not Found", 0);
            return;
        }
        this.TREE.updateUI();
        this.TREE.scrollPathToVisible(path);
        this.TREE.setSelectionPath(path);
    }

    private void findElement(Variable var) {
        Objects.requireNonNull(var);
        if (var instanceof Variable.Array) {
            Variable.Array arrayVar = (Variable.Array)var;
            EID ID2 = arrayVar.getArrayID();
            if (ID2.isZero()) {
                return;
            }
            ArrayInfo array = (ArrayInfo)this.save.getPapyrus().getArrays().get(ID2);
            assert (array == arrayVar.getArray());
            if (null == array) {
                JOptionPane.showMessageDialog(this, "The array with that ID was not found.", "Not Found", 0);
                return;
            }
            this.findElement(array);
        } else if (var.hasRef()) {
            EID ID3 = var.getRef();
            if (ID3.isZero()) {
                return;
            }
            if (null == var.getReferent()) {
                JOptionPane.showMessageDialog(this, "The element with that ID was not found.", "Not Found", 0);
                return;
            }
            this.findElement(var.getReferent());
        }
    }

    private void deleteInstances(Plugin plugin) {
        Objects.requireNonNull(plugin);
        int ROW = this.TREE.getSelectionModel().getLeadSelectionRow();
        String QUESTION = String.format("Are you sure you want to delete all of the script instances associated with this plugin?\n%s", plugin.NAME);
        int result = JOptionPane.showConfirmDialog(this, QUESTION, "Delete Instances", 0);
        if (result == 1) {
            return;
        }
        int numInstances = plugin.getInstances().size();
        int numRemoved = this.save.removePluginInstances(plugin);
        if (numRemoved < numInstances) {
            throw new IllegalStateException(String.format("An error occurred while deleting the plugin's script instances:\n%s", plugin));
        }
        if (numRemoved > 0) {
            this.modified = true;
            this.rebuildTree(true);
        }
        String MSG = String.format("%d Instances deleted.", numInstances);
        LOG.info(MSG);
        JOptionPane.showMessageDialog(this, MSG, "Instances Deleted", 1);
    }

    private void deleteForms(Plugin plugin) {
        Objects.requireNonNull(plugin);
        int ROW = this.TREE.getSelectionModel().getLeadSelectionRow();
        String QUESTION = String.format("Are you sure you want to delete all of the Forms associated with this plugin?\n%s", plugin.NAME);
        int result = JOptionPane.showConfirmDialog(this, QUESTION, "Delete Forms", 0);
        if (result == 1) {
            return;
        }
        int numForms = plugin.getForms().size();
        int numRemoved = this.save.removePluginForms(plugin);
        if (numRemoved < numForms) {
            throw new IllegalStateException(String.format("An error occurred while deleting the plugin's forms:\n%s", plugin));
        }
        if (numRemoved > 0) {
            this.modified = true;
            this.rebuildTree(true);
        }
        String MSG = String.format("%d ChangeForms deleted.", numForms);
        LOG.info(MSG);
        JOptionPane.showMessageDialog(this, MSG, "ChangeForms Deleted", 1);
    }

    private void zeroThreads(List<ActiveScript> threads) {
        Objects.requireNonNull(threads);
        switch (threads.size()) {
            case 0: {
                return;
            }
            case 1: {
                String QUESTION = "Are you sure you want to terminate this thread?";
                String TITLE = "Zero Thread";
                int result = JOptionPane.showConfirmDialog(this, "Are you sure you want to terminate this thread?", "Zero Thread", 0);
                if (result != 1) break;
                return;
            }
            default: {
                String QUESTION = String.format("Are you sure you want to terminate these %d threads?", threads.size());
                String TITLE = "Zero Threads";
                int result = JOptionPane.showConfirmDialog(this, QUESTION, "Zero Threads", 0);
                if (result != 1) break;
                return;
            }
        }
        this.modified = true;
        threads.forEach(t -> t.zero());
        this.rebuildTree(true);
        String MSG = "Thread terminated and zeroed.";
        LOG.info("Thread terminated and zeroed.");
        JOptionPane.showMessageDialog(this, "Thread terminated and zeroed.", "Thread Zeroed", 1);
    }

    private void deletePaths(Map<Element, FilterTreeModel.Node> elements) {
        if (null == this.save || null == elements || 0 == elements.size()) {
            return;
        }
        if (elements.size() == 1) {
            int removed;
            String TITLE;
            String WARN;
            Element ELEMENT = elements.keySet().iterator().next();
            if (ESS.THREAD.test(ELEMENT)) {
                WARN = String.format("Element \"%s\" is a Papyrus thread. Deleting it could make your savefile impossible to load. Are you sure you want to proceed?", ELEMENT.toString());
                TITLE = "Warning";
                int result = JOptionPane.showConfirmDialog(this, WARN, "Warning", 2);
                if (result == 2) {
                    return;
                }
            } else if (ESS.DELETABLE.test(ELEMENT)) {
                String QUESTION = String.format("Are you sure you want to delete this element?\n%s", ELEMENT);
                int result = JOptionPane.showConfirmDialog(this, QUESTION, "Delete Element", 2);
                if (result == 2) {
                    return;
                }
            } else if (ELEMENT instanceof SuspendedStack) {
                WARN = String.format("Element \"%s\" is a Suspended Stack. Deleting it could make your savefile impossible to load. Are you sure you want to proceed?", ELEMENT.toString());
                TITLE = "Warning";
                int result = JOptionPane.showConfirmDialog(this, WARN, "Warning", 2);
                if (result == 2) {
                    return;
                }
            }
            if ((removed = this.save.removeElements(Collections.singleton(ELEMENT))) < 1) {
                throw new IllegalStateException(String.format("Couldn't delete element:\n%s", ELEMENT));
            }
            String MSG = String.format("Element Deleted:\n%s", ELEMENT);
            LOG.info(MSG);
            JOptionPane.showMessageDialog(this, MSG, "Element Deleted", 1);
        } else {
            int result;
            Set DELETABLE = elements.values().stream().filter(v -> v.hasElement()).map(v -> v.getElement()).filter(ESS.DELETABLE).filter(v -> !(v instanceof ActiveScript)).filter(v -> !(v instanceof SuspendedStack)).collect(Collectors.toSet());
            Set STACKS = elements.values().stream().filter(v -> v.hasElement()).map(v -> v.getElement()).filter(v -> v instanceof SuspendedStack).map(v -> (SuspendedStack)v).collect(Collectors.toSet());
            Set<ActiveScript> THREADS = elements.values().stream().filter(v -> v.hasElement()).map(v -> v.getElement()).filter(v -> v instanceof ActiveScript).map(v -> (ActiveScript)v).collect(Collectors.toSet());
            boolean deleteStacks = false;
            if (!STACKS.isEmpty()) {
                String WARN = "Deleting Suspended Stacks could make your savefile impossible to load.\nAre you sure you want to delete the Suspended Stacks?\nIf you select \"No\" then they will be skipped instead of deleted.";
                String TITLE = "Warning";
                int result2 = JOptionPane.showConfirmDialog(this, "Deleting Suspended Stacks could make your savefile impossible to load.\nAre you sure you want to delete the Suspended Stacks?\nIf you select \"No\" then they will be skipped instead of deleted.", "Warning", 1);
                if (result2 == 2) {
                    return;
                }
                deleteStacks = result2 == 0;
            }
            boolean deleteThreads = false;
            if (!THREADS.isEmpty()) {
                String WARN = "Deleting Active Scripts could make your savefile impossible to load.\nAre you sure you want to delete the Active Scripts?\nIf you select \"No\" then they will be terminated instead of deleted.";
                String TITLE = "Warning";
                result = JOptionPane.showConfirmDialog(this, "Deleting Active Scripts could make your savefile impossible to load.\nAre you sure you want to delete the Active Scripts?\nIf you select \"No\" then they will be terminated instead of deleted.", "Warning", 1);
                if (result == 2) {
                    return;
                }
                deleteThreads = result == 0;
            }
            int count = DELETABLE.size();
            count += deleteStacks ? STACKS.size() : 0;
            String QUESTION = String.format("Are you sure you want to delete these %d elements and their dependents?", count += deleteThreads ? THREADS.size() : 0);
            result = JOptionPane.showConfirmDialog(this, QUESTION, "Delete Elements", 0);
            if (result == 1) {
                return;
            }
            int deleted = 0;
            int terminated = 0;
            deleted += this.save.removeElements(DELETABLE);
            if (deleteThreads) {
                deleted += this.save.removeElements(THREADS);
            } else {
                terminated += THREADS.size();
                THREADS.forEach(v -> v.zero());
            }
            if (deleteStacks) {
                deleted += this.save.removeElements(STACKS);
            }
            StringBuilder BUF = new StringBuilder();
            BUF.append(deleted).append(" elements deleted.");
            if (terminated > 0) {
                BUF.append("\n").append(terminated).append(" threads terminated.");
            }
            String MSG = BUF.toString();
            LOG.info(MSG);
            JOptionPane.showMessageDialog(this, MSG, "Elements Deleted", 1);
        }
        int ROW = this.TREE.getSelectionModel().getMaxSelectionRow();
        this.TREE.setSelectionRow(ROW + 1);
        this.modified = true;
        this.rebuildTree(true);
    }

    private void updateContextInformation() {
        TreePath PATH = this.TREE.getSelectionPath();
        if (null == PATH) {
            this.clearContextInformation();
            return;
        }
        Object OBJ = PATH.getLastPathComponent();
        if (!(OBJ instanceof FilterTreeModel.Node)) {
            this.clearContextInformation();
            return;
        }
        FilterTreeModel.Node NODE = (FilterTreeModel.Node)OBJ;
        if (!(NODE.getElement() instanceof Element)) {
            this.clearContextInformation();
            return;
        }
        Element ELEMENT = NODE.getElement();
        this.showContextInformation(ELEMENT);
    }

    private void clearContextInformation() {
        this.INFOPANE.setText("");
        this.TABLE.clearTable();
    }

    private void showContextInformation(Element element) {
        this.TABLE.clearTable();
        if (element instanceof ESS) {
            assert (element == this.save);
            String INFO = this.save.getInfo(this.analysis);
            this.INFOPANE.setText(INFO);
            int width = this.INFOPANE.getWidth() * 95 / 100;
            ImageIcon icon = this.save.getHeader().getImage(width);
            JLabel label = new JLabel(icon);
            Document doc = this.INFOPANE.getDocument();
            StyleContext ctx = new StyleContext();
            Style labelStyle = ctx.getStyle("default");
            StyleConstants.setComponent(labelStyle, label);
            try {
                doc.insertString(doc.getLength(), "Ignored", labelStyle);
            }
            catch (BadLocationException ex) {
                ex.printStackTrace(System.err);
            }
        } else {
            if (element instanceof Plugin) {
                Plugin plugin = (Plugin)element;
                this.INFOPANE.setText(plugin.getInfo(this.analysis, this.save));
            } else if (element instanceof TString) {
                TString str = (TString)element;
                this.INFOPANE.setText(str.getInfo(this.analysis, this.save));
            } else if (element instanceof Plugin) {
                Plugin plugin = (Plugin)element;
                this.INFOPANE.setText(plugin.getInfo(this.analysis, this.save));
            } else if (element instanceof Script) {
                Script script = (Script)element;
                this.INFOPANE.setText(script.getInfo(this.analysis, this.save));
                this.TABLE.displayScript(script, this.save);
            } else if (element instanceof ScriptInstance) {
                ScriptInstance instance = (ScriptInstance)element;
                this.INFOPANE.setText(instance.getInfo(this.analysis, this.save));
                this.TABLE.displayScriptInstance(instance, this.save);
            } else if (element instanceof StructDef) {
                StructDef def = (StructDef)element;
                this.INFOPANE.setText(def.getInfo(this.analysis, this.save));
                this.TABLE.displayStructDef(def, this.save);
            } else if (element instanceof Struct) {
                Struct struct = (Struct)element;
                this.INFOPANE.setText(struct.getInfo(this.analysis, this.save));
                this.TABLE.displayStruct(struct, this.save);
            } else if (element instanceof ArrayInfo) {
                ArrayInfo array = (ArrayInfo)element;
                this.INFOPANE.setText(array.getInfo(this.analysis, this.save));
                this.TABLE.displayArray(array, this.save);
            } else if (element instanceof StackFrame) {
                StackFrame frame = (StackFrame)element;
                this.INFOPANE.setText(frame.getInfo(this.analysis, this.save));
                this.TABLE.displayStackFrame(frame, this.save);
            } else if (element instanceof Reference) {
                Reference ref = (Reference)element;
                this.INFOPANE.setText(ref.getInfo(this.analysis, this.save));
                this.TABLE.displayReference(ref, this.save);
            } else if (element instanceof ActiveScript) {
                ActiveScript script = (ActiveScript)element;
                this.INFOPANE.setText(script.getInfo(this.analysis, this.save));
                this.TABLE.clearTable();
            } else if (element instanceof SuspendedStack) {
                SuspendedStack stack = (SuspendedStack)element;
                this.INFOPANE.setText(stack.getInfo(this.analysis, this.save));
                this.TABLE.clearTable();
            } else if (element instanceof FunctionMessage) {
                FunctionMessage message = (FunctionMessage)element;
                String msg = message.getInfo(this.analysis, this.save);
                this.INFOPANE.setText(message.getInfo(this.analysis, this.save));
                this.TABLE.clearTable();
            } else if (element instanceof FunctionMessageData) {
                FunctionMessageData message = (FunctionMessageData)element;
                String msg = message.getInfo(this.analysis, this.save);
                this.INFOPANE.setText(message.getInfo(this.analysis, this.save));
                this.TABLE.displayFunctionMessageData(message, this.save);
            } else if (element instanceof ChangeForm) {
                ChangeForm form = (ChangeForm)element;
                this.INFOPANE.setText(form.getInfo(this.analysis, this.save));
                this.TABLE.clearTable();
            } else if (element instanceof QueuedUnbind) {
                QueuedUnbind qu = (QueuedUnbind)element;
                this.INFOPANE.setText(qu.getInfo(this.analysis, this.save));
                this.TABLE.clearTable();
            } else {
                this.INFOPANE.setText("");
                this.TABLE.clearTable();
            }
            this.TABLE.getModel().addTableModelListener(e -> {
                this.modified = true;
            });
        }
        this.INFOPANE.setCaretPosition(0);
    }

    private final class PluginListCellRenderer
    implements ListCellRenderer<Plugin> {
        private final BasicComboBoxRenderer RENDERER = new BasicComboBoxRenderer();

        private PluginListCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Plugin value, int index, boolean isSelected, boolean cellHasFocus) {
            if (null == value) {
                return this.RENDERER.getListCellRendererComponent((JList<?>)list, (Object)null, index, isSelected, cellHasFocus);
            }
            return this.RENDERER.getListCellRendererComponent((JList<?>)list, value.NAME, index, isSelected, cellHasFocus);
        }
    }

    private final class ModListCellRenderer
    implements ListCellRenderer<Mod> {
        private final BasicComboBoxRenderer RENDERER = new BasicComboBoxRenderer();

        private ModListCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Mod value, int index, boolean isSelected, boolean cellHasFocus) {
            if (null == value) {
                return this.RENDERER.getListCellRendererComponent((JList<?>)list, (Object)null, index, isSelected, cellHasFocus);
            }
            return this.RENDERER.getListCellRendererComponent((JList<?>)list, value.getName(), index, isSelected, cellHasFocus);
        }
    }
}

