/*
 * Decompiled with CFR 0.152.
 */
package restringer.gui;

import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.util.Objects;
import java.util.logging.Logger;
import javax.swing.JOptionPane;
import javax.swing.SwingWorker;
import restringer.ess.ESS;
import restringer.gui.Configurator;
import restringer.gui.ProgressIndicator;
import restringer.gui.ProgressModel;
import restringer.gui.SaveWindow;

public class Saver
extends SwingWorker<ESS, Double> {
    private final File SAVEFILE;
    private final SaveWindow WINDOW;
    private final ESS SAVE;
    private final boolean PROMPT;
    private final boolean QUIT;
    private static final Logger LOG = Logger.getLogger(Saver.class.getCanonicalName());
    private final WindowAdapter LISTENER = new WindowAdapter(){

        @Override
        public void windowClosing(WindowEvent e) {
            if (!Saver.this.isDone()) {
                Saver.this.cancel(true);
            }
        }
    };

    public Saver(SaveWindow window, File saveFile, ESS save, boolean promptToOpen, boolean quitAfter) {
        this.WINDOW = Objects.requireNonNull(window, "The window field must not be null.");
        this.SAVEFILE = Objects.requireNonNull(saveFile, "The saveFile field must not be null.");
        this.SAVE = Objects.requireNonNull(save, "The save field must not be null.");
        this.PROMPT = promptToOpen;
        this.QUIT = quitAfter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected ESS doInBackground() throws Exception {
        if (!Configurator.validateNewSavegame(this.SAVEFILE)) {
            return null;
        }
        ProgressModel MODEL = new ProgressModel();
        ProgressIndicator.startWaitCursor(this.WINDOW.getRootPane());
        this.WINDOW.addWindowListener(this.LISTENER);
        this.WINDOW.startProgressBar(MODEL);
        try {
            LOG.info("================");
            LOG.info(String.format("Writing to savegame file \"%s\".", this.SAVEFILE));
            ESS.Result RESULT = ESS.writeESS(this.SAVE, this.SAVEFILE, MODEL);
            double time = RESULT.TIME_S;
            double size = RESULT.SIZE_MB;
            StringBuilder MSG = new StringBuilder();
            MSG.append("The savefile was successfully written.");
            MSG.append(String.format("\nWrote %1.1f mb in %1.1f seconds.", size, time));
            if (null != RESULT.BACKUP_FILE) {
                MSG.append(String.format("\nBackup written to %s.", RESULT.BACKUP_FILE));
            }
            if (null != RESULT.COSAVE_FILE) {
                MSG.append(String.format("\n%s co-save was copied.", RESULT.GAME.SCRIPTEXT.toUpperCase()));
            }
            String TITLE = "Save Written";
            JOptionPane.showMessageDialog(this.WINDOW, MSG, "Save Written", 1);
            this.WINDOW.clearModified();
            this.WINDOW.setESS(this.SAVEFILE, this.SAVE);
            if (this.PROMPT) {
                this.WINDOW.open(false);
            } else if (this.QUIT) {
                this.WINDOW.exit();
            }
            ESS eSS = this.SAVE;
            return eSS;
        }
        catch (IOException ex) {
            String MSG = String.format("Error while writing file \"%s\".\n%s", this.SAVEFILE.getName(), ex.getMessage());
            LOG.severe(MSG);
            LOG.severe(ex.toString());
            System.err.println(ex.getMessage());
            ex.printStackTrace(System.err);
            JOptionPane.showMessageDialog(this.WINDOW, MSG, "Write Error", 0);
            ESS eSS = null;
            return eSS;
        }
        catch (Error | Exception ex) {
            String MSG = String.format("Error while writing file \"%s\".\n%s", this.SAVEFILE.getName(), ex.getMessage());
            LOG.severe(MSG);
            LOG.severe(ex.toString());
            System.err.println(ex.getMessage());
            ex.printStackTrace(System.err);
            JOptionPane.showMessageDialog(this.WINDOW, MSG, "Write Error", 0);
            ESS eSS = null;
            return eSS;
        }
        finally {
            this.WINDOW.removeWindowListener(this.LISTENER);
            ProgressIndicator.stopWaitCursor(this.WINDOW.getRootPane());
            this.WINDOW.clearProgressBar();
        }
    }
}

