/*
 * Decompiled with CFR 0.152.
 */
package restringer.gui;

import java.util.Objects;
import java.util.ResourceBundle;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import restringer.ess.papyrus.MemberDesc;
import restringer.ess.papyrus.StructDef;

public class StructDefTableModel
implements TableModel {
    private final StructDef DEF;
    private static final ResourceBundle RES = ResourceBundle.getBundle("restringer/gui/General");
    private static final String[] COLUMNNAMES = StructDefTableModel.getColumnNames();
    private static final Class<?>[] COLUMNTYPES = StructDefTableModel.getColumnTypes();

    public StructDefTableModel(StructDef def) {
        Objects.requireNonNull(def);
        this.DEF = def;
    }

    @Override
    public int getRowCount() {
        return this.DEF.getMembers().size();
    }

    @Override
    public int getColumnCount() {
        return 3;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        assert (0 <= rowIndex && rowIndex < this.getRowCount());
        MemberDesc member = this.DEF.getMembers().get(rowIndex);
        switch (columnIndex) {
            case 0: {
                return rowIndex;
            }
            case 1: {
                return member.getType();
            }
            case 2: {
                return member.getName();
            }
        }
        throw new IllegalStateException();
    }

    @Override
    public String getColumnName(int columnIndex) {
        return COLUMNNAMES[columnIndex];
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return COLUMNTYPES[columnIndex];
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public void addTableModelListener(TableModelListener l) {
    }

    @Override
    public void removeTableModelListener(TableModelListener l) {
    }

    private static String[] getColumnNames() {
        return new String[]{RES.getString("VARIABLETABLEMODEL #"), RES.getString("VARIABLETABLEMODEL TYPE"), RES.getString("VARIABLETABLEMODEL NAME")};
    }

    private static Class<?>[] getColumnTypes() {
        return new Class[]{Integer.class, String.class, String.class};
    }
}

