/*
 * Decompiled with CFR 0.152.
 */
package restringer.gui;

import java.io.File;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.function.Supplier;
import javafx.application.Platform;
import javafx.stage.FileChooser;
import javax.swing.JDialog;
import javax.swing.SwingUtilities;

public class SynchronousFXChooser {
    private final Supplier<FileChooser> fileChooserFactory;

    public SynchronousFXChooser(Supplier<FileChooser> fileChooserFactory) {
        this.fileChooserFactory = fileChooserFactory;
    }

    public <T> T showDialog(Function<FileChooser, T> method) {
        return this.showDialog(method, 1L, TimeUnit.SECONDS);
    }

    public <T> T showDialog(Function<FileChooser, T> method, long timeout, TimeUnit unit) {
        Callable<Object> task = () -> {
            FileChooser chooser = this.fileChooserFactory.get();
            return method.apply(chooser);
        };
        SynchronousJFXCaller<Object> caller = new SynchronousJFXCaller<Object>(task);
        try {
            return (T)caller.call(timeout, unit);
        }
        catch (Error | RuntimeException ex) {
            throw ex;
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            return null;
        }
        catch (Exception ex) {
            throw new AssertionError("Got unexpected checked exception from SynchronousJFXCaller.call()", ex);
        }
    }

    public File showOpenDialog() {
        return this.showDialog(chooser -> chooser.showOpenDialog(null));
    }

    public File showSaveDialog() {
        return this.showDialog(chooser -> chooser.showSaveDialog(null));
    }

    public List<File> showOpenMultipleDialog() {
        return this.showDialog(chooser -> chooser.showOpenMultipleDialog(null));
    }

    private static class SynchronousJFXCaller<T> {
        private final Callable<T> callable;

        public SynchronousJFXCaller(Callable<T> callable) {
            this.callable = callable;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public T call(long startTimeout, TimeUnit startTimeoutUnit) throws Exception {
            CountDownLatch taskStarted = new CountDownLatch(1);
            AtomicBoolean taskCancelled = new AtomicBoolean(false);
            JDialog modalBlocker = new JDialog();
            modalBlocker.setModal(true);
            modalBlocker.setUndecorated(true);
            modalBlocker.setOpacity(0.0f);
            modalBlocker.setDefaultCloseOperation(0);
            CountDownLatch modalityLatch = new CountDownLatch(1);
            FutureTask<Object> task = new FutureTask<Object>(() -> {
                CountDownLatch countDownLatch = taskStarted;
                synchronized (countDownLatch) {
                    if (taskCancelled.get()) {
                        return null;
                    }
                    taskStarted.countDown();
                }
                try {
                    countDownLatch = this.callable.call();
                    return countDownLatch;
                }
                finally {
                    modalityLatch.await();
                    SwingUtilities.invokeLater(() -> modalBlocker.setVisible(false));
                }
            });
            Platform.runLater(task);
            if (!taskStarted.await(startTimeout, startTimeoutUnit)) {
                CountDownLatch countDownLatch = taskStarted;
                synchronized (countDownLatch) {
                    if (!taskStarted.await(0L, TimeUnit.MILLISECONDS)) {
                        taskCancelled.set(true);
                        throw new IllegalStateException("JavaFX was shut down or is unresponsive.");
                    }
                }
            }
            SwingUtilities.invokeLater(() -> modalityLatch.countDown());
            modalBlocker.setVisible(true);
            modalBlocker.dispose();
            try {
                return (T)task.get();
            }
            catch (ExecutionException ex) {
                Throwable ec = ex.getCause();
                if (ec instanceof Exception) {
                    throw (Exception)ec;
                }
                if (ec instanceof Error) {
                    throw (Error)ec;
                }
                throw new AssertionError("Unexpected exception type", ec);
            }
        }
    }
}

