/*
 * Decompiled with CFR 0.152.
 */
package restringer.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import restringer.ess.papyrus.Variable;

final class VariableCellRenderer
extends DefaultTableCellRenderer {
    private final Color DEFAULT_COLOR = super.getForeground();
    private final Color INVALID_COLOR = Color.RED;
    private final Color NULL_COLOR = Color.BLUE;
    private final Font DEFAULT_FONT = super.getFont();
    private final Font INVALID_FONT = super.getFont().deriveFont(2);

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        if (value instanceof Variable) {
            Variable VAR = (Variable)value;
            String STR = ((Variable)value).toValueString();
            Component C = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            C.setForeground(this.DEFAULT_COLOR);
            C.setFont(this.DEFAULT_FONT);
            if (VAR instanceof Variable.Ref) {
                Variable.Ref REF = (Variable.Ref)VAR;
                if (REF.isNull()) {
                    C.setForeground(this.NULL_COLOR);
                } else if (null == REF.getReferent()) {
                    C.setForeground(this.INVALID_COLOR);
                    C.setFont(this.INVALID_FONT);
                }
            }
            return C;
        }
        Component C = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        C.setForeground(this.DEFAULT_COLOR);
        C.setFont(this.DEFAULT_FONT);
        return C;
    }
}

