/*
 * Decompiled with CFR 0.152.
 */
package restringer.gui;

import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ResourceBundle;
import java.util.function.Consumer;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import restringer.ess.ESS;
import restringer.ess.papyrus.ArrayInfo;
import restringer.ess.papyrus.FunctionMessageData;
import restringer.ess.papyrus.Reference;
import restringer.ess.papyrus.Script;
import restringer.ess.papyrus.ScriptInstance;
import restringer.ess.papyrus.StackFrame;
import restringer.ess.papyrus.Struct;
import restringer.ess.papyrus.StructDef;
import restringer.ess.papyrus.Variable;
import restringer.gui.ArrayTableModel;
import restringer.gui.FunctionMessageDataTableModel;
import restringer.gui.ReferenceTableModel;
import restringer.gui.ScriptInstanceTableModel;
import restringer.gui.ScriptTableModel;
import restringer.gui.StackFrameTableModel;
import restringer.gui.StructDefTableModel;
import restringer.gui.StructTableModel;
import restringer.gui.VariableCellEditor;
import restringer.gui.VariableCellRenderer;

public class VariableTable
extends JTable {
    private final JPopupMenu TABLE_POPUP_MENU;
    private final JMenuItem MI_FIND = new JMenuItem(RES.getString("VARIABLETABLE FIND"), 70);
    private Consumer<Variable> queryHandler = null;
    private static final ResourceBundle RES = ResourceBundle.getBundle("restringer/gui/General");

    public VariableTable() {
        this.TABLE_POPUP_MENU = new JPopupMenu(RES.getString("VARIABLETABLE TABLE"));
        this.initComponent();
    }

    private void initComponent() {
        this.setSelectionMode(0);
        this.TABLE_POPUP_MENU.add(this.MI_FIND);
        this.MI_FIND.addActionListener(e -> {
            if (null != this.queryHandler) {
                int viewRow = this.getSelectedRow();
                int modelRow = this.convertRowIndexToModel(viewRow);
                int column = this.getModel().getColumnCount() - 1;
                Object o = this.getModel().getValueAt(modelRow, column);
                assert (o instanceof Variable);
                Variable var = (Variable)o;
                if (var.hasRef() && !var.getRef().isZero()) {
                    this.queryHandler.accept(var);
                }
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    int row = VariableTable.this.rowAtPoint(e.getPoint());
                    int col = VariableTable.this.columnAtPoint(e.getPoint());
                    VariableTable.this.setRowSelectionInterval(row, row);
                    int modelRow = VariableTable.this.convertRowIndexToModel(row);
                    int column = VariableTable.this.getModel().getColumnCount() - 1;
                    Object o = VariableTable.this.getModel().getValueAt(modelRow, column);
                    assert (o instanceof Variable);
                    Variable var = (Variable)o;
                    if (var.hasRef() && !var.getRef().isZero()) {
                        VariableTable.this.TABLE_POPUP_MENU.show(e.getComponent(), e.getX(), e.getY());
                    }
                }
            }
        });
    }

    public void setQueryHandler(Consumer<Variable> newQueryHandler) {
        this.queryHandler = newQueryHandler;
    }

    public void clearTable() {
        this.setModel(new DefaultTableModel());
    }

    public void displayScript(Script script, ESS ess) {
        this.setDefaultRenderer(Variable.class, new VariableCellRenderer());
        this.setDefaultEditor(Variable.class, new VariableCellEditor.Generic(ess));
        this.setModel(new ScriptTableModel(script));
        this.getColumn(this.getColumnName(0)).setMinWidth(25);
        this.getColumn(this.getColumnName(0)).setMaxWidth(25);
    }

    public void displayStructDef(StructDef def, ESS ess) {
        this.setDefaultRenderer(Variable.class, new VariableCellRenderer());
        this.setDefaultEditor(Variable.class, new VariableCellEditor.Generic(ess));
        this.setModel(new StructDefTableModel(def));
        this.getColumn(this.getColumnName(0)).setMinWidth(25);
        this.getColumn(this.getColumnName(0)).setMaxWidth(25);
    }

    public void displayScriptInstance(ScriptInstance instance, ESS ess) {
        this.setDefaultRenderer(Variable.class, new VariableCellRenderer());
        this.setDefaultEditor(Variable.class, new VariableCellEditor.Generic(ess));
        this.setModel(new ScriptInstanceTableModel(instance));
        this.getColumn(this.getColumnName(0)).setMinWidth(25);
        this.getColumn(this.getColumnName(0)).setMaxWidth(25);
        this.getColumn(this.getColumnName(1)).setMinWidth(120);
        this.getColumn(this.getColumnName(1)).setMaxWidth(120);
    }

    public void displayStruct(Struct struct, ESS ess) {
        this.setDefaultRenderer(Variable.class, new VariableCellRenderer());
        this.setDefaultEditor(Variable.class, new VariableCellEditor.Generic(ess));
        this.setModel(new StructTableModel(struct));
        this.getColumn(this.getColumnName(0)).setMinWidth(25);
        this.getColumn(this.getColumnName(0)).setMaxWidth(25);
        this.getColumn(this.getColumnName(1)).setMinWidth(120);
        this.getColumn(this.getColumnName(1)).setMaxWidth(120);
    }

    public void displayArray(ArrayInfo array, ESS ess) {
        this.setDefaultRenderer(Variable.class, new VariableCellRenderer());
        this.setDefaultEditor(Variable.class, new VariableCellEditor.Generic(ess));
        this.setModel(new ArrayTableModel(array));
        this.getColumn(this.getColumnName(0)).setMinWidth(25);
        this.getColumn(this.getColumnName(0)).setMaxWidth(25);
        this.getColumn(this.getColumnName(1)).setMinWidth(120);
        this.getColumn(this.getColumnName(1)).setMaxWidth(120);
    }

    public void displayStackFrame(StackFrame frame, ESS ess) {
        this.setDefaultRenderer(Variable.class, new VariableCellRenderer());
        this.setDefaultEditor(Variable.class, new VariableCellEditor.Generic(ess));
        this.setModel(new StackFrameTableModel(frame));
        this.getColumn(this.getColumnName(0)).setMinWidth(25);
        this.getColumn(this.getColumnName(0)).setMaxWidth(25);
        this.getColumn(this.getColumnName(1)).setMinWidth(120);
        this.getColumn(this.getColumnName(1)).setMaxWidth(120);
    }

    public void displayReference(Reference ref, ESS ess) {
        this.setDefaultRenderer(Variable.class, new VariableCellRenderer());
        this.setDefaultEditor(Variable.class, new VariableCellEditor.Generic(ess));
        this.setModel(new ReferenceTableModel(ref));
        this.getColumn(this.getColumnName(0)).setMinWidth(25);
        this.getColumn(this.getColumnName(0)).setMaxWidth(25);
        this.getColumn(this.getColumnName(1)).setMinWidth(120);
        this.getColumn(this.getColumnName(1)).setMaxWidth(120);
    }

    public void displayFunctionMessageData(FunctionMessageData msg, ESS ess) {
        this.setDefaultRenderer(Variable.class, new VariableCellRenderer());
        this.setDefaultEditor(Variable.class, new VariableCellEditor.Generic(ess));
        this.setModel(new FunctionMessageDataTableModel(msg));
        this.getColumn(this.getColumnName(0)).setMinWidth(25);
        this.getColumn(this.getColumnName(0)).setMaxWidth(25);
        this.getColumn(this.getColumnName(1)).setMinWidth(120);
        this.getColumn(this.getColumnName(1)).setMaxWidth(120);
    }
}

