/*
 * Decompiled with CFR 0.152.
 */
package restringer.pex;

import java.lang.invoke.LambdaMetafactory;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import restringer.IString;
import restringer.pex.DisassemblyException;
import restringer.pex.Opcode;
import restringer.pex.Pex;
import restringer.pex.StringTable;
import restringer.pex.TermMap;
import restringer.pex.VData;
import restringer.pex.VariableType;

public final class Disassembler {
    static final Pattern AUTOVAR_REGEX = Pattern.compile("^::(.+)_var$", 2);

    static void preMap(List<Pex.Function.Instruction> block, List<VariableType> types, TermMap terms) {
        for (int i = 0; i < block.size(); ++i) {
            boolean del;
            Pex.Function.Instruction inst = block.get(i);
            if (null == inst || !(del = Disassembler.makeTerm(inst.OPCODE, inst.ARGS, types, terms))) continue;
            block.set(i, null);
        }
    }

    static List<String> disassemble(List<Pex.Function.Instruction> block, List<VariableType> types, int indent) throws DisassemblyException {
        LinkedList<String> CODE = new LinkedList<String>();
        int ptr = 0;
        try {
            while (ptr < block.size()) {
                Pex.Function.Instruction inst = block.get(ptr);
                if (null == inst) {
                    ++ptr;
                    continue;
                }
                if (inst.OPCODE.isConditional()) {
                    int[] CONDITIONAL = Disassembler.detectConditional(block, ptr);
                    if (null == CONDITIONAL) {
                        throw new DisassemblyException("Incorrect conditional block.");
                    }
                    int ending = ptr + CONDITIONAL[0];
                    List<Pex.Function.Instruction> subBlock = block.subList(ptr, ending);
                    List<String> SUB = Disassembler.disassembleConditional(subBlock, types, indent, false);
                    CODE.addAll(SUB);
                    ptr += CONDITIONAL[0];
                    continue;
                }
                String SUB = Disassembler.disassembleInstruction(inst, types, indent);
                CODE.add(SUB);
                ++ptr;
            }
            return CODE;
        }
        catch (DisassemblyException ex) {
            int pdel;
            CODE.addAll(ex.getPartial());
            for (int i = pdel = ptr + ex.getPtrDelta(); i < block.size(); ++i) {
                Pex.Function.Instruction inst = block.get(i);
                if (null != inst) {
                    CODE.add(String.format("%s%s", Disassembler.tab(indent + 1), inst));
                    continue;
                }
                CODE.add(String.format("%sDELETED", Disassembler.tab(indent + 1)));
            }
            throw new DisassemblyException("Error disassembling.", CODE, block.size(), ex);
        }
    }

    static List<String> disassembleConditional(List<Pex.Function.Instruction> block, List<VariableType> types, int indent, boolean elseif) throws DisassemblyException {
        assert (null != Disassembler.detectConditional(block, 0)) : "Not a conditional block.";
        boolean rhs = false;
        boolean end = false;
        String lhs = "";
        LinkedList<Boolean> stack1 = new LinkedList<Boolean>();
        LinkedList<String> stack2 = new LinkedList<String>();
        for (int ptr = 0; ptr < block.size() && !end; ++ptr) {
            boolean subclause;
            int offset;
            String term;
            String operator;
            Pex.Function.Instruction inst = block.get(ptr);
            if (null == inst) continue;
            Opcode OP = inst.OPCODE;
            int[] IF = Disassembler.detectIF(block, ptr);
            int[] WHILE = Disassembler.detectWHILE(block, ptr);
            boolean bl = end = null != IF || null != WHILE || !OP.isConditional();
            if (OP.isConditional()) {
                operator = OP == Opcode.JMPF ? "&&" : "||";
                term = inst.ARGS.get(0).toString();
                offset = ((VData.Int)inst.ARGS.get(1)).getValue();
            } else {
                operator = "INVALID";
                term = inst.ARGS.get(1).toString();
                offset = Integer.MIN_VALUE;
            }
            if (!rhs && !end) {
                lhs = lhs + term + " " + operator + " ";
                rhs = true;
            } else if (!rhs && end) {
                lhs = lhs + term;
            } else if (rhs && !end) {
                lhs = lhs + term;
                while (!stack1.isEmpty() && rhs) {
                    rhs = (Boolean)stack1.pop();
                    lhs = (String)stack2.pop() + "(" + lhs + ")";
                }
                lhs = "(" + lhs + ") " + operator + " ";
            } else if (rhs && end) {
                lhs = lhs + term;
                while (!stack1.isEmpty() && rhs) {
                    rhs = (Boolean)stack1.pop();
                    lhs = (String)stack2.pop() + "(" + lhs + ")";
                }
            }
            boolean bl2 = subclause = !end && block.subList(ptr + 1, ptr + offset).stream().filter(v -> null != v).anyMatch(v -> v.OPCODE.isConditional());
            if (subclause) {
                stack1.push(rhs);
                stack2.push(lhs);
                rhs = false;
                lhs = "";
            }
            if (!end) continue;
            if (null != IF) {
                List<Pex.Function.Instruction> subBlock = block.subList(ptr, block.size());
                return Disassembler.disassembleIfElseBlock(lhs, subBlock, types, indent, elseif);
            }
            if (null != WHILE) {
                List<Pex.Function.Instruction> subBlock = block.subList(ptr, block.size());
                return Disassembler.disassembleLoop(lhs, subBlock, types, indent);
            }
            String s = Disassembler.disassembleSimple(0, lhs, inst.ARGS, types, indent);
            return Collections.singletonList(s);
        }
        throw new IllegalStateException("Should never have got here.");
    }

    static List<String> disassembleIfElseBlock(String condition, List<Pex.Function.Instruction> block, List<VariableType> types, int indent, boolean elseif) throws DisassemblyException {
        LinkedList<String> CODE = new LinkedList<String>();
        int[] IF = Disassembler.detectIF(block, 0);
        assert (null != IF);
        int offs1 = IF[0];
        int offs2 = IF[1];
        Pex.Function.Instruction begin = block.get(0);
        Pex.Function.Instruction end = block.get(offs1 - 1);
        List<Pex.Function.Instruction> block1 = block.subList(1, offs1 - 1);
        List<Pex.Function.Instruction> block2 = block.subList(offs1, offs1 + offs2 - 1);
        if (elseif) {
            CODE.add(String.format("%sELSEIF %s", Disassembler.tab(indent), condition));
        } else {
            CODE.add(String.format("%sIF %s", Disassembler.tab(indent), condition));
        }
        try {
            List<String> SUB1 = Disassembler.disassemble(block1, types, indent + 1);
            CODE.addAll(SUB1);
        }
        catch (DisassemblyException ex) {
            CODE.addAll(ex.getPartial());
            int pdel = 1 + ex.getPtrDelta();
            throw new DisassemblyException("IF block error.", CODE, pdel, ex);
        }
        for (int ptr = 0; ptr < block2.size(); ++ptr) {
            if (block2.get(ptr) == null) {
                continue;
            }
            int[] CONDITIONAL = Disassembler.detectConditional(block2, ptr);
            if (null == CONDITIONAL) break;
            int ending = CONDITIONAL[0];
            List<Pex.Function.Instruction> subBlock = block2.subList(ptr, ptr + ending);
            try {
                List<String> SUB2 = Disassembler.disassembleConditional(subBlock, types, indent, true);
                CODE.addAll(SUB2);
                return CODE;
            }
            catch (DisassemblyException ex) {
                CODE.addAll(ex.getPartial());
                int pdel = 1 + ex.getPtrDelta();
                throw new DisassemblyException("ELSEIF error.", CODE, pdel, ex);
            }
        }
        if (offs2 > 1) {
            try {
                List<String> SUB3 = Disassembler.disassemble(block2, types, indent + 1);
                CODE.add(String.format("%sELSE", Disassembler.tab(indent)));
                CODE.addAll(SUB3);
                CODE.add(String.format("%sENDIF", Disassembler.tab(indent)));
            }
            catch (DisassemblyException ex) {
                CODE.add(String.format("%sELSE", Disassembler.tab(indent)));
                CODE.addAll(ex.getPartial());
                CODE.add(String.format("%sENDIF", Disassembler.tab(indent)));
                int pdel = 2 + ex.getPtrDelta();
                throw new DisassemblyException("ELSE block error.", CODE, pdel, ex);
            }
        } else {
            CODE.add(String.format("%sENDIF", Disassembler.tab(indent)));
        }
        return CODE;
    }

    static List<String> disassembleLoop(String condition, List<Pex.Function.Instruction> block, List<VariableType> types, int indent) throws DisassemblyException {
        LinkedList<String> CODE = new LinkedList<String>();
        int[] WHILE = Disassembler.detectWHILE(block, 0);
        int offset = WHILE[0];
        List<String> SUB = Disassembler.disassemble(block.subList(1, offset - 1), types, indent + 1);
        CODE.add(String.format("%sWHILE %s", Disassembler.tab(indent), condition));
        CODE.addAll(SUB);
        CODE.add(String.format("%sENDWHILE", Disassembler.tab(indent)));
        return CODE;
    }

    static int[] detectConditional(List<Pex.Function.Instruction> block, int ptr) {
        if (block.isEmpty()) {
            return null;
        }
        Pex.Function.Instruction begin = block.get(ptr);
        if (null == begin || !begin.OPCODE.isConditional()) {
            return null;
        }
        int subptr = ptr;
        while (subptr < block.size()) {
            Pex.Function.Instruction next = block.get(subptr);
            if (null == next) {
                ++subptr;
                continue;
            }
            int[] IF = Disassembler.detectIF(block, subptr);
            int[] WHILE = Disassembler.detectWHILE(block, subptr);
            if (null != IF) {
                return new int[]{subptr - ptr + IF[0] + IF[1] - 1};
            }
            if (null != WHILE) {
                return new int[]{subptr - ptr + WHILE[0]};
            }
            if (!next.OPCODE.isConditional()) {
                // empty if block
            }
            ++subptr;
        }
        return null;
    }

    static int[] detectIF(List<Pex.Function.Instruction> instructions, int ptr) {
        if (instructions.isEmpty() || ptr >= instructions.size() || ptr < 0) {
            return null;
        }
        Pex.Function.Instruction begin = instructions.get(ptr);
        if (null == begin || begin.OPCODE != Opcode.JMPF) {
            return null;
        }
        int offset1 = ((VData.Int)begin.ARGS.get(1)).getValue();
        Pex.Function.Instruction end = instructions.get(ptr + offset1 - 1);
        if (null == end || end.OPCODE != Opcode.JMP) {
            return null;
        }
        int offset2 = ((VData.Int)end.ARGS.get(0)).getValue();
        if (offset2 <= 0) {
            return null;
        }
        return new int[]{offset1, offset2};
    }

    static int[] detectWHILE(List<Pex.Function.Instruction> instructions, int ptr) {
        Pex.Function.Instruction begin = instructions.get(ptr);
        if (null == begin || begin.OPCODE != Opcode.JMPF) {
            return null;
        }
        int offset1 = ((VData.Int)begin.ARGS.get(1)).getValue();
        if (ptr + offset1 - 1 >= instructions.size()) {
            throw new IllegalStateException("Ptr out of range.");
        }
        Pex.Function.Instruction end = instructions.get(ptr + offset1 - 1);
        if (null == end || end.OPCODE != Opcode.JMP) {
            return null;
        }
        int offset2 = ((VData.Int)end.ARGS.get(0)).getValue();
        if (offset2 > 0) {
            return null;
        }
        assert (offset1 <= -offset2) : String.format("Offsets differ: while(%d), endwhile(%d)", offset1, offset2);
        return new int[]{offset1};
    }

    static String disassembleInstruction(Pex.Function.Instruction inst, List<VariableType> types, int indent) {
        String RHS = Disassembler.makeRHS(inst, types);
        switch (inst.OPCODE) {
            case NOP: {
                return "";
            }
            case IADD: 
            case FADD: 
            case ISUB: 
            case FSUB: 
            case IMUL: 
            case FMUL: 
            case IDIV: 
            case FDIV: 
            case IMOD: 
            case STRCAT: 
            case NOT: 
            case INEG: 
            case FNEG: 
            case ASSIGN: 
            case CAST: 
            case CMP_EQ: 
            case CMP_LT: 
            case CMP_LE: 
            case CMP_GT: 
            case CMP_GE: 
            case ARR_CREATE: 
            case ARR_LENGTH: 
            case ARR_GET: {
                return Disassembler.disassembleSimple(0, RHS, inst.ARGS, types, indent);
            }
            case CALLMETHOD: 
            case CALLSTATIC: 
            case PROPGET: {
                return Disassembler.disassembleSimple(2, RHS, inst.ARGS, types, indent);
            }
            case CALLPARENT: 
            case ARR_FIND: 
            case ARR_RFIND: {
                return Disassembler.disassembleSimple(1, RHS, inst.ARGS, types, indent);
            }
            case RETURN: {
                if (null == RHS) {
                    return String.format("%sRETURN", Disassembler.tab(indent));
                }
                return String.format("%sRETURN %s", Disassembler.tab(indent), RHS);
            }
            case PROPSET: {
                VData obj = inst.ARGS.get(1);
                VData.ID prop = (VData.ID)inst.ARGS.get(0);
                return String.format("%s%s.%s = %s", Disassembler.tab(indent), obj, prop, RHS);
            }
            case ARR_SET: {
                VData arr = inst.ARGS.get(0);
                VData idx = inst.ARGS.get(1);
                return String.format("%s%s[%s] = %s", Disassembler.tab(indent), arr, idx, RHS);
            }
        }
        throw new IllegalArgumentException("No code for handling this command: " + inst);
    }

    static String disassembleSimple(int lhsPos, String rhs, List<VData> args, List<VariableType> types, int indent) {
        if (lhsPos < 0 || lhsPos >= args.size()) {
            throw new IllegalArgumentException();
        }
        VData lhs = args.get(lhsPos);
        if (null == lhs || lhs instanceof VData.None) {
            return String.format("%s%s", Disassembler.tab(indent), rhs);
        }
        if (!(lhs instanceof VData.ID)) {
            return String.format("%s%s = %s", Disassembler.tab(indent), lhs, rhs);
        }
        VData.ID var = (VData.ID)lhs;
        if (var.isTemp()) {
            assert (false);
            throw new IllegalArgumentException();
        }
        if (var.isNonevar()) {
            return String.format("%s%s", Disassembler.tab(indent), rhs);
        }
        StringBuilder S = new StringBuilder();
        S.append(Disassembler.tab(indent));
        types.stream().filter(v -> v.name.equals(var.getValue()) && v.isLocal()).findAny().ifPresent(v -> {
            types.remove(v);
            S.append(v.TYPE).append(" ");
        });
        S.append(String.format("%s = %s", lhs, rhs));
        return S.toString();
    }

    static boolean makeTerm(Opcode op, List<VData> args, List<VariableType> types, TermMap terms) {
        switch (op) {
            case IADD: 
            case FADD: 
            case STRCAT: {
                Disassembler.replaceVariables(args, terms, 0);
                VData operand1 = args.get(1);
                VData operand2 = args.get(2);
                String term = String.format("%s + %s", operand1.paren(), operand2.paren());
                return Disassembler.processTerm(args, terms, 0, term);
            }
            case ISUB: 
            case FSUB: {
                Disassembler.replaceVariables(args, terms, 0);
                VData operand1 = args.get(1);
                VData operand2 = args.get(2);
                String term = String.format("%s - %s", operand1.paren(), operand2.paren());
                return Disassembler.processTerm(args, terms, 0, term);
            }
            case IMUL: 
            case FMUL: {
                Disassembler.replaceVariables(args, terms, 0);
                VData operand1 = args.get(1);
                VData operand2 = args.get(2);
                String term = String.format("%s * %s", operand1.paren(), operand2.paren());
                return Disassembler.processTerm(args, terms, 0, term);
            }
            case IDIV: 
            case FDIV: {
                Disassembler.replaceVariables(args, terms, 0);
                VData operand1 = args.get(1);
                VData operand2 = args.get(2);
                String term = String.format("%s / %s", operand1.paren(), operand2.paren());
                return Disassembler.processTerm(args, terms, 0, term);
            }
            case IMOD: {
                Disassembler.replaceVariables(args, terms, 0);
                VData operand1 = args.get(1);
                VData operand2 = args.get(2);
                String term = String.format("%s %% %s", operand1.paren(), operand2.paren());
                return Disassembler.processTerm(args, terms, 0, term);
            }
            case RETURN: {
                Disassembler.replaceVariables(args, terms, -1);
                return false;
            }
            case CALLMETHOD: {
                Disassembler.replaceVariables(args, terms, 2);
                VData.ID method = (VData.ID)args.get(0);
                VData obj = args.get(1);
                List subArgs = args.subList(4, args.size()).stream().map(v -> v.toString()).collect(Collectors.toList());
                String term = String.format("%s.%s%s", obj, method, Disassembler.paramList(subArgs));
                return Disassembler.processTerm(args, terms, 2, term);
            }
            case CALLPARENT: {
                Disassembler.replaceVariables(args, terms, 1);
                VData.ID method = (VData.ID)args.get(0);
                List subArgs = args.subList(3, args.size()).stream().map(v -> v.toString()).collect(Collectors.toList());
                String term = String.format("parent.%s%s", method, Disassembler.paramList(subArgs));
                return Disassembler.processTerm(args, terms, 1, term);
            }
            case CALLSTATIC: {
                Disassembler.replaceVariables(args, terms, 2);
                VData obj = args.get(0);
                VData.ID method = (VData.ID)args.get(1);
                List subArgs = args.subList(4, args.size()).stream().map(v -> v.toString()).collect(Collectors.toList());
                String term = String.format("%s.%s%s", obj, method, Disassembler.paramList(subArgs));
                return Disassembler.processTerm(args, terms, 2, term);
            }
            case NOT: {
                Disassembler.replaceVariables(args, terms, 0);
                String term = String.format("!%s", args.get(1).paren());
                return Disassembler.processTerm(args, terms, 0, term);
            }
            case INEG: 
            case FNEG: {
                Disassembler.replaceVariables(args, terms, 0);
                String term = String.format("-%s", args.get(1).paren());
                return Disassembler.processTerm(args, terms, 0, term);
            }
            case ASSIGN: {
                Disassembler.replaceVariables(args, terms, 0);
                String term = String.format("%s", args.get(1));
                return Disassembler.processTerm(args, terms, 0, term);
            }
            case CAST: {
                Disassembler.replaceVariables(args, terms, 0);
                VData.ID dest = (VData.ID)args.get(0);
                VData arg = args.get(1);
                StringTable.TString name = dest.getValue();
                StringTable.TString type = types.stream().filter((Predicate<VariableType>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$makeTerm$7(restringer.IString restringer.pex.VariableType ), (Lrestringer/pex/VariableType;)Z)((IString)name)).findFirst().get().TYPE;
                String term = type.equals(IString.get("bool")) ? arg.toString() : (type.equals(IString.get("string")) ? arg.toString() : String.format("%s as %s", arg.paren(), type));
                return Disassembler.processTerm(args, terms, 0, term);
            }
            case PROPGET: {
                Disassembler.replaceVariables(args, terms, 2);
                VData obj = args.get(1);
                VData prop = args.get(0);
                String term = String.format("%s.%s", obj, prop);
                return Disassembler.processTerm(args, terms, 2, term);
            }
            case PROPSET: {
                Disassembler.replaceVariables(args, terms, -1);
                return false;
            }
            case CMP_EQ: {
                Disassembler.replaceVariables(args, terms, 0);
                VData operand1 = args.get(1);
                VData operand2 = args.get(2);
                String term = String.format("%s == %s", operand1.paren(), operand2.paren());
                return Disassembler.processTerm(args, terms, 0, term);
            }
            case CMP_LT: {
                Disassembler.replaceVariables(args, terms, 0);
                VData operand1 = args.get(1);
                VData operand2 = args.get(2);
                String term = String.format("%s < %s", operand1.paren(), operand2.paren());
                return Disassembler.processTerm(args, terms, 0, term);
            }
            case CMP_LE: {
                Disassembler.replaceVariables(args, terms, 0);
                VData operand1 = args.get(1);
                VData operand2 = args.get(2);
                String term = String.format("%s <= %s", operand1.paren(), operand2.paren());
                return Disassembler.processTerm(args, terms, 0, term);
            }
            case CMP_GT: {
                Disassembler.replaceVariables(args, terms, 0);
                VData operand1 = args.get(1);
                VData operand2 = args.get(2);
                String term = String.format("%s > %s", operand1.paren(), operand2.paren());
                return Disassembler.processTerm(args, terms, 0, term);
            }
            case CMP_GE: {
                Disassembler.replaceVariables(args, terms, 0);
                VData operand1 = args.get(1);
                VData operand2 = args.get(2);
                String term = String.format("%s >= %s", operand1.paren(), operand2.paren());
                return Disassembler.processTerm(args, terms, 0, term);
            }
            case ARR_CREATE: {
                VData size = args.get(1);
                VData.ID dest = (VData.ID)args.get(0);
                StringTable.TString name = dest.getValue();
                StringTable.TString type = types.stream().filter((Predicate<VariableType>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$makeTerm$8(restringer.IString restringer.pex.VariableType ), (Lrestringer/pex/VariableType;)Z)((IString)name)).findFirst().get().TYPE;
                String subtype = type.toString().substring(0, type.length() - 2);
                String term = String.format("new %s[%s]", subtype, size);
                return Disassembler.processTerm(args, terms, 0, term);
            }
            case ARR_LENGTH: {
                Disassembler.replaceVariables(args, terms, 0);
                String term = String.format("%s.length", args.get(1));
                return Disassembler.processTerm(args, terms, 0, term);
            }
            case ARR_GET: {
                Disassembler.replaceVariables(args, terms, 0);
                VData idx = args.get(2);
                VData arr = args.get(1);
                String term = String.format("%s[%s]", arr, idx);
                return Disassembler.processTerm(args, terms, 0, term);
            }
            case ARR_SET: {
                Disassembler.replaceVariables(args, terms, -1);
                return false;
            }
            case JMPT: 
            case JMPF: {
                Disassembler.replaceVariables(args, terms, -1);
                return false;
            }
            case ARR_FIND: {
                Disassembler.replaceVariables(args, terms, 1);
                VData arr = args.get(0);
                VData search = args.get(2);
                VData.Int idx = (VData.Int)args.get(3);
                String term = String.format("%s.find(%s, %s)", arr, search, idx);
                return Disassembler.processTerm(args, terms, 1, term);
            }
            case ARR_RFIND: {
                Disassembler.replaceVariables(args, terms, 1);
                VData arr = args.get(0);
                VData search = args.get(2);
                VData.Int idx = (VData.Int)args.get(3);
                String term = String.format("%s.rfind(%s, %s)", arr, search, idx);
                return Disassembler.processTerm(args, terms, 1, term);
            }
        }
        return false;
    }

    static String makeRHS(Pex.Function.Instruction inst, List<VariableType> types) {
        switch (inst.OPCODE) {
            case IADD: 
            case FADD: 
            case STRCAT: {
                VData operand1 = inst.ARGS.get(1);
                VData operand2 = inst.ARGS.get(2);
                return String.format("%s + %s", operand1.paren(), operand2.paren());
            }
            case ISUB: 
            case FSUB: {
                VData operand1 = inst.ARGS.get(1);
                VData operand2 = inst.ARGS.get(2);
                return String.format("%s - %s", operand1.paren(), operand2.paren());
            }
            case IMUL: 
            case FMUL: {
                VData operand1 = inst.ARGS.get(1);
                VData operand2 = inst.ARGS.get(2);
                return String.format("%s * %s", operand1.paren(), operand2.paren());
            }
            case IDIV: 
            case FDIV: {
                VData operand1 = inst.ARGS.get(1);
                VData operand2 = inst.ARGS.get(2);
                return String.format("%s / %s", operand1.paren(), operand2.paren());
            }
            case IMOD: {
                VData operand1 = inst.ARGS.get(1);
                VData operand2 = inst.ARGS.get(2);
                return String.format("%s %% %s", operand1.paren(), operand2.paren());
            }
            case RETURN: {
                return inst.ARGS.get(0).toString();
            }
            case CALLMETHOD: {
                VData.ID method = (VData.ID)inst.ARGS.get(0);
                VData obj = inst.ARGS.get(1);
                List subArgs = inst.ARGS.subList(4, inst.ARGS.size()).stream().map(v -> v.toString()).collect(Collectors.toList());
                return String.format("%s.%s%s", obj, method, Disassembler.paramList(subArgs));
            }
            case CALLPARENT: {
                VData.ID method = (VData.ID)inst.ARGS.get(0);
                List subArgs = inst.ARGS.subList(3, inst.ARGS.size()).stream().map(v -> v.toString()).collect(Collectors.toList());
                return String.format("parent.%s%s", method, Disassembler.paramList(subArgs));
            }
            case CALLSTATIC: {
                VData obj = inst.ARGS.get(0);
                VData.ID method = (VData.ID)inst.ARGS.get(1);
                List subArgs = inst.ARGS.subList(4, inst.ARGS.size()).stream().map(v -> v.toString()).collect(Collectors.toList());
                return String.format("%s.%s%s", obj, method, Disassembler.paramList(subArgs));
            }
            case NOT: {
                return String.format("NOT %s", inst.ARGS.get(1).paren());
            }
            case INEG: 
            case FNEG: {
                return String.format("-%s", inst.ARGS.get(1).paren());
            }
            case ASSIGN: {
                return inst.ARGS.get(1).toString();
            }
            case CAST: {
                VData.ID dest = (VData.ID)inst.ARGS.get(0);
                VData arg = inst.ARGS.get(1);
                StringTable.TString name = dest.getValue();
                StringTable.TString type = types.stream().filter((Predicate<VariableType>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$makeRHS$12(restringer.IString restringer.pex.VariableType ), (Lrestringer/pex/VariableType;)Z)((IString)name)).findFirst().get().TYPE;
                return String.format("%s as %s", arg.paren(), type);
            }
            case PROPGET: {
                VData obj = inst.ARGS.get(1);
                VData prop = inst.ARGS.get(0);
                return String.format("%s.%s", obj, prop);
            }
            case PROPSET: {
                return inst.ARGS.get(2).toString();
            }
            case CMP_EQ: {
                VData operand1 = inst.ARGS.get(1);
                VData operand2 = inst.ARGS.get(2);
                return String.format("%s == %s", operand1.paren(), operand2.paren());
            }
            case CMP_LT: {
                VData operand1 = inst.ARGS.get(1);
                VData operand2 = inst.ARGS.get(2);
                return String.format("%s < %s", operand1.paren(), operand2.paren());
            }
            case CMP_LE: {
                VData operand1 = inst.ARGS.get(1);
                VData operand2 = inst.ARGS.get(2);
                return String.format("%s <= %s", operand1.paren(), operand2.paren());
            }
            case CMP_GT: {
                VData operand1 = inst.ARGS.get(1);
                VData operand2 = inst.ARGS.get(2);
                return String.format("%s > %s", operand1.paren(), operand2.paren());
            }
            case CMP_GE: {
                VData operand1 = inst.ARGS.get(1);
                VData operand2 = inst.ARGS.get(2);
                return String.format("%s >= %s", operand1.paren(), operand2.paren());
            }
            case ARR_CREATE: {
                VData size = inst.ARGS.get(1);
                VData.ID dest = (VData.ID)inst.ARGS.get(0);
                StringTable.TString name = dest.getValue();
                StringTable.TString type = types.stream().filter((Predicate<VariableType>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$makeRHS$13(restringer.IString restringer.pex.VariableType ), (Lrestringer/pex/VariableType;)Z)((IString)name)).findFirst().get().TYPE;
                String subtype = type.toString().substring(0, type.length() - 2);
                return String.format("new %s[%s]", subtype, size);
            }
            case ARR_LENGTH: {
                return String.format("%s.length", inst.ARGS.get(1));
            }
            case ARR_GET: {
                VData idx = inst.ARGS.get(2);
                VData arr = inst.ARGS.get(1);
                return String.format("%s[%s]", arr, idx);
            }
            case ARR_SET: {
                return inst.ARGS.get(2).toString();
            }
            case JMPT: 
            case JMPF: {
                return inst.ARGS.get(0).toString();
            }
        }
        return String.format("%s", inst.ARGS);
    }

    static boolean processTerm(List<VData> args, TermMap terms, int destPos, String term) {
        if (destPos >= args.size() || !(args.get(destPos) instanceof VData.ID)) {
            return false;
        }
        VData.ID dest = (VData.ID)args.get(destPos);
        if (!dest.isTemp()) {
            return false;
        }
        terms.put(dest, new VData.Term(term));
        return true;
    }

    static void replaceVariables(List<VData> args, TermMap terms, int exclude) {
        for (int i = 0; i < args.size(); ++i) {
            VData arg = args.get(i);
            if (arg instanceof VData.ID) {
                VData.ID id = (VData.ID)arg;
                if (terms.containsKey(id) && i != exclude) {
                    args.set(i, (VData)terms.get(id));
                    continue;
                }
                if (!id.isAutovar()) continue;
                Matcher MATCHER = AUTOVAR_REGEX.matcher(id.toString());
                MATCHER.matches();
                String prop = MATCHER.group(1);
                terms.put(id, new VData.Term(prop));
                args.set(i, (VData)terms.get(id));
                continue;
            }
            if (!(arg instanceof VData.Str)) continue;
            VData.Str str = (VData.Str)arg;
            args.set(i, new VData.StrLit(str.getString().toString()));
        }
    }

    static <T> String paramList(List<T> params) {
        return params.stream().map(p -> p.toString()).collect(Collectors.joining(", ", "(", ")"));
    }

    public static String tab(int n) {
        StringBuilder BUF = new StringBuilder();
        for (int i = 0; i < n; ++i) {
            BUF.append('\t');
        }
        return BUF.toString();
    }

    private static /* synthetic */ boolean lambda$makeRHS$13(IString name, VariableType t) {
        return t.name.equals(name);
    }

    private static /* synthetic */ boolean lambda$makeRHS$12(IString name, VariableType t) {
        return t.name.equals(name);
    }

    private static /* synthetic */ boolean lambda$makeTerm$8(IString name, VariableType t) {
        return t.name.equals(name);
    }

    private static /* synthetic */ boolean lambda$makeTerm$7(IString name, VariableType t) {
        return t.name.equals(name);
    }
}

