/*
 * Decompiled with CFR 0.152.
 */
package restringer.pex;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import restringer.Game;
import restringer.IString;
import restringer.Scheme;
import restringer.pex.AssemblyLevel;
import restringer.pex.DataType;
import restringer.pex.Disassembler;
import restringer.pex.DisassemblyException;
import restringer.pex.Opcode;
import restringer.pex.ScriptStats;
import restringer.pex.StringTable;
import restringer.pex.TermMap;
import restringer.pex.TokenGenerator;
import restringer.pex.UserFlag;
import restringer.pex.VData;
import restringer.pex.VariableType;

public final class Pex {
    public final StringTable.TString NAME;
    public int size;
    public final StringTable.TString PARENTNAME;
    public StringTable.TString docString;
    public final int USERFLAGS;
    public final StringTable.TString AUTOSTATENAME;
    private final List<Variable> VARIABLES;
    private final List<Property> PROPERTIES;
    private final List<State> STATES;
    private final Map<Property, Variable> AUTOVARMAP;
    private final List<UserFlag> USERFLAGDEFS;
    private final StringTable STRINGS;
    private static final IString[] _EXCLUDED = new IString[]{IString.get("player"), IString.get("playerref")};
    static final Set<IString> EXCLUDED = new HashSet<IString>(Arrays.asList(_EXCLUDED));

    Pex(DataInput input, Game game, List<UserFlag> flags, StringTable strings) throws IOException {
        Objects.requireNonNull(input);
        this.USERFLAGDEFS = Objects.requireNonNull(flags);
        this.STRINGS = Objects.requireNonNull(strings);
        this.NAME = strings.read(input);
        this.size = input.readInt();
        this.PARENTNAME = strings.read(input);
        this.docString = strings.read(input);
        this.USERFLAGS = input.readInt();
        this.AUTOSTATENAME = strings.read(input);
        this.AUTOVARMAP = new HashMap<Property, Variable>();
        int numVariables = input.readUnsignedShort();
        this.VARIABLES = new ArrayList<Variable>(numVariables);
        for (int i = 0; i < numVariables; ++i) {
            this.VARIABLES.add(new Variable(input, strings));
        }
        int numProperties = input.readUnsignedShort();
        this.PROPERTIES = new ArrayList<Property>(numProperties);
        for (int i = 0; i < numProperties; ++i) {
            this.PROPERTIES.add(new Property(input, strings));
        }
        int numStates = input.readUnsignedShort();
        this.STATES = new ArrayList<State>(numStates);
        for (int i = 0; i < numStates; ++i) {
            this.STATES.add(new State(input, strings));
        }
        this.PROPERTIES.forEach(prop -> {
            if (prop.hasAutoVar()) {
                for (Variable var : this.VARIABLES) {
                    if (!prop.autoVarName.equals(var.name)) continue;
                    this.AUTOVARMAP.put((Property)prop, var);
                    break;
                }
                assert (this.AUTOVARMAP.containsKey(prop));
            }
        });
    }

    void write(DataOutput output) throws IOException {
        this.NAME.write(output);
        this.size = this.calculateSize();
        output.writeInt(this.size);
        this.PARENTNAME.write(output);
        this.docString.write(output);
        output.writeInt(this.USERFLAGS);
        this.AUTOSTATENAME.write(output);
        output.writeShort(this.VARIABLES.size());
        for (Variable var : this.VARIABLES) {
            var.write(output);
        }
        output.writeShort(this.PROPERTIES.size());
        for (Property prop : this.PROPERTIES) {
            prop.write(output);
        }
        output.writeShort(this.STATES.size());
        for (State state : this.STATES) {
            state.write(output);
        }
    }

    public int calculateSize() {
        int sum = 0;
        sum += 4;
        sum += 2;
        sum += 2;
        sum += 4;
        sum += 2;
        sum += 6;
        sum += this.VARIABLES.stream().mapToInt(v -> v.calculateSize()).sum();
        sum += this.PROPERTIES.stream().mapToInt(v -> v.calculateSize()).sum();
        return sum += this.STATES.stream().mapToInt(v -> v.calculateSize()).sum();
    }

    public void restring2(boolean remapVars, boolean remapProps, boolean remapParams, boolean remapLocals, boolean stripDocs) {
        if (stripDocs && !this.docString.isEmpty()) {
            this.docString = this.STRINGS.blank();
        }
        TokenGenerator GEN = new TokenGenerator();
        Scheme SCHEME = new Scheme();
        if (remapProps) {
            this.PROPERTIES.stream().filter(prop -> prop.hasAutoVar()).filter(prop -> this.AUTOVARMAP.containsKey(prop)).filter(prop -> !this.AUTOVARMAP.get(prop).isConditional()).filter(prop -> !EXCLUDED.contains(prop.name)).forEach(prop -> {
                StringTable.TString newName = this.STRINGS.addString(GEN.next());
                SCHEME.put(prop.autoVarName, newName);
                prop.autoVarName = newName;
                Variable VAR = this.AUTOVARMAP.get(prop);
                VAR.name = newName;
            });
        }
        if (remapVars) {
            this.VARIABLES.stream().filter(v -> !v.isConditional()).filter(v -> !this.AUTOVARMAP.containsValue(v)).forEach(var -> {
                StringTable.TString newName = this.STRINGS.addString(GEN.next());
                SCHEME.put(var.name, newName);
                var.name = this.STRINGS.addString(newName);
            });
        }
        this.PROPERTIES.forEach(prop -> {
            if (stripDocs) {
                if (!prop.docString.isEmpty()) {
                    prop.docString = this.STRINGS.blank();
                }
                if (!((Property)prop).READHANDLER.docString.isEmpty()) {
                    ((Property)prop).READHANDLER.docString = this.STRINGS.blank();
                }
                if (!((Property)prop).WRITEHANDLER.docString.isEmpty()) {
                    ((Property)prop).WRITEHANDLER.docString = this.STRINGS.blank();
                }
            }
            if (prop.hasReadHandler()) {
                ((Property)prop).READHANDLER.INSTRUCTIONS.forEach(instr -> instr.remapVariables(SCHEME));
            }
            if (prop.hasWriteHandler()) {
                ((Property)prop).WRITEHANDLER.INSTRUCTIONS.forEach(instr -> instr.remapVariables(SCHEME));
            }
        });
        this.STATES.forEach(state -> state.FUNCTIONS.forEach(func -> {
            if (stripDocs && !func.docString.isEmpty()) {
                func.docString = this.STRINGS.blank();
            }
            TokenGenerator FN_GEN = GEN.clone();
            Scheme FN_SCHEME = SCHEME.clone();
            if (remapParams) {
                ((Function)func).PARAMS.forEach(param -> {
                    StringTable.TString newName = this.STRINGS.addString(FN_GEN.next());
                    FN_SCHEME.put(param.name, newName);
                    param.name = newName;
                });
            }
            if (remapLocals) {
                ((Function)func).LOCALS.stream().filter(local -> !local.name.matches("::.+")).forEach(local -> {
                    IString newName = FN_GEN.next();
                    FN_SCHEME.put(local.name, newName);
                    local.name = this.STRINGS.addString(newName);
                });
            }
            ((Function)func).INSTRUCTIONS.forEach(instr -> instr.remapVariables(FN_SCHEME));
        }));
    }

    public void collectStrings(Set<StringTable.TString> strings) {
        strings.add(this.NAME);
        strings.add(this.PARENTNAME);
        strings.add(this.docString);
        strings.add(this.AUTOSTATENAME);
        this.VARIABLES.forEach(var -> var.collectStrings(strings));
        this.PROPERTIES.forEach(prop -> prop.collectStrings(strings));
        this.STATES.forEach(state -> state.collectStrings(strings));
    }

    public Set<IString> getPropertyNames() {
        return this.PROPERTIES.stream().map(p -> p.name).collect(Collectors.toSet());
    }

    public Set<IString> getVariableNames() {
        return this.VARIABLES.stream().map(p -> p.name).collect(Collectors.toSet());
    }

    public Set<IString> getFunctionNames() {
        HashSet<IString> NAMES = new HashSet<IString>();
        this.STATES.forEach(state -> state.FUNCTIONS.forEach(func -> NAMES.add(func.getFullName())));
        return NAMES;
    }

    public Set<UserFlag> getFlags(int userFlags) {
        HashSet<UserFlag> FLAGS = new HashSet<UserFlag>();
        this.USERFLAGDEFS.forEach(flag -> {
            if (flag.matches(userFlags)) {
                FLAGS.add((UserFlag)flag);
            }
        });
        return FLAGS;
    }

    public void analyze(ScriptStats stats) {
        if (!this.docString.isEmpty()) {
            stats.modDocStrings(1);
        }
        this.PROPERTIES.forEach(prop -> {
            if (!prop.docString.isEmpty()) {
                stats.modDocStrings(1);
            }
            if (prop.hasReadHandler()) {
                stats.modLocalVariables(((Property)prop).READHANDLER.LOCALS.size());
                if (!((Property)prop).READHANDLER.docString.isEmpty()) {
                    stats.modDocStrings(1);
                }
            }
            if (prop.hasWriteHandler()) {
                stats.modLocalVariables(((Property)prop).WRITEHANDLER.LOCALS.size());
                if (!((Property)prop).WRITEHANDLER.docString.isEmpty()) {
                    stats.modDocStrings(1);
                }
            }
        });
        this.VARIABLES.forEach(var -> {
            stats.modObjectVariables(1);
            if (var.isConditional()) {
                stats.modConditionals(1);
            } else if (this.AUTOVARMAP.containsValue(var)) {
                stats.modAutoVariables(1);
            }
        });
        this.STATES.forEach(state -> state.FUNCTIONS.forEach(func -> {
            if (!func.docString.isEmpty()) {
                stats.modDocStrings(1);
            }
            stats.modParameters(((Function)func).PARAMS.size());
            stats.modLocalVariables(((Function)func).LOCALS.size());
        }));
    }

    public void disassemble(List<String> code, AssemblyLevel level) {
        StringBuilder S = new StringBuilder();
        if (this.PARENTNAME == null) {
            S.append(String.format("ScriptName %s", this.NAME));
        } else {
            S.append(String.format("ScriptName %s extends %s", this.NAME, this.PARENTNAME));
        }
        Set<UserFlag> FLAGOBJS = this.getFlags(this.USERFLAGS);
        FLAGOBJS.forEach(flag -> S.append(" ").append(flag));
        code.add(S.toString());
        if (null != this.docString && !this.docString.isEmpty()) {
            code.add(String.format("{%s}\n", this.docString));
        }
        code.add("");
        HashMap AUTOVARS = new HashMap();
        this.PROPERTIES.stream().filter(p -> p.hasAutoVar()).forEach(p -> this.VARIABLES.stream().filter(v -> v.name.equals(p.autoVarName)).forEach(v -> AUTOVARS.put(p, v)));
        ArrayList<Property> sortedProp = new ArrayList<Property>(this.PROPERTIES);
        sortedProp.sort((a, b) -> a.name.compareTo(b.name));
        sortedProp.sort((a, b) -> a.TYPE.compareTo(b.TYPE));
        ArrayList<Variable> sortedVars = new ArrayList<Variable>(this.VARIABLES);
        sortedVars.sort((a, b) -> a.name.compareTo(b.name));
        sortedVars.sort((a, b) -> a.TYPE.compareTo(b.TYPE));
        code.add(";");
        code.add("; PROPERTIES");
        code.add(";");
        sortedProp.forEach(v -> v.disassemble(code, level, AUTOVARS));
        code.add("");
        code.add(";");
        code.add("; VARIABLES");
        code.add(";");
        sortedVars.stream().filter(v -> !AUTOVARS.containsValue(v)).forEach(v -> v.disassemble(code, level));
        code.add("");
        code.add(";");
        code.add("; STATES");
        code.add(";");
        this.STATES.forEach(v -> v.disassemble(code, level, this.AUTOSTATENAME.equals(v.NAME), AUTOVARS));
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(String.format("Object %s extends %s %s\n", this.NAME, this.PARENTNAME, this.getFlags(this.USERFLAGS)));
        buf.append(String.format("\tDoc: %s\n", this.docString));
        buf.append(String.format("\tInitial state: %s\n", this.AUTOSTATENAME));
        buf.append("\n");
        this.PROPERTIES.forEach(prop -> buf.append(prop.toString()));
        this.VARIABLES.forEach(var -> buf.append(var.toString()));
        this.STATES.forEach(state -> buf.append(state.toString()));
        return buf.toString();
    }

    public final class Variable {
        public StringTable.TString name;
        public final StringTable.TString TYPE;
        public final int USERFLAGS;
        public final VData DATA;

        private Variable(DataInput input, StringTable strings) throws IOException {
            this.name = strings.read(input);
            this.TYPE = strings.read(input);
            this.USERFLAGS = input.readInt();
            this.DATA = VData.readVariableData(input, strings);
        }

        private void write(DataOutput output) throws IOException {
            this.name.write(output);
            this.TYPE.write(output);
            output.writeInt(this.USERFLAGS);
            this.DATA.write(output);
        }

        public int calculateSize() {
            int sum = 0;
            sum += 2;
            sum += 2;
            sum += 4;
            return sum += this.DATA.calculateSize();
        }

        public void collectStrings(Set<StringTable.TString> strings) {
            strings.add(this.name);
            strings.add(this.TYPE);
            this.DATA.collectStrings(strings);
        }

        public boolean isConditional() {
            return (this.USERFLAGS & 2) != 0;
        }

        public void disassemble(List<String> code, AssemblyLevel level) {
            StringBuilder S = new StringBuilder();
            if (this.DATA.getType() != DataType.NONE) {
                S.append(String.format("%s %s = %s", this.TYPE, this.name, this.DATA));
            } else {
                S.append(String.format("%s %s", this.TYPE, this.name));
            }
            Set<UserFlag> FLAGOBJS = Pex.this.getFlags(this.USERFLAGS);
            FLAGOBJS.forEach(flag -> S.append(" ").append(flag.toString()));
            code.add(S.toString());
        }

        public String toString() {
            String FORMAT = "\tVariable %s %s = %s %s\n\n";
            return String.format("\tVariable %s %s = %s %s\n\n", this.TYPE, this.name, this.DATA, Pex.this.getFlags(this.USERFLAGS));
        }
    }

    public final class Function {
        public StringTable.TString name;
        public final StringTable.TString RETURNTYPE;
        public StringTable.TString docString;
        public final int USERFLAGS;
        public final byte FLAGS;
        private final List<VariableType> PARAMS;
        private final List<VariableType> LOCALS;
        private final List<Instruction> INSTRUCTIONS;

        private Function(DataInput input, boolean named, StringTable strings) throws IOException {
            this.name = named ? strings.read(input) : null;
            this.RETURNTYPE = strings.read(input);
            this.docString = strings.read(input);
            this.USERFLAGS = input.readInt();
            this.FLAGS = input.readByte();
            int paramsCount = input.readUnsignedShort();
            this.PARAMS = new ArrayList<VariableType>(paramsCount);
            for (int i = 0; i < paramsCount; ++i) {
                this.PARAMS.add(VariableType.readParam(input, strings));
            }
            int localsCount = input.readUnsignedShort();
            this.LOCALS = new ArrayList<VariableType>(localsCount);
            for (int i = 0; i < localsCount; ++i) {
                this.LOCALS.add(VariableType.readLocal(input, strings));
            }
            int instructionsCount = input.readUnsignedShort();
            this.INSTRUCTIONS = new ArrayList<Instruction>(instructionsCount);
            for (int i = 0; i < instructionsCount; ++i) {
                this.INSTRUCTIONS.add(new Instruction(input, strings));
            }
        }

        private void write(DataOutput output) throws IOException {
            if (null != this.name) {
                this.name.write(output);
            }
            this.RETURNTYPE.write(output);
            this.docString.write(output);
            output.writeInt(this.USERFLAGS);
            output.writeByte(this.FLAGS);
            output.writeShort(this.PARAMS.size());
            for (VariableType vt : this.PARAMS) {
                vt.write(output);
            }
            output.writeShort(this.LOCALS.size());
            for (VariableType vt : this.LOCALS) {
                vt.write(output);
            }
            output.writeShort(this.INSTRUCTIONS.size());
            for (Instruction inst : this.INSTRUCTIONS) {
                inst.write(output);
            }
        }

        public int calculateSize() {
            int sum = 0;
            if (null != this.name) {
                sum += 2;
            }
            sum += 2;
            sum += 2;
            sum += 4;
            ++sum;
            sum += 6;
            sum += this.PARAMS.stream().mapToInt(v -> v.calculateSize()).sum();
            sum += this.LOCALS.stream().mapToInt(v -> v.calculateSize()).sum();
            return sum += this.INSTRUCTIONS.stream().mapToInt(v -> v.calculateSize()).sum();
        }

        public void collectStrings(Set<StringTable.TString> strings) {
            if (null != this.name) {
                strings.add(this.name);
            }
            strings.add(this.RETURNTYPE);
            strings.add(this.docString);
            this.PARAMS.forEach(param -> param.collectStrings(strings));
            this.LOCALS.forEach(local -> local.collectStrings(strings));
            this.INSTRUCTIONS.forEach(instr -> instr.collectStrings(strings));
        }

        public IString getFullName() {
            if (this.name != null) {
                return IString.format("%s.%s", Pex.this.NAME, this.name);
            }
            return IString.format("%s.()", Pex.this.NAME);
        }

        public boolean isGlobal() {
            return (this.FLAGS & 1) != 0;
        }

        public boolean isNative() {
            return (this.FLAGS & 2) != 0;
        }

        public void disassemble(List<String> code, AssemblyLevel level, String nameOverride, Map<Property, Variable> autovars, int indent) {
            StringBuilder S = new StringBuilder();
            S.append(Disassembler.tab(indent));
            if (null != this.RETURNTYPE && !this.RETURNTYPE.isEmpty() && !this.RETURNTYPE.equals("NONE")) {
                S.append(this.RETURNTYPE).append(" ");
            }
            if (null != nameOverride) {
                S.append(String.format("Function %s%s", nameOverride, Disassembler.paramList(this.PARAMS)));
            } else {
                S.append(String.format("Function %s%s", this.name, Disassembler.paramList(this.PARAMS)));
            }
            Set<UserFlag> FLAGOBJS = Pex.this.getFlags(this.USERFLAGS);
            FLAGOBJS.forEach(flag -> S.append(String.format(" " + flag.toString(), new Object[0])));
            if (this.isGlobal()) {
                S.append(" GLOBAL");
            }
            if (this.isNative()) {
                S.append(" NATIVE");
            }
            code.add(S.toString());
            if (null != this.docString && !this.docString.isEmpty()) {
                code.add(String.format("%s{%s}", Disassembler.tab(indent + 1), this.docString));
            }
            Set<IString> GROUPS = this.LOCALS.stream().filter(v -> v.isTemp()).map(v -> v.TYPE).collect(Collectors.toSet());
            GROUPS.forEach(t -> {
                StringBuilder DECL = new StringBuilder();
                DECL.append(Disassembler.tab(indent + 1));
                DECL.append("; ").append((CharSequence)t).append(' ');
                DECL.append(this.LOCALS.stream().filter(v -> v.isTemp()).filter(v -> v.TYPE == t).map(v -> v.name).collect(Collectors.joining(", ")));
                code.add(DECL.toString());
            });
            ArrayList<VariableType> types = new ArrayList<VariableType>(this.PARAMS);
            types.addAll(this.LOCALS);
            TermMap terms = new TermMap();
            autovars.forEach((p, v) -> terms.put(new VData.ID(v.name), new VData.Term(p.name.toString())));
            ArrayList<Instruction> block = new ArrayList<Instruction>(this.INSTRUCTIONS);
            switch (level) {
                case STRIPPED: {
                    Disassembler.preMap(block, types, terms);
                }
                case BYTECODE: {
                    block.forEach(v -> code.add(String.format("%s%s", Disassembler.tab(indent + 1), v)));
                    break;
                }
                case FULL: {
                    try {
                        Disassembler.preMap(block, types, terms);
                        List<String> code2 = Disassembler.disassemble(block, types, indent + 1);
                        code.addAll(code2);
                        break;
                    }
                    catch (DisassemblyException ex) {
                        code.addAll(ex.getPartial());
                        String MSG = String.format("Error disassembling %s.", this.getFullName());
                        throw new IllegalStateException(MSG, ex);
                    }
                }
            }
            code.add(String.format("%sEndFunction", Disassembler.tab(indent)));
        }

        public String toString() {
            StringBuilder buf = new StringBuilder();
            if (this.name != null) {
                buf.append(String.format("Function %s ", this.name));
            } else {
                buf.append("Function (UNNAMED) ");
            }
            buf.append(this.PARAMS.toString());
            buf.append(String.format(" returns %s\n", this.RETURNTYPE.toString()));
            buf.append(String.format("\tDoc: %s\n", this.docString.toString()));
            buf.append(String.format("\tFlags: %s\n", Pex.this.getFlags(this.USERFLAGS)));
            buf.append("\tLocals: ");
            buf.append(this.LOCALS.toString());
            buf.append("\n\tBEGIN\n");
            this.INSTRUCTIONS.forEach(instruction -> {
                buf.append("\t\t");
                buf.append(instruction.toString());
                buf.append("\n");
            });
            buf.append("\tEND\n\n");
            return buf.toString();
        }

        public final class Instruction {
            public final byte OP;
            public final Opcode OPCODE;
            public final List<VData> ARGS;

            public Instruction(Opcode code, List<VData> args) {
                this.OP = (byte)code.ordinal();
                this.OPCODE = code;
                this.ARGS = new ArrayList<VData>(args);
            }

            private Instruction(DataInput input, StringTable strings) throws IOException {
                this.OPCODE = Opcode.read(input);
                this.OP = (byte)this.OPCODE.ordinal();
                if (this.OPCODE.ARGS > 0) {
                    this.ARGS = new ArrayList<VData>(this.OPCODE.ARGS);
                    for (int i = 0; i < this.OPCODE.ARGS; ++i) {
                        this.ARGS.add(VData.readVariableData(input, strings));
                    }
                } else if (this.OPCODE.ARGS < 0) {
                    this.ARGS = new ArrayList<VData>(-this.OPCODE.ARGS);
                    for (int i = 0; i < 1 - this.OPCODE.ARGS; ++i) {
                        this.ARGS.add(VData.readVariableData(input, strings));
                    }
                    VData count = this.ARGS.get(-this.OPCODE.ARGS);
                    if (!(count instanceof VData.Int)) {
                        throw new IOException();
                    }
                    int numVargs = ((VData.Int)count).getValue();
                    for (int i = 0; i < numVargs; ++i) {
                        this.ARGS.add(VData.readVariableData(input, strings));
                    }
                } else {
                    this.ARGS = new ArrayList<VData>(0);
                }
            }

            private void write(DataOutput output) throws IOException {
                output.writeByte(this.OP);
                for (VData vd : this.ARGS) {
                    vd.write(output);
                }
            }

            public int calculateSize() {
                int sum = 0;
                ++sum;
                return sum += this.ARGS.stream().mapToInt(v -> v.calculateSize()).sum();
            }

            public void collectStrings(Set<StringTable.TString> strings) {
                this.ARGS.forEach(arg -> arg.collectStrings(strings));
            }

            public String toString() {
                String FORMAT = "%s %s";
                return String.format("%s %s", new Object[]{this.OPCODE, this.ARGS});
            }

            public void remapVariables(Scheme scheme) {
                switch (this.OPCODE) {
                    case CALLSTATIC: {
                        int firstArg = 2;
                        break;
                    }
                    case CALLMETHOD: 
                    case CALLPARENT: 
                    case PROPGET: 
                    case PROPSET: {
                        int firstArg = 1;
                        break;
                    }
                    default: {
                        int firstArg = 0;
                    }
                }
                for (int i = firstArg; i < this.ARGS.size(); ++i) {
                    VData.ID id;
                    VData arg = this.ARGS.get(i);
                    if (arg.getType() != DataType.IDENTIFIER || !scheme.containsKey((id = (VData.ID)arg).getValue())) continue;
                    IString newValue = (IString)scheme.get(id.getValue());
                    StringTable.TString newStr = Pex.this.STRINGS.addString(newValue);
                    id.setValue(newStr);
                }
            }
        }
    }

    public final class State {
        public final StringTable.TString NAME;
        public final List<Function> FUNCTIONS;

        private State(DataInput input, StringTable strings) throws IOException {
            this.NAME = strings.read(input);
            int numFunctions = input.readUnsignedShort();
            this.FUNCTIONS = new ArrayList<Function>(numFunctions);
            for (int i = 0; i < numFunctions; ++i) {
                this.FUNCTIONS.add(new Function(input, true, strings));
            }
        }

        private void write(DataOutput output) throws IOException {
            this.NAME.write(output);
            output.writeShort(this.FUNCTIONS.size());
            for (Function function : this.FUNCTIONS) {
                function.write(output);
            }
        }

        public int calculateSize() {
            int sum = 0;
            sum += 2;
            sum += 2;
            return sum += this.FUNCTIONS.stream().mapToInt(v -> v.calculateSize()).sum();
        }

        public void collectStrings(Set<StringTable.TString> strings) {
            strings.add(this.NAME);
            this.FUNCTIONS.forEach(function -> function.collectStrings(strings));
        }

        public void disassemble(List<String> code, AssemblyLevel level, boolean autostate, Map<Property, Variable> autovars) {
            HashSet<IString> RESERVED = new HashSet<IString>();
            RESERVED.add(IString.get("GoToState"));
            RESERVED.add(IString.get("GetState"));
            StringBuilder S = new StringBuilder();
            if (null == this.NAME || this.NAME.isEmpty()) {
                S.append(";");
            }
            if (autostate) {
                S.append("AUTO ");
            }
            S.append("State ");
            S.append(this.NAME);
            code.add(S.toString());
            code.add("");
            int INDENT = autostate ? 0 : 1;
            this.FUNCTIONS.stream().filter(f -> !RESERVED.contains(f.name)).forEach(f -> {
                f.disassemble(code, level, null, autovars, INDENT);
                code.add("");
            });
            if (null == this.NAME || this.NAME.isEmpty()) {
                code.add(";EndState");
            } else {
                code.add("EndState");
            }
            code.add("");
        }

        public String toString() {
            StringBuilder buf = new StringBuilder();
            buf.append(String.format("\tState %s\n", this.NAME));
            this.FUNCTIONS.forEach(function -> buf.append(function.toString()));
            return buf.toString();
        }
    }

    public final class Property {
        public StringTable.TString name;
        public final StringTable.TString TYPE;
        public StringTable.TString docString;
        public final int USERFLAGS;
        public final byte FLAGS;
        public StringTable.TString autoVarName;
        private final Function READHANDLER;
        private final Function WRITEHANDLER;

        private Property(DataInput input, StringTable strings) throws IOException {
            this.name = strings.read(input);
            this.TYPE = strings.read(input);
            this.docString = strings.read(input);
            this.USERFLAGS = input.readInt();
            this.FLAGS = input.readByte();
            if (this.hasAutoVar()) {
                this.autoVarName = strings.read(input);
            }
            this.READHANDLER = this.hasReadHandler() ? new Function(input, false, strings) : null;
            this.WRITEHANDLER = this.hasWriteHandler() ? new Function(input, false, strings) : null;
        }

        private void write(DataOutput output) throws IOException {
            this.name.write(output);
            this.TYPE.write(output);
            this.docString.write(output);
            output.writeInt(this.USERFLAGS);
            output.writeByte(this.FLAGS);
            if (this.hasAutoVar()) {
                this.autoVarName.write(output);
            }
            if (this.hasReadHandler()) {
                this.READHANDLER.write(output);
            }
            if (this.hasWriteHandler()) {
                this.WRITEHANDLER.write(output);
            }
        }

        public int calculateSize() {
            int sum = 0;
            sum += 2;
            sum += 2;
            sum += 2;
            sum += 4;
            ++sum;
            if (this.hasAutoVar()) {
                sum += 2;
            }
            if (this.hasReadHandler()) {
                sum += this.READHANDLER.calculateSize();
            }
            if (this.hasWriteHandler()) {
                sum += this.WRITEHANDLER.calculateSize();
            }
            return sum;
        }

        public boolean isConditional() {
            return (this.USERFLAGS & 2) != 0;
        }

        public boolean isHidden() {
            return (this.USERFLAGS & 1) != 0;
        }

        public boolean hasAutoVar() {
            return (this.FLAGS & 4) != 0;
        }

        public boolean hasReadHandler() {
            return (this.FLAGS & 5) == 1;
        }

        public boolean hasWriteHandler() {
            return (this.FLAGS & 6) == 2;
        }

        public void collectStrings(Set<StringTable.TString> strings) {
            strings.add(this.name);
            strings.add(this.TYPE);
            strings.add(this.docString);
            if (this.hasAutoVar()) {
                strings.add(this.autoVarName);
            }
            if (this.hasReadHandler()) {
                this.READHANDLER.collectStrings(strings);
            }
            if (this.hasWriteHandler()) {
                this.WRITEHANDLER.collectStrings(strings);
            }
        }

        public IString getFullName() {
            return IString.format("%s.%s", Pex.this.NAME, this.name);
        }

        public void disassemble(List<String> code, AssemblyLevel level, Map<Property, Variable> autovars) {
            Objects.requireNonNull(autovars);
            StringBuilder S = new StringBuilder();
            S.append(String.format("%s Property %s", this.TYPE, this.name));
            if (autovars.containsKey(this) || this.hasAutoVar()) {
                assert (autovars.containsKey(this));
                assert (this.hasAutoVar());
                assert (autovars.get((Object)this).name.equals(this.autoVarName));
                Variable AUTOVAR = autovars.get(this);
                if (AUTOVAR.DATA.getType() != DataType.NONE) {
                    S.append(" = ").append(AUTOVAR.DATA);
                }
                S.append(" AUTO");
                Set<UserFlag> FLAGOBJS = Pex.this.getFlags(AUTOVAR.USERFLAGS);
                FLAGOBJS.forEach(flag -> S.append(" ").append(flag.toString()));
            }
            Set<UserFlag> FLAGOBJS = Pex.this.getFlags(this.USERFLAGS);
            FLAGOBJS.forEach(flag -> S.append(" ").append(flag.toString()));
            if (autovars.containsKey(this) || this.hasAutoVar()) {
                Variable AUTOVAR = autovars.get(this);
                S.append("  ;; --> ").append(AUTOVAR.name);
            }
            code.add(S.toString());
            if (null != this.docString && !this.docString.isEmpty()) {
                code.add(String.format("{%s}", this.docString));
            }
            if (this.hasReadHandler()) {
                assert (null != this.READHANDLER);
                this.READHANDLER.disassemble(code, level, "GET", autovars, 1);
            }
            if (this.hasWriteHandler()) {
                assert (null != this.WRITEHANDLER);
                this.WRITEHANDLER.disassemble(code, level, "SET", autovars, 1);
            }
            if (this.hasReadHandler() || this.hasWriteHandler()) {
                code.add("EndProperty");
            }
        }

        public String toString() {
            StringBuilder buf = new StringBuilder();
            buf.append(String.format("\tProperty %s %s", this.TYPE.toString(), this.name.toString()));
            if (this.hasAutoVar()) {
                buf.append(String.format(" AUTO(%s) ", this.autoVarName));
            }
            buf.append(Pex.this.getFlags(this.USERFLAGS));
            buf.append(String.format("\n\t\tDoc: %s\n", this.docString));
            buf.append(String.format("\t\tFlags: %d\n", this.FLAGS));
            if (this.hasReadHandler()) {
                buf.append("ReadHandler: ");
                buf.append(this.READHANDLER.toString());
            }
            if (this.hasWriteHandler()) {
                buf.append("WriteHandler: ");
                buf.append(this.WRITEHANDLER.toString());
            }
            buf.append("\n");
            return buf.toString();
        }
    }
}

