/*
 * Decompiled with CFR 0.152.
 */
package restringer.pex;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import restringer.Game;
import restringer.IString;
import restringer.LittleEndianInputStream;
import restringer.pex.AssemblyLevel;
import restringer.pex.Pex;
import restringer.pex.ScriptStats;
import restringer.pex.StringTable;
import restringer.pex.UserFlag;

public final class PexFile {
    public final Header HEADER;
    public final StringTable STRINGS;
    public final DebugInfo DEBUG;
    public final List<UserFlag> USERFLAGDEFS;
    public final List<Pex> SCRIPTS;

    public static PexFile readScript(byte[] data) throws IOException {
        int MAGIC;
        try (DataInputStream BIS = new DataInputStream(new ByteArrayInputStream(data, 0, 4));){
            MAGIC = BIS.readInt();
        }
        switch (MAGIC) {
            case -557819910: {
                var3_2 = null;
                try (InputStream INPUT = LittleEndianInputStream.debug(data);){
                    PexFile pexFile = new PexFile(Game.FALLOUT4, (DataInput)((Object)INPUT));
                    return pexFile;
                }
                catch (Throwable throwable) {
                    var3_2 = throwable;
                    throw throwable;
                }
            }
            case -94912290: {
                var3_2 = null;
                try (InputStream INPUT = new DataInputStream(new ByteArrayInputStream(data));){
                    PexFile pexFile = new PexFile(Game.SKYRIM_LE, (DataInput)((Object)INPUT));
                    return pexFile;
                }
                catch (Throwable throwable) {
                    var3_2 = throwable;
                    throw throwable;
                }
            }
        }
        throw new IOException("Invalid magic number.");
    }

    public static PexFile readScript(File scriptFile) throws FileNotFoundException, IOException {
        int MAGIC;
        try (DataInputStream BIS = new DataInputStream(new BufferedInputStream(new FileInputStream(scriptFile)));){
            MAGIC = BIS.readInt();
        }
        switch (MAGIC) {
            case -557819910: {
                var3_2 = null;
                try (InputStream INPUT = LittleEndianInputStream.opend(scriptFile);){
                    PexFile pexFile = new PexFile(Game.FALLOUT4, (DataInput)((Object)INPUT));
                    return pexFile;
                }
                catch (Throwable throwable) {
                    var3_2 = throwable;
                    throw throwable;
                }
            }
            case -94912290: {
                var3_2 = null;
                try (InputStream INPUT = new DataInputStream(new BufferedInputStream(new FileInputStream(scriptFile)));){
                    PexFile pexFile = new PexFile(Game.SKYRIM_LE, (DataInput)((Object)INPUT));
                    return pexFile;
                }
                catch (Throwable throwable) {
                    var3_2 = throwable;
                    throw throwable;
                }
            }
        }
        throw new IOException("Invalid magic number.");
    }

    public static void writeScript(PexFile script, File scriptFile) throws FileNotFoundException, IOException {
        assert (!scriptFile.exists() || scriptFile.isFile());
        assert (!scriptFile.exists() || scriptFile.canWrite());
        try (DataOutputStream dos = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(scriptFile)));){
            script.write(dos);
        }
    }

    private PexFile(Game game, DataInput input) throws IOException {
        int flagCount;
        this.HEADER = new Header(input);
        this.STRINGS = new StringTable(input);
        this.DEBUG = new DebugInfo(input, this.STRINGS);
        this.USERFLAGDEFS = new ArrayList<UserFlag>(flagCount);
        for (flagCount = input.readUnsignedShort(); 0 < flagCount; --flagCount) {
            this.USERFLAGDEFS.add(new UserFlag(input, this.STRINGS));
        }
        int scriptCount = input.readUnsignedShort();
        if (scriptCount < 1) {
            throw new IllegalStateException("Pex files must contain at least one script.");
        }
        this.SCRIPTS = new ArrayList<Pex>(scriptCount);
        while (0 < scriptCount) {
            Pex pex = new Pex(input, game, this.USERFLAGDEFS, this.STRINGS);
            this.SCRIPTS.add(pex);
            --scriptCount;
        }
    }

    public void write(DataOutput output) throws IOException {
        this.HEADER.write(output);
        this.STRINGS.write(output);
        this.DEBUG.write(output);
        output.writeShort((short)this.USERFLAGDEFS.size());
        for (UserFlag flag : this.USERFLAGDEFS) {
            flag.write(output);
        }
        output.writeShort(this.SCRIPTS.size());
        for (Pex pex : this.SCRIPTS) {
            pex.write(output);
        }
    }

    public void rebuildStringTable() {
        LinkedHashSet<StringTable.TString> INUSE = new LinkedHashSet<StringTable.TString>();
        this.DEBUG.collectStrings(INUSE);
        this.USERFLAGDEFS.forEach(flag -> flag.collectStrings(INUSE));
        this.SCRIPTS.forEach(obj -> obj.collectStrings(INUSE));
        this.STRINGS.rebuildStringTable(INUSE);
    }

    public void disassemble(List<String> code, AssemblyLevel level) {
        this.SCRIPTS.forEach(v -> v.disassemble(code, level));
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.HEADER.toString());
        buf.append(this.DEBUG.toString());
        buf.append("USER FLAGS\n");
        buf.append(this.USERFLAGDEFS.toString());
        this.SCRIPTS.forEach(obj -> buf.append("\n\nOBJECT\n").append(obj).append("\n"));
        return buf.toString();
    }

    private IString readIString(DataInput input) throws IOException {
        int index = input.readUnsignedShort();
        if (index < 0 || index >= this.STRINGS.size()) {
            throw new IOException();
        }
        return (IString)this.STRINGS.get(index);
    }

    private void writeIString(IString str, DataOutput output) throws IOException {
        short index = (short)this.STRINGS.indexOf(str);
        output.writeShort(index);
    }

    public long getDate() {
        return this.HEADER.compilationTime;
    }

    public IString getFilename() {
        String SOURCE = this.HEADER.soureFilename;
        String REGEX = "(psc)$";
        String REPLACEMENT = "pex";
        Pattern PATTERN = Pattern.compile("(psc)$", 2);
        Matcher MATCHER = PATTERN.matcher(SOURCE);
        String COMPILED = MATCHER.replaceAll("pex");
        return IString.get(COMPILED);
    }

    public ScriptStats analyze() {
        ScriptStats STATS = new ScriptStats();
        this.SCRIPTS.forEach(obj -> obj.analyze(STATS));
        return STATS;
    }

    final class DebugFunction {
        private final StringTable.TString OBJECTNAME;
        private final StringTable.TString STATENAME;
        private final StringTable.TString FUNCNAME;
        private final byte FUNCTYPE;
        private final List<Integer> INSTRUCTIONS;

        private DebugFunction(DataInput input, StringTable strings) throws IOException {
            this.OBJECTNAME = strings.read(input);
            this.STATENAME = strings.read(input);
            this.FUNCNAME = strings.read(input);
            this.FUNCTYPE = input.readByte();
            int instructionCount = input.readUnsignedShort();
            this.INSTRUCTIONS = new ArrayList<Integer>(instructionCount);
            for (int i = 0; i < instructionCount; ++i) {
                this.INSTRUCTIONS.add(input.readUnsignedShort());
            }
        }

        private void write(DataOutput output) throws IOException {
            this.OBJECTNAME.write(output);
            this.STATENAME.write(output);
            this.FUNCNAME.write(output);
            output.writeByte(this.FUNCTYPE);
            output.writeShort(this.INSTRUCTIONS.size());
            for (int instr : this.INSTRUCTIONS) {
                output.writeShort(instr);
            }
        }

        public void collectStrings(Set<StringTable.TString> strings) {
            strings.add(this.OBJECTNAME);
            strings.add(this.STATENAME);
            strings.add(this.FUNCNAME);
        }

        public IString getFullName() {
            return IString.format("%s.%s", this.OBJECTNAME, this.FUNCNAME);
        }

        public String toString() {
            StringBuilder buf = new StringBuilder();
            buf.append(String.format("%s %s.%s (type %d): ", this.OBJECTNAME, this.STATENAME, this.FUNCNAME, this.FUNCTYPE));
            this.INSTRUCTIONS.forEach(instr -> buf.append(String.format("%04x ", instr)));
            return buf.toString();
        }
    }

    public final class DebugInfo {
        private byte hasDebugInfo;
        private long modificationTime;
        private final List<DebugFunction> DEBUGFUNCTIONS;

        private DebugInfo(DataInput input, StringTable strings) throws IOException {
            this.hasDebugInfo = input.readByte();
            if (this.hasDebugInfo == 0) {
                this.DEBUGFUNCTIONS = new ArrayList<DebugFunction>(0);
            } else {
                this.modificationTime = input.readLong();
                int functionCount = input.readUnsignedShort();
                this.DEBUGFUNCTIONS = new ArrayList<DebugFunction>(functionCount);
                for (int i = 0; i < functionCount; ++i) {
                    this.DEBUGFUNCTIONS.add(new DebugFunction(input, strings));
                }
            }
        }

        private void write(DataOutput output) throws IOException {
            output.write(this.hasDebugInfo);
            if (this.hasDebugInfo != 0) {
                output.writeLong(this.modificationTime);
                output.writeShort(this.DEBUGFUNCTIONS.size());
                for (DebugFunction function : this.DEBUGFUNCTIONS) {
                    function.write(output);
                }
            }
        }

        public void clear() {
            this.hasDebugInfo = 0;
            this.DEBUGFUNCTIONS.clear();
        }

        public void collectStrings(Set<StringTable.TString> strings) {
            this.DEBUGFUNCTIONS.forEach(func -> func.collectStrings(strings));
        }

        public String toString() {
            StringBuilder buf = new StringBuilder();
            buf.append("DEBUGINFO\n");
            this.DEBUGFUNCTIONS.forEach(function -> {
                buf.append("\t");
                buf.append(function.toString());
                buf.append("\n");
            });
            buf.append("\n");
            return buf.toString();
        }
    }

    public final class Header {
        private int magic = 0;
        private int version = 0;
        private long compilationTime = 0L;
        private String soureFilename = "";
        private String userName = "";
        private String machineName = "";

        private Header(DataInput input) throws IOException {
            this.magic = input.readInt();
            this.version = input.readInt();
            this.compilationTime = input.readLong();
            this.soureFilename = input.readUTF();
            this.userName = input.readUTF();
            this.machineName = input.readUTF();
        }

        private void write(DataOutput output) throws IOException {
            output.writeInt(this.magic);
            output.writeInt(this.version);
            output.writeLong(this.compilationTime);
            output.writeUTF(this.soureFilename);
            output.writeUTF(this.userName);
            output.writeUTF(this.machineName);
        }

        public String toString() {
            StringBuilder buf = new StringBuilder();
            buf.append(String.format("%s compiled at %d by %s on %s.\n", this.soureFilename, this.compilationTime, this.userName, this.machineName));
            buf.append(String.format("%h v%d\n\n", this.magic, this.version));
            return buf.toString();
        }
    }
}

