/*
 * Decompiled with CFR 0.152.
 */
package restringer.pex;

import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Map;
import java.util.Objects;

public final class ScriptStats {
    private final Map<Key, Integer> COUNTS = Collections.synchronizedMap(new EnumMap(Key.class));

    public int getTransientStrings() {
        return this.getLocalVariables() + this.getParameters();
    }

    public int getPermanentStrings() {
        return this.getObjectVariables() - this.getConditionals();
    }

    public int getObjectVariables() {
        return this.COUNTS.getOrDefault((Object)Key.OBJECT_VARIABLE, 0);
    }

    public int getAutovars() {
        return this.COUNTS.getOrDefault((Object)Key.AUTOVAR_VARIABLE, 0);
    }

    public int getConditionals() {
        return this.COUNTS.getOrDefault((Object)Key.CONDITIONAL_VARIABLE, 0);
    }

    public int getLocalVariables() {
        return this.COUNTS.getOrDefault((Object)Key.LOCAL_VARIABLE, 0);
    }

    public int getParameters() {
        return this.COUNTS.getOrDefault((Object)Key.PARAMETERS, 0);
    }

    public int getDocStrings() {
        return this.COUNTS.getOrDefault((Object)Key.DOCSTRING, 0);
    }

    public void modObjectVariables(int delta) {
        int val = this.COUNTS.getOrDefault((Object)Key.OBJECT_VARIABLE, 0);
        this.COUNTS.put(Key.OBJECT_VARIABLE, val += delta);
    }

    public void modAutoVariables(int delta) {
        int val = this.COUNTS.getOrDefault((Object)Key.AUTOVAR_VARIABLE, 0);
        this.COUNTS.put(Key.AUTOVAR_VARIABLE, val += delta);
    }

    public void modConditionals(int delta) {
        int val = this.COUNTS.getOrDefault((Object)Key.CONDITIONAL_VARIABLE, 0);
        this.COUNTS.put(Key.CONDITIONAL_VARIABLE, val += delta);
    }

    public void modLocalVariables(int delta) {
        int val = this.COUNTS.getOrDefault((Object)Key.LOCAL_VARIABLE, 0);
        this.COUNTS.put(Key.LOCAL_VARIABLE, val += delta);
    }

    public void modParameters(int delta) {
        int val = this.COUNTS.getOrDefault((Object)Key.PARAMETERS, 0);
        this.COUNTS.put(Key.PARAMETERS, val += delta);
    }

    public void modDocStrings(int delta) {
        int val = this.COUNTS.getOrDefault((Object)Key.DOCSTRING, 0);
        this.COUNTS.put(Key.DOCSTRING, val += delta);
    }

    public void clear() {
        this.COUNTS.clear();
    }

    public void add(ScriptStats other) {
        this.modAutoVariables(other.getAutovars());
        this.modConditionals(other.getConditionals());
        this.modDocStrings(other.getDocStrings());
        this.modLocalVariables(other.getLocalVariables());
        this.modObjectVariables(other.getObjectVariables());
        this.modParameters(other.getParameters());
    }

    public static ScriptStats combine(Collection<ScriptStats> statsGroup) {
        Objects.requireNonNull(statsGroup);
        ScriptStats COMBINED = new ScriptStats();
        for (ScriptStats stats : statsGroup) {
            COMBINED.modAutoVariables(stats.getAutovars());
            COMBINED.modConditionals(stats.getConditionals());
            COMBINED.modDocStrings(stats.getDocStrings());
            COMBINED.modLocalVariables(stats.getLocalVariables());
            COMBINED.modObjectVariables(stats.getObjectVariables());
            COMBINED.modParameters(stats.getParameters());
        }
        return COMBINED;
    }

    private static enum Key {
        OBJECT_VARIABLE,
        AUTOVAR_VARIABLE,
        CONDITIONAL_VARIABLE,
        LOCAL_VARIABLE,
        PARAMETERS,
        DOCSTRING;

    }
}

