/*
 * Decompiled with CFR 0.152.
 */
package restringer.pex;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import restringer.IString;

public final class StringTable
extends ArrayList<TString> {
    public TString read(DataInput input) throws IOException {
        Objects.requireNonNull(input);
        int index = input.readUnsignedShort();
        if (index < 0 || index >= this.size()) {
            throw new IOException(String.format("Invalid TString index: %d (size %d)", index, this.size()));
        }
        TString newString = (TString)this.get(index);
        return newString;
    }

    public TString blank() {
        return this.addString(IString.BLANK);
    }

    public StringTable(DataInput input) throws IOException {
        int strCount = input.readUnsignedShort();
        this.ensureCapacity(strCount);
        for (int i = 0; i < strCount; ++i) {
            try {
                String STR = input.readUTF();
                TString TSTR = new TString(STR, i);
                this.add(TSTR);
                continue;
            }
            catch (IOException ex) {
                throw new IOException("Error reading string #" + i, ex);
            }
        }
    }

    public void write(DataOutput output) throws IOException {
        output.writeShort(this.size());
        for (TString tstr : this) {
            try {
                tstr.writeFull(output);
            }
            catch (IOException ex) {
                throw new IOException("Error writing string #" + tstr.INDEX, ex);
            }
        }
    }

    public void rebuildStringTable(Set<TString> inUse) {
        this.retainAll(this);
    }

    public TString addString(IString val) {
        Optional<TString> match = this.stream().filter(v -> v.equals(val)).findFirst();
        if (match.isPresent()) {
            return match.get();
        }
        TString tstr = new TString(val, this.size());
        this.add(tstr);
        return tstr;
    }

    public static class TString
    extends IString {
        private final int INDEX;

        private TString(CharSequence cs, int index) {
            super(cs);
            this.INDEX = index;
        }

        public void writeFull(DataOutput output) throws IOException {
            output.writeUTF(super.toString());
        }

        public void write(DataOutput output) throws IOException {
            output.writeShort(this.INDEX);
        }
    }
}

