/*
 * Decompiled with CFR 0.152.
 */
package restringer.pex;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Set;
import restringer.pex.StringTable;

public final class UserFlag {
    private final StringTable.TString NAME;
    private final byte FLAGINDEX;

    UserFlag(DataInput input, StringTable strings) throws IOException {
        this.NAME = strings.read(input);
        this.FLAGINDEX = input.readByte();
    }

    void write(DataOutput output) throws IOException {
        this.NAME.write(output);
        output.writeByte(this.FLAGINDEX);
    }

    public void collectStrings(Set<StringTable.TString> strings) {
        strings.add(this.NAME);
    }

    public boolean matches(int userFlags) {
        return ((userFlags >>>= this.FLAGINDEX) & 1) != 0;
    }

    public String toString() {
        String FORMAT = "%s";
        return String.format("%s", this.NAME);
    }
}

