/*
 * Decompiled with CFR 0.152.
 */
package restringer.pex;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import restringer.pex.DataType;
import restringer.pex.StringTable;

public abstract class VData {
    public static VData readVariableData(DataInput input, StringTable strings) throws IOException {
        DataType TYPE2 = DataType.read(input);
        switch (TYPE2) {
            case NONE: {
                return new None();
            }
            case IDENTIFIER: {
                int index = input.readUnsignedShort();
                if (index < 0 || index >= strings.size()) {
                    throw new IOException();
                }
                return new ID((StringTable.TString)strings.get(index));
            }
            case STRING: {
                int index = input.readUnsignedShort();
                if (index < 0 || index >= strings.size()) {
                    throw new IOException();
                }
                return new Str((StringTable.TString)strings.get(index));
            }
            case INTEGER: {
                int val = input.readInt();
                return new Int(val);
            }
            case FLOAT: {
                float val = input.readFloat();
                return new Flt(val);
            }
            case BOOLEAN: {
                boolean val = input.readBoolean();
                return new Bool(val);
            }
        }
        throw new IOException();
    }

    abstract void write(DataOutput var1) throws IOException;

    abstract int calculateSize();

    void collectStrings(Set<StringTable.TString> strings) {
    }

    String paren() {
        return this.toString();
    }

    public abstract DataType getType();

    static class StrLit
    extends VData {
        private final String VALUE;

        public StrLit(String val) {
            this.VALUE = Objects.requireNonNull(val);
        }

        @Override
        void write(DataOutput output) throws IOException {
            throw new IllegalStateException("Not valid for Terms.");
        }

        @Override
        int calculateSize() {
            throw new IllegalStateException("Not valid for Terms.");
        }

        @Override
        public void collectStrings(Set<StringTable.TString> strings) {
            throw new IllegalStateException("Not valid for Terms.");
        }

        @Override
        public DataType getType() {
            return DataType.STRING;
        }

        public String toString() {
            return ("\"" + this.VALUE + "\"").replace("\n", "\\n");
        }

        public String getValue() {
            return this.VALUE;
        }

        public int hashCode() {
            int hash = 7;
            hash = 83 * hash + Objects.hashCode(this.VALUE);
            return hash;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Term other = (Term)obj;
            return Objects.equals(this.VALUE, other.VALUE);
        }
    }

    static class Term
    extends VData {
        private final String VALUE;
        private final String PVALUE;

        public Term(String val) {
            this.VALUE = Objects.requireNonNull(val);
            this.PVALUE = "(" + this.VALUE + ")";
        }

        @Override
        void write(DataOutput output) throws IOException {
            throw new IllegalStateException("Not valid for Terms.");
        }

        @Override
        int calculateSize() {
            throw new IllegalStateException("Not valid for Terms.");
        }

        @Override
        public void collectStrings(Set<StringTable.TString> strings) {
            throw new IllegalStateException("Not valid for Terms.");
        }

        @Override
        public DataType getType() {
            return DataType.IDENTIFIER;
        }

        public String toString() {
            return this.VALUE;
        }

        public String getValue() {
            return this.VALUE;
        }

        public int hashCode() {
            int hash = 7;
            hash = 83 * hash + Objects.hashCode(this.VALUE);
            return hash;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Term other = (Term)obj;
            return Objects.equals(this.VALUE, other.VALUE);
        }

        @Override
        public String paren() {
            return this.PVALUE;
        }
    }

    public static class Bool
    extends VData {
        private final boolean VALUE;

        private Bool(boolean val) {
            this.VALUE = val;
        }

        @Override
        void write(DataOutput output) throws IOException {
            output.writeByte(this.getType().ordinal());
            output.writeBoolean(this.VALUE);
        }

        @Override
        int calculateSize() {
            return 2;
        }

        @Override
        public DataType getType() {
            return DataType.BOOLEAN;
        }

        public String toString() {
            return String.format("%b", this.VALUE);
        }

        public boolean getValue() {
            return this.VALUE;
        }

        public int hashCode() {
            int hash = 7;
            hash = 83 * hash + Boolean.hashCode(this.VALUE);
            return hash;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Bool other = (Bool)obj;
            return this.VALUE == other.VALUE;
        }
    }

    public static class Flt
    extends VData {
        private final float VALUE;

        private Flt(float val) {
            this.VALUE = val;
        }

        @Override
        void write(DataOutput output) throws IOException {
            output.writeByte(this.getType().ordinal());
            output.writeFloat(this.VALUE);
        }

        @Override
        int calculateSize() {
            return 5;
        }

        @Override
        public DataType getType() {
            return DataType.FLOAT;
        }

        public String toString() {
            return String.format("%g", Float.valueOf(this.VALUE));
        }

        public float getValue() {
            return this.VALUE;
        }

        public int hashCode() {
            int hash = 7;
            hash = 83 * hash + Float.hashCode(this.VALUE);
            return hash;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Flt other = (Flt)obj;
            return this.VALUE == other.VALUE;
        }
    }

    public static class Int
    extends VData {
        private final int VALUE;

        private Int(int val) {
            this.VALUE = val;
        }

        @Override
        void write(DataOutput output) throws IOException {
            output.writeByte(this.getType().ordinal());
            output.writeInt(this.VALUE);
        }

        @Override
        int calculateSize() {
            return 5;
        }

        @Override
        public DataType getType() {
            return DataType.INTEGER;
        }

        public String toString() {
            return String.format("%d", this.VALUE);
        }

        public int getValue() {
            return this.VALUE;
        }

        public int hashCode() {
            int hash = 7;
            hash = 83 * hash + Integer.hashCode(this.VALUE);
            return hash;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Int other = (Int)obj;
            return this.VALUE == other.VALUE;
        }
    }

    public static class Str
    extends VData {
        private final StringTable.TString VALUE;

        private Str(StringTable.TString val) {
            this.VALUE = Objects.requireNonNull(val);
        }

        @Override
        void write(DataOutput output) throws IOException {
            output.writeByte(this.getType().ordinal());
            this.VALUE.write(output);
        }

        @Override
        int calculateSize() {
            return 3;
        }

        @Override
        void collectStrings(Set<StringTable.TString> strings) {
            strings.add(this.VALUE);
        }

        @Override
        public DataType getType() {
            return DataType.STRING;
        }

        public String toString() {
            return String.format("\"%s\"", this.VALUE);
        }

        public StringTable.TString getString() {
            return this.VALUE;
        }

        public int hashCode() {
            int hash = 7;
            hash = 83 * hash + this.VALUE.hashCode();
            return hash;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Str other = (Str)obj;
            return Objects.equals(this.VALUE, other.VALUE);
        }
    }

    public static class ID
    extends VData {
        private StringTable.TString value;
        static final Predicate<String> TEMP_PATTERN = Pattern.compile("^::.+$", 2).asPredicate();
        static final Predicate<String> NONE_PATTERN = Pattern.compile("^::NoneVar$", 2).asPredicate();
        static final Predicate<String> AUTOVAR_PATTERN = Pattern.compile("^::(.+)_var$", 2).asPredicate();

        ID(StringTable.TString val) {
            this.value = Objects.requireNonNull(val);
        }

        @Override
        void write(DataOutput output) throws IOException {
            output.writeByte(this.getType().ordinal());
            this.value.write(output);
        }

        @Override
        int calculateSize() {
            return 3;
        }

        @Override
        public void collectStrings(Set<StringTable.TString> strings) {
            strings.add(this.value);
        }

        @Override
        public DataType getType() {
            return DataType.IDENTIFIER;
        }

        public String toString() {
            return this.value.toString();
        }

        public StringTable.TString getValue() {
            return this.value;
        }

        void setValue(StringTable.TString val) {
            this.value = Objects.requireNonNull(val);
        }

        public boolean isTemp() {
            return TEMP_PATTERN.test(this.value.toString()) && !AUTOVAR_PATTERN.test(this.value.toString()) && !NONE_PATTERN.test(this.value.toString());
        }

        public boolean isAutovar() {
            return AUTOVAR_PATTERN.test(this.value.toString());
        }

        public boolean isNonevar() {
            return NONE_PATTERN.test(this.value.toString());
        }

        public int hashCode() {
            int hash = 7;
            hash = 83 * hash + this.value.hashCode();
            return hash;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ID other = (ID)obj;
            return Objects.equals(this.value, other.value);
        }
    }

    public static class None
    extends VData {
        private None() {
        }

        @Override
        void write(DataOutput output) throws IOException {
            output.writeByte(this.getType().ordinal());
        }

        @Override
        int calculateSize() {
            return 1;
        }

        @Override
        public DataType getType() {
            return DataType.NONE;
        }

        public String toString() {
            return "NONE";
        }

        public int hashCode() {
            int hash = 7;
            hash = 83 * hash + None.class.hashCode();
            return hash;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            return this.getClass() == obj.getClass();
        }
    }
}

