/*
 * Decompiled with CFR 0.152.
 */
package restringer.pex;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;
import restringer.pex.StringTable;

final class VariableType {
    public StringTable.TString name;
    public final StringTable.TString TYPE;
    public final Role ROLE;
    static final Pattern TEMP_PATTERN = Pattern.compile("^::.+$");

    public static VariableType readLocal(DataInput input, StringTable strings) throws IOException {
        Objects.requireNonNull(input);
        Objects.requireNonNull(strings);
        return new VariableType(input, strings, Role.LOCAL);
    }

    public static VariableType readParam(DataInput input, StringTable strings) throws IOException {
        Objects.requireNonNull(input);
        Objects.requireNonNull(strings);
        return new VariableType(input, strings, Role.PARAM);
    }

    private VariableType(DataInput input, StringTable strings, Role role) throws IOException {
        Objects.requireNonNull(input);
        Objects.requireNonNull(strings);
        Objects.requireNonNull(role);
        this.name = strings.read(input);
        this.TYPE = strings.read(input);
        this.ROLE = role;
    }

    void write(DataOutput output) throws IOException {
        this.name.write(output);
        this.TYPE.write(output);
    }

    public int calculateSize() {
        return 4;
    }

    public boolean isTemp() {
        return TEMP_PATTERN.asPredicate().test(this.name.toString());
    }

    public void collectStrings(Set<StringTable.TString> strings) {
        strings.add(this.name);
        strings.add(this.TYPE);
    }

    public String toString() {
        String FORMAT = "%s %s";
        return String.format("%s %s", this.TYPE, this.name);
    }

    public boolean isLocal() {
        return this.ROLE == Role.LOCAL;
    }

    public boolean isParam() {
        return this.ROLE == Role.PARAM;
    }

    public static enum Role {
        PARAM,
        LOCAL;

    }
}

