/*
 * Copyright 2017 Mark Fairchild.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package restringer;

import java.util.Objects;
import restringer.esp.ESPIDMap;
import restringer.esp.StringTable;

/**
 * Combines the results of script analysis and ESP analysis.
 * @author Mark Fairchild
 */
final public class Analysis extends Profile.Analysis {
    
    /**
     * Creates a new <code>Analysis</code>.
     * @param profileAnalysis
     * @param ids
     * @param strings 
     */
    public Analysis(Profile.Analysis profileAnalysis, ESPIDMap ids, StringTable strings) {
        this.IDS = Objects.requireNonNull(ids);
        this.STRINGS = Objects.requireNonNull(strings);
        this.MODS.addAll(profileAnalysis.MODS);
        this.SCRIPTS.putAll(profileAnalysis.SCRIPTS);
        this.ESPS.putAll(profileAnalysis.ESPS);
        this.STRING_ORIGINS.putAll(profileAnalysis.STRING_ORIGINS);
        this.SCRIPT_ORIGINS.putAll(profileAnalysis.SCRIPT_ORIGINS);
        this.FUNCTION_ORIGINS.putAll(profileAnalysis.FUNCTION_ORIGINS);
    }
    
    public String getName(int formID) {
        return this.IDS.getName(formID, this.STRINGS);
    }
    
    final public ESPIDMap IDS;
    final public StringTable STRINGS;
}
