/*
 * Copyright 2017 Mark.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package restringer;

import java.io.IOException;

/**
 *
 * @author Mark
 */
public class BytePrinter extends java.io.OutputStream {

    public BytePrinter(java.io.OutputStream o) {
        this.ORIG = new java.io.PrintStream(o);
    }
    
    public void newline() {
        this.pos = 0;
        this.ORIG.print('\n');
    }
    
    @Override
    public void write(int b) throws IOException {
        this.pos++;
        this.ORIG.printf("%02x", (0xFF&b));
        this.ORIG.print(pos % COLUMN_SIZE == 0 ? '\n' : ' ');
    }

    static final private int COLUMN_SIZE = 32;
    private int pos = 0;
    private java.io.PrintStream ORIG;
}
