/*
 * Copyright 2016 Mark Fairchild.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package restringer;

import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.CommandLineParser;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

/**
 *
 * @author Mark Fairchild
 */
public class Main {

    /**
     * @param args the command line arguments
     */
    public static void main(String[] args) {
        // Setup the commandline options.

        final Options OPTIONS = new Options();
        OPTIONS.addOption("b", "bytecode", false, "Disassemble a PEX file to bytecode.");
        OPTIONS.addOption("c", "cleaned", false, "Disassemble a PEX file to cleaned bytecode.");
        OPTIONS.addOption("h", "help", false, "Display these instructions.");
        OPTIONS.addOption("s", "screen", false, "Disassemble to the screen instead of a file.");
        OPTIONS.addOption("1", "resaver", false, "Launch ReSaver.");
        OPTIONS.addOption("2", "restringer", false, "Launch ReStringer.");
        final CommandLineParser PARSER = new DefaultParser();
        final CommandLine LINE;

        // Read the command line and parse it.
        try {
            LINE = PARSER.parse(OPTIONS, args);
        } catch (ParseException ex) {
            System.err.println("Unexpected argument: " + ex.getMessage());
            final HelpFormatter HELP = new HelpFormatter();
            HELP.printHelp("ReAssembler [OPTIONS] [FILE1] [FILE2] [FILE3] ...", OPTIONS);
            return;
        }

        // Display the help message.
        if (LINE.hasOption('h')) {
            final HelpFormatter HELP = new HelpFormatter();
            HELP.printHelp("ReAssembler [OPTIONS] [FILE1] [FILE2] [FILE3] ...", OPTIONS);

        } // Check to run ReSaver.
        else if (LINE.hasOption('1')) {
            ReSaver.execute(LINE);

        } // Check to run ReStringer.
        else if (LINE.hasOption('2')) {
            ReStringer.execute(LINE);
            
        } // Check for PEX arguments and run ReAssembler.
        else if (LINE.getArgList().stream().anyMatch(ReAssembler.FILENAMEPATTERN.asPredicate())) {
            ReAssembler.execute(LINE);
            
        } // Check for a savegame as an argument, and run ReSaver.
        else if (LINE.getArgList().size() == 1) {
            final String ARG = LINE.getArgList().get(0);
            final restringer.Game GAME = restringer.Game.matchFilename(ARG);
            if (GAME != null) {
                ReSaver.execute(LINE);
            }

        } // Display the help message.
        else {
            System.out.println("No scriptfiles!");
            final HelpFormatter HELP = new HelpFormatter();
            HELP.printHelp("ReAssembler [OPTIONS] [FILE1] [FILE2] [FILE3] ...", OPTIONS);
        }
    }

}
