/*
 * Copyright 2016 Mark Fairchild
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package restringer.bsa;

import restringer.LittleEndianRAF;
import java.io.IOException;
import java.util.List;
import java.util.LinkedList;

/**
 * Describes a BSA file record block.
 *
 * @author Mark Fairchild
 * @version 2016/04/28
 */
class FileRecordBlock {

    /**
     * Creates a new <code>FileRecordBlock</code> by reading from a
     * <code>LittleEndianDataInput</code>.
     *
     * @param input The file from which to readFully.
     * @param folder The folder record corresponding to this block of files.
     * @param header The BSAHeader, for flag checking.
     * @throws IOException
     */
    public FileRecordBlock(LittleEndianRAF input, FolderRecord folder, BSAHeader header) throws IOException {
        this.FILERECORDS = new LinkedList<>();
        this.FOLDER = folder;
        
        if (header.isIncludeDirectoryName()) {
            this.NAME = input.readBZString();
        } else {
            this.NAME = this.FOLDER.NAME;
        }
        
        for (int i = 0; i < this.FOLDER.COUNT; i++) {
            FileRecord file = new FileRecord(input, header);
            this.FILERECORDS.add(file);
        }
    }
    
    @Override
    public String toString() {
        return this.NAME;
    }

    final public String NAME;
    final public FolderRecord FOLDER;
    final List<FileRecord> FILERECORDS;
}
