/*
 * Copyright 2016 Mark Fairchild
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package restringer.esp;

import java.util.LinkedList;
import java.util.Objects;
import restringer.Game;

/**
 * Stores the information that ESP elements require to read and write themselves
 * to and from files.
 *
 * @author Mark Fairchild
 */
public class ESPContext {

    /**
     * Create a new <code>ESSContext</code> from an ESS <code>Header</code>.
     *
     * @param game
     * @param tes4
     */
    public ESPContext(Game game, RecordTes4 tes4) {
        Objects.requireNonNull(game);
        this.GAME = game;
        this.TES4 = tes4;
        this.CONTEXT = new LinkedList<>();
        this.IDMAP = new ESPIDMap("name");
    }

    /**
     * Copy constructor.
     *
     * @param orig
     */
    protected ESPContext(ESPContext orig) {
        this.GAME = orig.GAME;
        this.TES4 = orig.TES4;
        this.CONTEXT = new LinkedList<>(orig.CONTEXT);
        this.IDMAP = new ESPIDMap("name");
        this.IDMAP.addAll(orig.IDMAP);
    }

    public void pushContext(CharSequence ctx) {
        this.CONTEXT.push(ctx);
    }

    public void popContext() {
        this.CONTEXT.pop();
    }

    @Override
    public String toString() {
        return this.CONTEXT.toString();
    }
    
    final public Game GAME;
    final public RecordTes4 TES4;
    final private LinkedList<CharSequence> CONTEXT;
    final public ESPIDMap IDMAP;

}
