/*
 * Copyright 2016 Mark Fairchild.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package restringer.esp;

import java.io.IOException;
import java.util.Map;
import restringer.IString;
import restringer.LittleEndianDataOutput;

/**
 * A base interface describing anything that can be read from an ESP.
 * 
 * @author Mark Fairchild
 * @version 2016/04/23
 */
public interface Entry {
    
    /**
     * Writes the Entry.
     * @param output The <code>LittleEndianDataOutput</code> to write.
     * @throws IOException
     */
    abstract public void write(LittleEndianDataOutput output) throws IOException;
    
    /**
     * Calculates the size of the Entry.
     * 
     * @return The size of the Field in bytes.
     */
    abstract public int calculateSize();
    
}
