/*
 * Copyright 2016 Mark Fairchild.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package restringer.esp;

import java.io.IOException;
import restringer.LittleEndianInput;
import restringer.IString;

/**
 * FieldBasic represents an EDID field.
 *
 * @author Mark Fairchild
 * @version 2016/09/08
 */
public class FieldEDID extends FieldBasic {

    /**
     * Creates a new FieldBasic by reading it from a LittleEndianDataInput.
     *
     * @param code The field code.
     * @param input The field data.
     * @param size The amount of data.
     * @param big A flag indicating that this is a BIG field.
     * @param ctx The mod descriptor.
     * @throws IOException Exceptions are not handled at all.
     */
    public FieldEDID(IString code, LittleEndianInput input, int size, boolean big, ESPContext ctx) throws IOException {
        super(code, input, size, big, ctx);
        this.VALUE = new String(super.getData());
    }

    /**
     * @return The string value of the EDID.
     */
    public String getValue() {
        return this.VALUE;
    }
    
    /**
     * Returns a String representation of the Field, which will just be the code
     * string.
     *
     * @return A string representation.
     *
     */
    @Override
    public String toString() {
        final StringBuilder BUF = new StringBuilder();
        BUF.append(this.getCode()).append("=").append(this.VALUE);
        return BUF.toString();
    }

    final private String VALUE;
}
