/*
 * Copyright 2017 Mark Fairchild.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package restringer.ess;

import java.io.IOException;
import java.util.Objects;
import restringer.LittleEndianDataOutput;
import restringer.LittleEndianInput;

/**
 * Manages an extra data field from a change form.
 *
 * @author Mark Fairchild
 */
final public class ChangeFormExtraData extends GeneralElement {

    /**
     * Creates a new <code>ChangeFormExtraData</code> by reading from a
     * <code>LittleEndianDataOutput</code>. No error handling is performed.
     *
     * @param input The input stream.
     * @throws IOException
     */
    public ChangeFormExtraData(LittleEndianInput input) throws IOException {
        Objects.requireNonNull(input);
        super.readVSElemArray(input, "EXTRADATA", in -> new Cell(in));
    }

    static final private class Cell extends GeneralElement {

        public Cell(LittleEndianInput input) throws IOException {
            final byte TYPE = super.readByte(input, "TYPE");
            super.readElement(input, "DATA", in -> new ChangeFormExtraDataData(in, TYPE));
        }
    }
}
