/*
 * Copyright 2016 Mark Fairchild
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package restringer.ess;

import restringer.Game;
import java.util.Objects;

/**
 * Stores the information that ESS elements require to read and write themselves
 * to and from files.
 *
 * @author Mark Fairchild
 */
public class ESSContext {

    /**
     * Create a new <code>ESSContext</code> from an ESS <code>Header</code>.
     *
     * @param header
     * @param formVersion 
     */
    public ESSContext(Header header, int formVersion) {
        Objects.requireNonNull(header);
        this.HEADER = header;
        this.GAME = header.GAME;
        this.VERSION = header.VERSION;
        this.FORMVERSION = formVersion;
    }

    /**
     * Copy constructor.
     *
     * @param orig
     */
    protected ESSContext(ESSContext orig) {
        this(orig.HEADER, orig.FORMVERSION);
    }

    final private Header HEADER;
    final public Game GAME;
    final public int VERSION;
    final public int FORMVERSION;
    
}
