/*
 * Copyright 2016 Mark Fairchild.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package restringer.ess;

import restringer.LittleEndianDataOutput;
import java.io.IOException;

/**
 * Describes a component of a Skyrim savegame.
 * 
 * @author Mark Fairchild
 * @version 2016/05/08
 */
public interface Element {

    /**
     * Write the <code>Element</code> to an output stream.
     * @param output The output stream.
     * @throws java.io.IOException 
     */
    public void write(LittleEndianDataOutput output) throws IOException;

    /**
     * @return The size of the <code>Element</code> in bytes.
     */
    public int calculateSize();
    
    /**
     * Resolves references using the full savefile.
     *
     * @param ess The full savefile.
     * @param owner The owner of the element, or null if it is not owned.
     */
    public void resolveRefs(ESS ess, Element owner);

    /**
     * Assign names to all embedded refids.
     *
     * @param analysis The analysis data.
     */
    public void addNames(restringer.Analysis analysis);

}
