/*
 * Copyright 2016 Mark Fairchild.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package restringer.ess.papyrus;

import java.util.Objects;

/**
 * Stores the information that all Papyrus elements require to read and write
 * themselves to and from files.
 * 
 * @author Mark Fairchild
 */
final public class PapyrusContext extends restringer.ess.ESSContext {
    
    /**
     * Create a new <code>PapyrusContext</code> from an <code>ESSContext</code>
     * and a papyrus <code>StringTable</code>.
     * 
     * @param orig
     * @param strings 
     */
    public PapyrusContext(restringer.ess.ESSContext orig, StringTable strings) {
        super(orig);
        Objects.requireNonNull(strings);                
        this.STRINGS = strings;        
    }
    
    final public StringTable STRINGS;
    
}
