/*
 * Copyright 2016 Mark.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package restringer.gui;

/**
 *
 * @author Mark
 */
public class MemoryLabel extends javax.swing.JLabel {

    public MemoryLabel() {
        super.setFont(new java.awt.Font(java.awt.Font.MONOSPACED, 0, 12));
        this.MEMTIMER = new java.util.Timer();
    }

    /**
     * Starts the update loop.
     */
    public void initialize() {
        this.MEMTIMER.schedule(new java.util.TimerTask() {
            @Override
            public void run() {
                update();
            }
        }, 0, 500);
    }

    /**
     * Ends the update loop.
     */
    public void terminate() {
        this.MEMTIMER.cancel();
        this.MEMTIMER.purge();
    }

    /**
     * Updates the memory display field.
     */
    public void update() {
        String model = System.getProperty("sun.arch.data.model");
        long free = Runtime.getRuntime().freeMemory() / (1 << 20);
        long total = Runtime.getRuntime().totalMemory() / (1 << 20);
        long used = total - free;
        int pct = (int) (100 * free / total);
        long max = Runtime.getRuntime().maxMemory() / (1 << 20);
        String txt = String.format("Java %s bit: using %d/%d mb RAM (%d%%), %dmb max", model, free, total, pct, max);
        this.setText(txt);
    }

    final private java.util.Timer MEMTIMER;
}
