/*
 * Copyright 2016 Mark Fairchild.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package restringer.gui;

import javax.swing.*;
import java.awt.*;
import java.awt.event.MouseAdapter;
import java.util.Objects;

/**
 * Displays progress.
 *
 * @author Mark Fairchild
 * @version 2016/06/03
 */
final public class ProgressIndicator extends JPanel {

    public ProgressIndicator(Frame owner) {
        super.setLayout(new BoxLayout(this, BoxLayout.PAGE_AXIS));
        //super.setOpaque(false);
        super.setBackground(new Color(0,0,0, 128));
        //super.setOpaque(true);
        super.setBorder(BorderFactory.createEtchedBorder());

        this.TOPPANEL = new JPanel();
        this.TOPPANEL.setBackground(Color.BLUE);
        this.TOPPANEL.setAlignmentX(0.5f);
        this.TOPPANEL.setAlignmentY(0.5f);
        this.TOPPANEL.setMaximumSize(new Dimension(200, 30));
        
        this.BOTTOMPANEL = new JPanel();
        this.BOTTOMPANEL.setAlignmentX(0.5f);
        this.BOTTOMPANEL.setAlignmentY(0.5f);
        this.BOTTOMPANEL.setMaximumSize(new Dimension(200, 30));

        this.LABEL = new JLabel(java.util.ResourceBundle.getBundle("restringer/gui/General").getString("PLEASE WAIT."));
        this.LABEL.setAlignmentX(0.5f);
        this.LABEL.setAlignmentY(0.5f);
        this.LABEL.setMaximumSize(new Dimension(200, 30));
        
        this.BAR = new JProgressBar();
        this.BAR.setAlignmentX(0.5f);
        this.BAR.setAlignmentY(0.5f);
        
        this.TOPPANEL.add(this.LABEL);
        this.BOTTOMPANEL.add(this.BAR);
        
        this.add(Box.createVerticalGlue());
        this.add(this.TOPPANEL);
        this.add(this.BOTTOMPANEL);
        this.add(Box.createVerticalGlue());

    }

    /**
     * Sets the title and model of the <code>ProgressIndicator</code>..
     *
     * @param title The new title of the dialog.
     * @param model The new model of the dialog.
     */
    public void setModel(String title, BoundedRangeModel model) {
        Objects.requireNonNull(title);
        Objects.requireNonNull(model);
        this.BAR.setModel(model);
        //this.setTitle(title);
    }

    static void startWaitCursor(JComponent component) {
        RootPaneContainer root = ((RootPaneContainer) component.getTopLevelAncestor());
        root.getGlassPane().setCursor(Cursor.getPredefinedCursor(Cursor.WAIT_CURSOR));
        root.getGlassPane().addMouseListener(NULLMOUSEADAPTER);
        root.getGlassPane().setVisible(true);
    }

    static void stopWaitCursor(JComponent component) {
        RootPaneContainer root = ((RootPaneContainer) component.getTopLevelAncestor());
        root.getGlassPane().setCursor(Cursor.getDefaultCursor());
        root.getGlassPane().removeMouseListener(NULLMOUSEADAPTER);
        root.getGlassPane().setVisible(false);
    }

    static final private MouseAdapter NULLMOUSEADAPTER = new MouseAdapter() {
    };

    final private JPanel TOPPANEL;
    final private JPanel BOTTOMPANEL;
    final private JLabel LABEL;
    final private JProgressBar BAR;

}
