/*
 * Copyright 2016 Mark Fairchild.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package restringer.gui;

import java.util.Objects;
import java.util.ResourceBundle;
import javax.swing.event.TableModelListener;
import restringer.ess.papyrus.*;

/**
 * A table model for papyrus scripts.
 *
 * @author Mark Fairchild
 */
public class ScriptTableModel implements javax.swing.table.TableModel {

    public ScriptTableModel(Script script) {
        Objects.requireNonNull(script);
        this.SCRIPT = script;
    }

    @Override
    public int getRowCount() {
        return this.SCRIPT.getMembers().size();
    }

    @Override
    public int getColumnCount() {
        return 3;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        assert 0 <= rowIndex && rowIndex < this.getRowCount();
        MemberDesc member = this.SCRIPT.getMembers().get(rowIndex);

        switch (columnIndex) {
            case 0:
                return rowIndex;
            case 1:
                return member.getType();
            case 2:
                return member.getName();
            default:
                throw new IllegalStateException();
        }
    }

    @Override
    public String getColumnName(int columnIndex) {
        return COLUMNNAMES[columnIndex];
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return COLUMNTYPES[columnIndex];
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public void addTableModelListener(TableModelListener l) {
    }

    @Override
    public void removeTableModelListener(TableModelListener l) {
    }

    final private Script SCRIPT;
    static final private ResourceBundle RES = ResourceBundle.getBundle("restringer/gui/General");
    static final private String[] COLUMNNAMES = getColumnNames();
    static final private Class<?>[] COLUMNTYPES = getColumnTypes();

    static private String[] getColumnNames() {
        return new String[]{
            RES.getString("VARIABLETABLEMODEL #"),
            RES.getString("VARIABLETABLEMODEL TYPE"),
            RES.getString("VARIABLETABLEMODEL NAME")};
    }

    static private Class<?>[] getColumnTypes() {
        return new Class<?>[]{Integer.class, String.class, String.class};
    }

}
