/*
 * Copyright 2016 Mark Fairchild.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package restringer.gui;

import java.util.Objects;
import restringer.ess.papyrus.*;

/**
 * A table model for papyrus script instances.
 *
 * @author Mark Fairchild
 * @version 2016/06/15
 */
public class StackFrameTableModel extends VariableTableModel {

    public StackFrameTableModel(StackFrame frame) {
        assert frame.getUnknown2().size() == 
                frame.getFunctionLocals().size() + 
                frame.getFunctionParams().size();
        
        this.FRAME = Objects.requireNonNull(frame);
        this.OFFSET = this.FRAME.getFunctionParams().size();
    }

    @Override
    protected int getNumVariables() {
        return this.FRAME.getUnknown2().size();
    }

    @Override
    protected Variable getVariable(int index) {
        return this.FRAME.getUnknown2().get(index);

    }

    @Override
    protected MemberDesc getMemberData(int index) {
        if (index < this.OFFSET) {
            return this.FRAME.getFunctionParams().get(index);
        } else {
            return this.FRAME.getFunctionLocals().get(index - this.OFFSET);
        }
    }

    @Override
    protected void setVariable(int index, Variable newVar) {
        this.FRAME.getUnknown2().set(index, newVar);
    }

    @Override
    protected boolean supportsMemberData() {
        return true;
    }

    final private StackFrame FRAME;
    final private int OFFSET;

}
