/*
 * Copyright 2017 Mark Fairchild.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package restringer.gui;

import java.util.Objects;
import restringer.ess.papyrus.*;

/**
 * A table model for papyrus script structs.
 *
 * @author Mark Fairchild
 */
public class StructTableModel extends VariableTableModel {

    public StructTableModel(Struct struct) {
        this.STRUCT = Objects.requireNonNull(struct);
    }

    @Override
    protected int getNumVariables() {
        return this.STRUCT.getData().getMembers().size();
    }

    @Override
    protected Variable getVariable(int index) {
        return this.STRUCT.getData().getMembers().get(index);
    }

    @Override
    protected MemberDesc getMemberData(int index) {
        if (null == this.STRUCT.getStructDef()) {
            return null;
        }
        
        return this.STRUCT.getStructDef().getMembers().get(index);
    }

    @Override
    protected void setVariable(int index, Variable newVar) {
        this.STRUCT.getData().getMembers().set(index, newVar);
    }

    @Override
    protected boolean supportsMemberData() {
        return true;
    }

    final private Struct STRUCT;

}
