//
//  Copyright 2011 Spaces of Play, Mattias Ljungström. All rights reserved.
//
//  Vertex Shader
//

#version 150 core

in vec3 a_position;
in vec4 a_color;

uniform mat4 MVP;

out vec4 v_color;
           

void main()
{
	//set position
	vec4 position4 = vec4(a_position.xyz, 1.);

    //pass to fragment shader
    v_color = a_color;

    //transform to world coordinates
    gl_Position = MVP * position4;
}
