//
//  Copyright 2011 Spaces of Play, Mattias Ljungström. All rights reserved.
//
//  Fragment Shader
//

#version 150 core

//in vec3 v_position;
in vec3 v_normal;
//in vec2 v_texCoord;

out vec4 out_color;


//
// Lightning variables
//
uniform vec4 LightPosition;
//uniform vec3 LightIntensity;

uniform vec3 Kd;            // Diffuse reflectivity
uniform vec3 Ka;            // Ambient reflectivity
//uniform vec3 Ks;            // Specular reflectivity
//uniform float Shininess;    // Specular shininess factor


vec3 ads( )
{
    //vec3 n = normalize( v_normal );
    //vec3 n = v_normal;

    //positional
    //vec3 s = normalize( vec3(LightPosition) - v_position );

    //directional
    //vec3 s = normalize( vec3(LightPosition) );
    vec3 s = LightPosition.xyz;

    //vec3 v = normalize( vec3(-v_position) );
    //vec3 r = reflect( -s, n );

    return          ( Ka +
                      Kd * max( dot(s, v_normal), 0.0 )
                      );
}


//
// main()
//
void main( void )
{
    out_color = vec4(ads(), 1.0);
}

