//
//  Copyright 2011 Spaces of Play, Mattias Ljungström. All rights reserved.
//
//  Vertex Shader
//

#version 150 core

in vec3 a_position;
in vec3 a_normal;

//out vec3 v_position;
out vec3 v_normal;

//uniform mat4 ModelViewMatrix;
uniform mat3 NormalMatrix;
//uniform mat4 ProjectionMatrix;
uniform mat4 MVP;

                                         
void main()
{
	//set position
	vec4 position4 = vec4(a_position.xyz, 1.);

    //pass to fragment shader
    v_normal = normalize( NormalMatrix * a_normal);

    //v_position = vec3( ModelViewMatrix * position4 );
	//v_texCoord = a_textureUV;

    //transform to world coordinates
    gl_Position = MVP * position4;
}
