//
//  Created by mattias on 03/02/2011.
//  Copyright 2011 Spaces of Play, Mattias Ljungström. All rights reserved.
//

#version 150 core
                                         
in vec3 a_position;
in vec4 a_color;
in vec2 a_textureUV;

out vec4 v_color;
out vec2 v_texCoord;
                                       
//uniform mat4 u_matrix;
uniform vec2 u_textureScale;      //texture coordinates are stored as integer values
uniform mat4 MVP;

void main()
{
	//set position
	vec4 position4 = vec4(a_position.xyz, 1.);

    //pass to fragment shader
    v_color = a_color;
	v_texCoord = a_textureUV * u_textureScale;

    //return transformed position
    gl_Position = MVP * position4;
}
