//
//  Created by mattias on 03/02/2011.
//  Copyright 2011 Spaces of Play, Mattias Ljungström. All rights reserved.
//

// version 1.50 corresponds to OpenGL 3.2
#version 150 core

//precision highp float;
                                       
in vec4 v_color;
in vec2 v_texCoord;
in vec4 v_shadowCoord;

out vec4 out_color;

uniform sampler2D u_textureSampler;
uniform sampler2DShadow u_shadowMap;


void main()
{
	//set color
    vec4 color = texture(u_textureSampler, v_texCoord) * v_color;

    // discard transparent pixels, so we don't write into depth buffer
    if (color.a < 0.2)
        discard;

    //Shadow-map look-up
    float shadow = textureProj(u_shadowMap, v_shadowCoord);

    //allow some ambient light
    float shadowF = 0.15 + shadow * 0.85;

    //factor the shadow value directly on color
    out_color = vec4( color.xyz * shadowF, color.a );
}
