//
//  Created by mattias on 03/02/2011.
//  Copyright 2011 Spaces of Play, Mattias Ljungström. All rights reserved.
//

// version 1.50 corresponds to OpenGL 3.2
#version 150 core

//precision highp float;
                                       
in vec4 v_color;
in vec2 v_texCoord;
in vec4 v_shadowCoord;
in vec2 v_pos;

out vec4 out_color;

uniform sampler2D u_textureSampler;
uniform sampler2DShadow u_shadowMap;


float hash(float n)
{
   //return fract(sin(n)*43758.5453123);
   //return fract(sin(n)*43.7585453123);
   return fract(sin(n)*4.37585453123);
}

void main()
{
	//set color
    vec4 color = texture(u_textureSampler, v_texCoord) * v_color;

    // discard transparent pixels, so we don't write into depth buffer
    if (color.a < 0.2)
        discard;

	float noiseZ = hash(v_pos.x * 0.1) * hash(v_pos.y * 0.1);
	vec4 sc = v_shadowCoord + vec4(noiseZ*96.0, noiseZ*96.0, noiseZ*96.0, 0); 

    //Shadow-map look-up
    float shadow = textureProj(u_shadowMap, sc);

    //allow some ambient light
    float shadowF = 0.6 + shadow * 0.4;

    //factor the shadow value directly on color
    out_color = vec4( color.xyz * shadowF, color.a );
}
