//
//  Created by mattias on 03/02/2011.
//  Copyright 2011 Spaces of Play, Mattias Ljungström. All rights reserved.
//

#version 150 core

//precision mediump float;
                                       
//in vec4 v_color;
in vec2 v_texCoord;
in vec2 v_blurTexCoords[14];
in float v_distCenter;

out vec4 out_color;

uniform sampler2D u_textureSampler;
                                         

void main()
{
	// blend blur color values from around texture
    vec4 origColor = texture(u_textureSampler, v_texCoord);

    vec4 colorBlur = texture(u_textureSampler, v_blurTexCoords[ 0])*0.0044299121055113265;
    colorBlur += texture(u_textureSampler, v_blurTexCoords[ 1])*0.00895781211794;
    colorBlur += texture(u_textureSampler, v_blurTexCoords[ 2])*0.0215963866053;
    colorBlur += texture(u_textureSampler, v_blurTexCoords[ 3])*0.0443683338718;
    colorBlur += texture(u_textureSampler, v_blurTexCoords[ 4])*0.0776744219933;
    colorBlur += texture(u_textureSampler, v_blurTexCoords[ 5])*0.115876621105;
    colorBlur += texture(u_textureSampler, v_blurTexCoords[ 6])*0.147308056121;
    colorBlur += origColor                                     *0.159576912161;
    colorBlur += texture(u_textureSampler, v_blurTexCoords[ 7])*0.147308056121;
    colorBlur += texture(u_textureSampler, v_blurTexCoords[ 8])*0.115876621105;
    colorBlur += texture(u_textureSampler, v_blurTexCoords[ 9])*0.0776744219933;
    colorBlur += texture(u_textureSampler, v_blurTexCoords[10])*0.0443683338718;
    colorBlur += texture(u_textureSampler, v_blurTexCoords[11])*0.0215963866053;
    colorBlur += texture(u_textureSampler, v_blurTexCoords[12])*0.00895781211794;
    colorBlur += texture(u_textureSampler, v_blurTexCoords[13])*0.0044299121055113265;

    //weight and mix colors
    colorBlur *= 0.3;
    origColor *= 1.125;
    out_color = mix(origColor, colorBlur, v_distCenter);
}
