//
//  Created by mattias on 03/02/2011.
//  Copyright 2011-2016 Spaces of Play, Mattias Ljungström. All rights reserved.
//

#version 150 core


#include "PhotoshopMathFP.glsl"


//in vec4 v_color;
in vec2 v_texCoord;
in float v_distCenter;

out vec4 out_color;


uniform sampler2D u_textureSampler;
uniform sampler2D u_depthTextureSampler;
uniform sampler2D u_blurTextureSampler;

uniform float u_znear;
uniform float u_zfar;
uniform float u_focalDepth;     //focal distance value in game units

uniform float u_pureBlur;       //blur to apply


const float ndofstart  =  300.0;      //near dof blur start
const float ndofdist   = 1300.0;      //near dof blur falloff distance
const float fdofstart  =   10.0;      //far dof blur start
const float fdofdist   =  700.0;      //far dof blur falloff distance

const vec3 color_depth_down = vec3(135.0/255.0, 135.0/255.0, 255.0/255.0);
const vec3 color_depth_up = vec3(247.0/255.0, 166.0/255.0, 10.0/255.0);


float linearize(float depth)
{
    return -u_zfar * u_znear / (depth * (u_zfar - u_znear) - u_zfar);   // [near, far]
}


void main()
{
    // read color value and blur value
    vec4 color_orig = texture(u_textureSampler, v_texCoord);
    vec4 color_blur = texture(u_blurTextureSampler, v_texCoord);

    // read depth value from depth texture
    float depthValue = texture(u_depthTextureSampler, v_texCoord).x;
    float depthLinear = linearize( depthValue );

    // calculate blur based on focal depth
    float blur;
    float a = depthLinear - u_focalDepth;         //focal plane
    if (a>0.0)
    {
        blur = (a-fdofstart) / fdofdist;          //far DoF
    }
    else
    {
        blur = (-a-ndofstart) / ndofdist * 0.9;   //near Dof
    }

    // apply blur mix
    blur = clamp(blur, 0.0, 1.0);
    float blurMix = clamp(blur*0.7 + u_pureBlur, 0.0, 1.0);
    vec3 color_mixed_blur = mix(color_orig.rgb, color_blur.rgb, blurMix);


    // apply hue shift based on height diff
    vec3 color_mixed;
    if (a>0.0)
    {
        // something below us
        float blurBelowMax = clamp( blur, 0.0, 0.6 );
        color_mixed = mix( color_mixed_blur, BlendHue(color_mixed_blur, color_depth_down), blurBelowMax );

        // darken over 0.6
        float darkenColor = clamp( ((blur-0.6) * 2.48) * step(0.6, blur), 0.0, 1.0 );
        color_mixed *= 1.0 - darkenColor;
    }
    else
    {
        // something above us
        color_mixed = mix( color_mixed_blur, BlendHardLight(color_mixed_blur, color_depth_up), blur );
    }


    // apply vignette
    float t = 1.0 - v_distCenter;
    float tm1 = v_distCenter;
    vec3 color_blur_dark = color_blur.rgb * (0.125 * tm1 * ( 3.75 * t + 1.0 ));
    vec3 color_orig_glow = color_mixed * (1.125*1.125 * t*t);
    vec3 color_vignette = color_blur_dark + color_orig_glow;


    // output color
    out_color = vec4(color_vignette, 1.0);
}




