//
//  Created by mattias on 03/02/2011.
//  Copyright 2011 Spaces of Play, Mattias Ljungström. All rights reserved.
//

#version 150 core

//precision mediump float;
                                       
//in vec4 v_color;
in vec2 v_texCoord;

out vec4 out_color;

uniform sampler2D u_textureSampler;
uniform mat3 u_hsvMat;


void main()
{
	// get texture color and modulate
    vec4 origColor = texture(u_textureSampler, v_texCoord) ; // * v_color;

    // apply HUE rotation with pre-calculated matrix
    // RGB -> YIQ -> HSV rotation/scale -> RGB
    vec4 hueColor = vec4( u_hsvMat * origColor.rgb, 1.0 );

    // output color
    out_color = hueColor;
}
