//
//  Created by mattias on 03/02/2011.
//  Copyright 2011 Spaces of Play, Mattias Ljungström. All rights reserved.
//

#version 150 core


#include "PhotoshopMathFP.glsl"


//in vec4 v_color;
in vec2 v_texCoord;

out vec4 out_color;

uniform sampler2D u_textureSampler;

//uniform mat3 u_hsvMat;
uniform vec3 u_hueColor;
uniform float u_hueBlend;       // [0, 1]
uniform float u_satScale;
uniform float u_lumScale;

void main()
{
	// get texture color and modulate
    vec4 origColor = texture(u_textureSampler, v_texCoord) ; // * v_color;

    // get HSL colors
    vec3 origHSL = RGBToHSL(origColor.rgb);
    vec3 hueHSL = RGBToHSL(u_hueColor);     // this is constant => optimize worth it?

    // blend and apply scale
    // .rgb == .hsl
    float hue = hueHSL.r;  //mixHue(origHSL.r, hueHSL.r, u_hueBlend);
    float sat = origHSL.g * u_satScale;
    if (sat > 1.0) { sat = 1.0; };
    float lum = origHSL.b * u_lumScale;
    if (lum > 1.0) { lum = 1.0; };
    vec3 color_hue = HSLToRGB( vec3(hue, sat, lum) );

    // mix in RGB space
    vec3 color_mixed = mix( origColor.rgb, color_hue, u_hueBlend );

    // output color
    out_color = vec4(color_mixed.rgb, origColor.a);
}
