//
//  Created by mattias on 03/02/2011.
//  Copyright 2011 Spaces of Play, Mattias Ljungström. All rights reserved.
//

#version 150 core

in vec2 a_position;
//in vec4 a_color;
in vec2 a_textureUV;

//out vec4 v_color;
out vec2 v_texCoord;
out vec2 v_blurTexCoords[14];

uniform float u_inputFactor2;

void main()
{
    //use absolute position, this shader is for fullscreen only
    gl_Position = vec4(a_position.xy, 0., 1.);
    
    //pass to fragment shader
    //v_color = a_color;
    v_texCoord = a_textureUV;

    float factor = u_inputFactor2;

    //pre-calculated horizontal blur coordinates
    v_blurTexCoords[ 0] = a_textureUV + vec2(-0.028*factor, 0.0);
    v_blurTexCoords[ 1] = a_textureUV + vec2(-0.024*factor, 0.0);
    v_blurTexCoords[ 2] = a_textureUV + vec2(-0.020*factor, 0.0);
    v_blurTexCoords[ 3] = a_textureUV + vec2(-0.016*factor, 0.0);
    v_blurTexCoords[ 4] = a_textureUV + vec2(-0.012*factor, 0.0);
    v_blurTexCoords[ 5] = a_textureUV + vec2(-0.008*factor, 0.0);
    v_blurTexCoords[ 6] = a_textureUV + vec2(-0.004*factor, 0.0);
    v_blurTexCoords[ 7] = a_textureUV + vec2( 0.004*factor, 0.0);
    v_blurTexCoords[ 8] = a_textureUV + vec2( 0.008*factor, 0.0);
    v_blurTexCoords[ 9] = a_textureUV + vec2( 0.012*factor, 0.0);
    v_blurTexCoords[10] = a_textureUV + vec2( 0.016*factor, 0.0);
    v_blurTexCoords[11] = a_textureUV + vec2( 0.020*factor, 0.0);
    v_blurTexCoords[12] = a_textureUV + vec2( 0.024*factor, 0.0);
    v_blurTexCoords[13] = a_textureUV + vec2( 0.028*factor, 0.0);
}
