ObjectWrapper = {id = 0}

function ObjectWrapper:new(objectId)
	wrapper = {id = objectId}
	setmetatable(wrapper, self)
	self.__index = self
	return wrapper
end

-- querying

function ObjectWrapper:isEnabled()
	return Object.isEnabled(self.id)
end

function ObjectWrapper:getType()
	return Object.getType(self.id)
end

function ObjectWrapper:hasTrait(trait)
	return Object.hasTrait(self.id, trait)
end

function ObjectWrapper:getPosition()
	return Object.getPosition(self.id)
end

-- modifying

function ObjectWrapper:reset()
	Object.reset(self.id)
	return self
end

function ObjectWrapper:destroy()
	Object.destroy(self.id)
	return self
end

function ObjectWrapper:setEnabled(setEnabled)
	Object.setEnabled(self.id, setEnabled)
	return self
end

function ObjectWrapper:setVisible(setVisible)
	Object.setVisible(self.id, setVisible)
	return self
end

-- event listeners

function ObjectWrapper:onCollision(callback)
	Object.onCollision(self.id, callback)
	return self
end

function ObjectWrapper:onDestroy(callback)
	Object.onDestroy(self.id, callback)
	return self
end

function ObjectWrapper:onSpawn(callback)
	Object.onSpawn(self.id, callback)
	return self
end

function ObjectWrapper:onEnable(callback)
	Object.onEnable(self.id, callback)
	return self
end

function ObjectWrapper:onVisibilityChanged(callback)
	Object.onVisibilityChanged(self.id, callback)
	return self
end

function ObjectWrapper:onStun(callback)
	Object.onStun(self.id, callback)
	return self
end

function ObjectWrapper:onEnterArea(callback)
	Object.onEnterArea(self.id, callback)
	return self
end

function ObjectWrapper:onLeaveArea(callback)
	Object.onLeaveArea(self.id, callback)
	return self
end

function ObjectWrapper:onInsideArea(callback)
	Object.onInsideArea(self.id, callback)
	return self
end

function ObjectWrapper:unregister(callback)
	Object.unregister(self.id, callback)
	return self
end

-- shortcuts

function ObjectWrapper.hideOnDisableCallback(objectId, isEnabled) 
	if not isEnabled then
		Object.setVisible(objectId, false) 
	end
end

function ObjectWrapper.showOnEnableCallback(objectId, isEnabled) 
	if isEnabled then
		Object.setVisible(objectId, true) 
	end
end

function ObjectWrapper.resetOnEnableCallback(objectId, isEnabled) 
	if isEnabled then
		Object.reset(objectId) 
	end
end

function ObjectWrapper.resetOnDisableCallback(objectId, isEnabled) 
	if not isEnabled then
		Object.reset(objectId) 
	end
end

function ObjectWrapper:hideOnDisable()
	self:onEnable(self.hideOnDisableCallback)
	return self
end

function ObjectWrapper:showOnEnable()
	self:onEnable(self.showOnEnableCallback)
	return self
end

function ObjectWrapper:resetOnEnable()
	self:onEnable(self.resetOnEnableCallback)
	return self
end

function ObjectWrapper:resetOnDisable()
	self:onEnable(self.resetOnDisableCallback)
	return self
end

function ObjectWrapper:runOnEnabled(callback)
	self:onEnable(
		function(objectId, isEnabled)
			if isEnabled then
				callback()
			end
		end)
	return self
end

function ObjectWrapper:runOnDisabled(callback)
	self:onEnable(
		function(objectId, isEnabled)
			if not isEnabled then
				callback()
			end
		end)
	return self
end

function ObjectManager.get(id)
	return ObjectWrapper:new(id)
end
