require("game_object_wrapper")
require("timed_actions")

function setupGravitonTrap(sensor, gravitons, delay, duration)
	sensor:onEnterArea(
		function(areaId, objectId)
			TimedActionManager.delayAction(0, function() sensor:setEnabled(false) end)
			TimedActionManager.delayAction(delay + duration, function() sensor:setEnabled(true) end)
			TimedActionManager.delayAction(delay, function() triggerGravitonTrap(gravitons, duration) end)
		end
	)
end

function triggerGravitonTrap(gravitons, duration)
	for _, graviton in pairs(gravitons) do
		graviton:setEnabled(true)
	end
	TimedActionManager.delayAction(duration,
		function()
			for _, graviton in pairs(gravitons) do
				graviton:setEnabled(false):reset()
			end
		end)
end
