require("group_helpers")

function activateNeuronPath(path, delay, duration, fadeDuration, onEndCallback)
	if fadeDuration and fadeDuration >= duration then
		log("activateNeuronPath: fade duration must be shorter than duration")
		fadeDuration = 0.3
	end
	path:forEach(delay,
		function(i, n, actor)
			actor:setEnabled(true)
			if duration and fadeDuration then
				TimedActionManager.delayAction(duration - fadeDuration, function() actor:setEnabled(false) end)
			end
			if duration then TimedActionManager.delayAction(duration, function() actor:setVisible(false) end) end
			if i == n and onEndCallback then onEndCallback() end
		end)
end

function deactivateNeuronPath(path, delay, onEndCallback)
	path:forEach(delay,
		function(i, n, actor)
			actor:setEnabled(false)
			if i == n and onEndCallback then onEndCallback() end
		end)
end

function showNeuronPath(path, delay, duration, fadeDuration, onEndCallback)
	if fadeDuration and fadeDuration >= duration then
		log("showNeuronPath: fade duration must be shorter than duration")
		fadeDuration = 0.3
	end
	path:forEach(delay,
		function(i, n, actor)
			actor:setVisible(true)
			if duration and fadeDuration then
				TimedActionManager.delayAction(duration - fadeDuration, function() actor:setEnabled(false) end)
			end
			if duration then TimedActionManager.delayAction(duration, function() actor:setVisible(false) end) end
			if i == n and onEndCallback then onEndCallback() end
		end)
end

