DEBUG = false

realLog = _G.log
function log(msg, debugLvl)
	debugLvl = (debugLvl or debugLvl == nil) and true or false
	if DEBUG and debugLvl then realLog(msg) end
end

-- returns two values:
--     bool    - true if given table is a sequence (an array), false otherwise
--     number  - number of entries in table
function isSequence(table)
	local isSequence = true
	local i = 0
	for _ in pairs(t) do
		i = i + 1
		if t[i] == nil then isSequence = false end
	end
	return isSequence, i
end

-- counts number of elements in the supplied table
function count(table)
	local count = 0
	for _ in pairs(t) do
		count = count + 1
	end
	return count
end

-- given a table of actors, returns a table of object ids 
function actorsToIds(actors)
	local ids = {};
	local properPairs = pairs
	if isSequence(actors) then
		properPairs = ipairs
	end
	
	for _,actor in properPairs(actors) do
		if actor.id then table.insert(ids, actor.id) end
	end
	
	return ids
end

function isPointInsideRect(px, py, rx, ry, width, height)
	return px > rx and px < (rx + width) and py > ry and py < (ry + height)
end

-- Calls supplied function when specified object is visible on the screen.
-- The callback needs to return false in order for this to stop.
function callWhenOnScreen(objectId, callback)
	TimedActionManager.repeatAction(0, function()
		local x1, y1 = Object.getPosition(objectId)
		local rx, ry, width, height = Camera.getView()

		local continue = true
		if isPointInsideRect(x1, y1, rx, ry, width, height) then
			if callback(objectId) == false then
				continue = false
			end
		end

		return continue
	end)
end
