<?php
/**
# ＝＝＝＝＝＝＝＝＝＝＝＝＝＝＝＝＝＝＝＝＝＝＝＝＝＝＝＝
#    康虎云报表演示模块
#     ver 1.2.2
#
#    Author: 康虎软件工作室(CFSoft Studio)
#    Version: 1.0
#    Create Date: 2017.02.06
#
#    Copyright (C) 2016-2017 康虎软件工作室 (<http://www.cfsoft.cf>).
#    QQ： 360026606  微信： 360026606
#
#
#    该模块用以演示如果通过php在服务端生成康虎云报表所需要的数据并驱动康虎云报表输出报表的。
# 
#
#    康虎云报表打印的主要数据流程如下：
#
#    调用打印功能 --> web服务器 --> 按康虎云报表规则生成数据
#        ↑                                  ｜
#        |                                  ｜
#        |                                  ↓
#    访问服务器                           浏览器
#        ↑                                  ｜
#        |                                  ｜
#        |                                  ↓
#    浏览器                          康虎云报表服务器
#                                           |
#                                           ↓
#                                        打印机
#                                          
# --------------------------------------------------------
# 注意：
# 1、服务端只需要生成报表数据即可，不需要关心报表格式                                         
# 2、康虎云报表伺服程序运行在客户端（连打印机的那台电脑）而不是部署在服务端
# 3、在打印前报表模板要预先设计好，服务端生成的json中字段名称要与模板中一致
# 4、本示例只演示如何使用，所以没有实现如何连数据库并从数据库取数的相关功能，
#    如果要学习php如何连数据库获取数据的相关功能，请自行搜索相关学习资料
# 
# 
# 
# 
# 
# ＝＝＝＝＝＝＝＝＝＝＝＝＝＝＝＝＝＝＝＝＝＝＝＝＝＝＝＝
*
*/

//这是告诉康虎云报表系统该使用哪个模板文件（模板文件在与cfprint.exe相同目录下）
//这里是用一个快递公司的电子快递单做例子来演示
$template = "waybill.fr3";    

//康虎云报表系统为了便于管理，对数据格式做了版本区分，不同版本格式可能会有所改变，
//大家只要参考cfprint.exe 自带帮助里的说明就可以了
$ver = 3.0;

//声明报表所需要数据的字段属性
$fields = array(
	array(
	  "type" => "str",        /*字段类型，可选值：String,Str,Integer,Int,Smallint,Float,Long*/
	  "size" => 255,           /*字段长度*/
	  "name" => "HAWB#",       /*字段名称，必须与打印模板中的打印项名称相同*/
	  "required" => false     /*字段是否必填*/
	),
	array( "type" => "int",  "size" => 0,  "name" => "NO",  "required" => false ),
	array( "type" => "float",  "size" => 0,  "name" => "报关公司面单号",  "required" => false ),
	array( "type" => "integer",  "size" => 0,  "name" => "公司内部单号",  "required" => false ),
	array( "type" => "str",  "size" => 255,  "name" => "发件人",  "required" => false ),
	array( "type" => "str",  "size" => 255,  "name" => "发件人地址",  "required" => false ),
	array( "type" => "str",  "size" => 255,  "name" => "发件人电话",  "required" => false ),
	array( "type" => "str",  "size" => 255,  "name" => "发货国家",  "required" => false ),
	array( "type" => "str",  "size" => 255,  "name" => "收件人",  "required" => false ),
	array( "type" => "str",  "size" => 255,  "name" => "收件人地址",  "required" => false ),
	array( "type" => "str",  "size" => 255,  "name" => "收件人电话",  "required" => false ),
	array( "type" => "str",  "size" => 255,  "name" => "收货人证件号码",  "required" => false ),
	array( "type" => "str",  "size" => 255,  "name" => "收货省份",  "required" => false ),
	array( "type" => "float",  "size" => 0,  "name" => "总计费重量",  "required" => false ),
	array( "type" => "int",  "size" => 0,  "name" => "总件数",  "required" => false ),
	array( "type" => "float",  "size" => 0,  "name" => "申报总价（CNY）",  "required" => false ),
	array( "type" => "float",  "size" => 0,  "name" => "申报总价（JPY）",  "required" => false ),
	array( "type" => "int",  "size" => 0,  "name" => "件数1",  "required" => false ),
	array( "type" => "str",  "size" => 255,  "name" => "品名1",  "required" => false ),
	array( "type" => "float",  "size" => 0,  "name" => "单价1（JPY）",  "required" => false ),
	array( "type" => "str",  "size" => 255,  "name" => "单位1",  "required" => false ),
	array( "type" => "float",  "size" => 0,  "name" => "申报总价1（CNY）",  "required" => false ),
	array( "type" => "float",  "size" => 0,  "name" => "申报总价1（JPY）",  "required" => false ),
	array( "type" => "int",  "size" => 0,  "name" => "件数2",  "required" => false ),
	array( "type" => "str",  "size" => 255,  "name" => "品名2",  "required" => false ),
	array( "type" => "float",  "size" => 0,  "name" => "单价2（JPY）",  "required" => false ),
	array( "type" => "str",  "size" => 255,  "name" => "单位2",  "required" => false ),
	array( "type" => "float",  "size" => 0,  "name" => "申报总价2（CNY）",  "required" => false ),
	array( "type" => "float",  "size" => 0,  "name" => "申报总价2（JPY）",  "required" => false ),
	array( "type" => "AutoInc",  "size" => 0,  "name" => "ID",  "required" => false )
);


//数据表行数据，常规的做法是从数据库里取出结果集然后循环生成，这里为简单起见，直接写上固定数据
//每一个内嵌的对象代表一行，这里定义了两行数据。每一个数据项的名称要与上面定义 $fields 里的一致

$rows = array(
  array(
    "HAWB#" => "860014010055" ,
    "NO" => 1 ,
    "报关公司面单号" => 200303900791 ,
    "公司内部单号" => 730293 ,
    "发件人" => "NAKAGAWA SUMIRE 2" ,
    "发件人地址" => " 991-199-113,Kameido,Koto-ku,Tokyo" ,
    "发件人电话" => "03-3999-3999" ,
    "发货国家" => "日本" ,
    "收件人" => "张三丰" ,
    "收件人地址" => "上海市闵行区虹梅南路1660弄蔷薇八村99号9999室" ,
    "收件人电话" => "182-1234-8888" ,
    "收货人证件号码" => null ,
    "收货省份" => null ,
    "总计费重量" => 3.2 ,
    "总件数" => 13 ,
    "申报总价（CNY）" => null ,
    "申报总价（JPY）" => null ,
    "件数1" => 10 ,
    "品名1" => "纸尿片" ,
    "单价1（JPY）" => null ,
    "单位1" => null ,
    "申报总价1（CNY）" => null ,
    "申报总价1（JPY）" => null ,
    "件数2" => null ,
    "品名2" => null ,
    "单价2（JPY）" => null ,
    "单位2" => null ,
    "申报总价2（CNY）" => null ,
    "申报总价2（JPY）" => null ,
    "ID" => 1 
  ),
  array(
    "HAWB#" => "860014010035" ,
    "NO" => 2 ,
    "报关公司面单号" => 200303900789 ,
    "公司内部单号" => 730291 ,
    "发件人" => "NAKAGAWA SUMIRE" ,
    "发件人地址" => " 991-199-113,Kameido,Koto-ku,Tokyo" ,
    "发件人电话" => "03-3999-3999" ,
    "发货国家" => "日本" ,
    "收件人" => "张无忌" ,
    "收件人地址" => "上海市闵行区虹梅南路1660弄蔷薇八村88号8888室" ,
    "收件人电话" => "182-1234-8888" ,
    "收货人证件号码" => null ,
    "收货省份" => null ,
    "总计费重量" => 3.2 ,
    "总件数" => 13 ,
    "申报总价（CNY）" => null ,
    "申报总价（JPY）" => null ,
    "件数1" => 10 ,
    "品名1" => "纸尿片" ,
    "单价1（JPY）" => null ,
    "单位1" => null ,
    "申报总价1（CNY）" => null ,
    "申报总价1（JPY）" => null ,
    "件数2" => null ,
    "品名2" => null ,
    "单价2（JPY）" => null ,
    "单位2" => null ,
    "申报总价2（CNY）" => null ,
    "申报总价2（JPY）" => null ,
    "ID" => 2 
  )
);

//定义数据表的名称，要与模板中使用的数据表名称相同
$tableName = "Table1";

//把所有定义项组合成一个大对象
$jsonObject = array(
	"template" => $template,
	"ver" => $ver,
	"Tables" => array(
		array(
			"Name" => $tableName,
			"Cols" => $fields,
			"Data" => $rows
		)
	)
);


//最终生成康虎云报表所需要的json字符串，注意是json字符串，不要转成对象
$jsonStr = json_encode($jsonObject);
?>

<!DOCTYPE html>
<head>
<meta charset="utf-8" />
<title>康虎云报表系统测试</title>
<style type="text/css">
#output {font-size: 12px; background-color:#F0FFF0;}
#readme {font-size: 9px; background-color:#EEEEEE;}
</style>
</head>

<body>
  <div style="width: 100%;text-align:center;">
    <h2>康虎云报表系统报表打印测试（Ver 1.2.2）</h2>
    <h3>（PHP版演示）</h3>
    <div>
    	点按下面的“打印”按钮开始打印<br/>
      <input type="button" id="btnPrint" value="打印" onClick="doSend(_reportData);" />
    </div>
  </div>
  <div id="readme">
  	说明：<br/>
  	通过修改本页源码中的下列参数控制本页的行为：<br/>
&lt;script language="javascript" type="text/javascript"&gt;<br/>
<span style="color:green">/**下面四个参数必须放在myreport.js脚本后面，以覆盖myreport.js中的默认值**/</span><br/>
<span style="color:blue">var</span> _delay_send = <span style="color:red">1000</span>; &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<span style="color:green">//发送打印服务器前延时时长</span><br/>
<span style="color:blue">var</span> _delay_close = <span style="color:red">1000</span>; &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<span style="color:green">//打印完成后关闭窗口的延时时长, -1则表示不关闭</span><br/>
<span style="color:blue">var</span> cfprint_addr = <span style="color:red">"127.0.0.1"</span>; &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<span style="color:green">//打印服务器监听地址</span><br/>
<span style="color:blue">var</span> cfprint_port = <span style="color:red">54321</span>; &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<span style="color:green">//打印服务器监听端口</span><br/>
&lt;/script&gt;

  </div>
  <!-- 定义一个div用以显示实际发送给打印伺服程序的json，方便调试，-->
  <div id="output"></div>
</body>

<!--下面引入两个必须的 javascript 文件-->
<script language="javascript" type="text/javascript" src="cfprint.min.js"></script>
<script language="javascript" type="text/javascript" src="myreport.js"></script>
<!-- 下面重新设置几个参数，以覆盖myreport.js 中的默认值  -->
<script language="javascript" type="text/javascript">
/**下面四个参数必须放在myreport.js脚本后面，以覆盖myreport.js中的默认值**/
var _delay_send = -1;  //发送打印服务器前延时时长, -1则表示不自动打印
var _delay_close = -1;  //打印完成后关闭窗口的延时时长, -1则表示不关闭
var cfprint_addr = "127.0.0.1";  //打印服务器监听地址
var cfprint_port = 54321;        //打印服务器监听端口
</script>

<script type="text/javascript">
//把PHP代码里生成的数据json字符串转成javascript放在页面上，
//浏览器加载完该页面后会把该数据发送给康虎云报表伺服程序去打印
var _reportData = '<?php echo $jsonStr; ?>';

//在javascript控制台输出一下这个json字符串，对于调试有帮助
console.log("reportData = " + _reportData);
</script>
</html>