/*
 * Decompiled with CFR 0.152.
 */
package com.sun.script.javascript;

import sun.org.mozilla.javascript.Context;
import sun.org.mozilla.javascript.Function;
import sun.org.mozilla.javascript.NativeArray;
import sun.org.mozilla.javascript.NativeJavaArray;
import sun.org.mozilla.javascript.RhinoException;
import sun.org.mozilla.javascript.Scriptable;
import sun.org.mozilla.javascript.ScriptableObject;

public final class JSAdapter
implements Scriptable,
Function {
    private Scriptable prototype;
    private Scriptable parent;
    private Scriptable adaptee;
    private boolean isPrototype;
    private static final String GET_PROP = "__get__";
    private static final String HAS_PROP = "__has__";
    private static final String PUT_PROP = "__put__";
    private static final String DEL_PROP = "__delete__";
    private static final String GET_PROPIDS = "__getIds__";

    private JSAdapter(Scriptable scriptable) {
        this.setAdaptee(scriptable);
    }

    public static void init(Context context, Scriptable scriptable, boolean bl) throws RhinoException {
        JSAdapter jSAdapter = new JSAdapter(context.newObject(scriptable));
        jSAdapter.setParentScope(scriptable);
        jSAdapter.setPrototype(JSAdapter.getFunctionPrototype(scriptable));
        jSAdapter.isPrototype = true;
        ScriptableObject.defineProperty((Scriptable)scriptable, (String)"JSAdapter", (Object)jSAdapter, (int)2);
    }

    public String getClassName() {
        return "JSAdapter";
    }

    public Object get(String string, Scriptable scriptable) {
        Function function = this.getAdapteeFunction(GET_PROP);
        if (function != null) {
            return this.call(function, new Object[]{string});
        }
        scriptable = this.getAdaptee();
        return scriptable.get(string, scriptable);
    }

    public Object get(int n, Scriptable scriptable) {
        Function function = this.getAdapteeFunction(GET_PROP);
        if (function != null) {
            return this.call(function, new Object[]{new Integer(n)});
        }
        scriptable = this.getAdaptee();
        return scriptable.get(n, scriptable);
    }

    public boolean has(String string, Scriptable scriptable) {
        Function function = this.getAdapteeFunction(HAS_PROP);
        if (function != null) {
            Object object = this.call(function, new Object[]{string});
            return Context.toBoolean((Object)object);
        }
        scriptable = this.getAdaptee();
        return scriptable.has(string, scriptable);
    }

    public boolean has(int n, Scriptable scriptable) {
        Function function = this.getAdapteeFunction(HAS_PROP);
        if (function != null) {
            Object object = this.call(function, new Object[]{new Integer(n)});
            return Context.toBoolean((Object)object);
        }
        scriptable = this.getAdaptee();
        return scriptable.has(n, scriptable);
    }

    public void put(String string, Scriptable scriptable, Object object) {
        if (scriptable == this) {
            Function function = this.getAdapteeFunction(PUT_PROP);
            if (function != null) {
                this.call(function, new Object[]{string, object});
            } else {
                scriptable = this.getAdaptee();
                scriptable.put(string, scriptable, object);
            }
        } else {
            scriptable.put(string, scriptable, object);
        }
    }

    public void put(int n, Scriptable scriptable, Object object) {
        if (scriptable == this) {
            Function function = this.getAdapteeFunction(PUT_PROP);
            if (function != null) {
                this.call(function, new Object[]{new Integer(n), object});
            } else {
                scriptable = this.getAdaptee();
                scriptable.put(n, scriptable, object);
            }
        } else {
            scriptable.put(n, scriptable, object);
        }
    }

    public void delete(String string) {
        Function function = this.getAdapteeFunction(DEL_PROP);
        if (function != null) {
            this.call(function, new Object[]{string});
        } else {
            this.getAdaptee().delete(string);
        }
    }

    public void delete(int n) {
        Function function = this.getAdapteeFunction(DEL_PROP);
        if (function != null) {
            this.call(function, new Object[]{new Integer(n)});
        } else {
            this.getAdaptee().delete(n);
        }
    }

    public Scriptable getPrototype() {
        return this.prototype;
    }

    public void setPrototype(Scriptable scriptable) {
        this.prototype = scriptable;
    }

    public Scriptable getParentScope() {
        return this.parent;
    }

    public void setParentScope(Scriptable scriptable) {
        this.parent = scriptable;
    }

    public Object[] getIds() {
        Function function = this.getAdapteeFunction(GET_PROPIDS);
        if (function != null) {
            Object object = this.call(function, new Object[0]);
            if (object instanceof NativeArray) {
                NativeArray nativeArray = (NativeArray)object;
                Object[] objectArray = new Object[(int)nativeArray.getLength()];
                for (int i = 0; i < objectArray.length; ++i) {
                    objectArray[i] = this.mapToId(nativeArray.get(i, (Scriptable)nativeArray));
                }
                return objectArray;
            }
            if (object instanceof NativeJavaArray) {
                Object[] objectArray;
                Object object2 = ((NativeJavaArray)object).unwrap();
                if (object2.getClass() == Object[].class) {
                    Object[] objectArray2 = (Object[])object2;
                    objectArray = new Object[objectArray2.length];
                    for (int i = 0; i < objectArray2.length; ++i) {
                        objectArray[i] = this.mapToId(objectArray2[i]);
                    }
                } else {
                    objectArray = Context.emptyArgs;
                }
                return objectArray;
            }
            return Context.emptyArgs;
        }
        return this.getAdaptee().getIds();
    }

    public boolean hasInstance(Scriptable scriptable) {
        if (scriptable instanceof JSAdapter) {
            return true;
        }
        for (Scriptable scriptable2 = scriptable.getPrototype(); scriptable2 != null; scriptable2 = scriptable2.getPrototype()) {
            if (!scriptable2.equals(this)) continue;
            return true;
        }
        return false;
    }

    public Object getDefaultValue(Class clazz) {
        return this.getAdaptee().getDefaultValue(clazz);
    }

    public Object call(Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) throws RhinoException {
        if (this.isPrototype) {
            return this.construct(context, scriptable, objectArray);
        }
        Scriptable scriptable3 = this.getAdaptee();
        if (scriptable3 instanceof Function) {
            return ((Function)scriptable3).call(context, scriptable, scriptable3, objectArray);
        }
        throw Context.reportRuntimeError((String)"TypeError: not a function");
    }

    public Scriptable construct(Context context, Scriptable scriptable, Object[] objectArray) throws RhinoException {
        if (this.isPrototype) {
            Scriptable scriptable2 = ScriptableObject.getTopLevelScope((Scriptable)scriptable);
            if (objectArray.length <= 0) {
                throw Context.reportRuntimeError((String)"JSAdapter requires adaptee");
            }
            JSAdapter jSAdapter = new JSAdapter(Context.toObject((Object)objectArray[0], (Scriptable)scriptable2));
            return jSAdapter;
        }
        Scriptable scriptable3 = this.getAdaptee();
        if (scriptable3 instanceof Function) {
            return ((Function)scriptable3).construct(context, scriptable, objectArray);
        }
        throw Context.reportRuntimeError((String)"TypeError: not a constructor");
    }

    public Scriptable getAdaptee() {
        return this.adaptee;
    }

    public void setAdaptee(Scriptable scriptable) {
        if (scriptable == null) {
            throw new NullPointerException("adaptee can not be null");
        }
        this.adaptee = scriptable;
    }

    private Object mapToId(Object object) {
        if (object instanceof Double) {
            return new Integer(((Double)object).intValue());
        }
        return Context.toString((Object)object);
    }

    private static Scriptable getFunctionPrototype(Scriptable scriptable) {
        return ScriptableObject.getFunctionPrototype((Scriptable)scriptable);
    }

    private Function getAdapteeFunction(String string) {
        Object object = ScriptableObject.getProperty((Scriptable)this.getAdaptee(), (String)string);
        return object instanceof Function ? (Function)object : null;
    }

    private Object call(Function function, Object[] objectArray) {
        Context context = Context.getCurrentContext();
        Scriptable scriptable = this.getAdaptee();
        Scriptable scriptable2 = function.getParentScope();
        try {
            return function.call(context, scriptable2, scriptable, objectArray);
        }
        catch (RhinoException rhinoException) {
            throw Context.reportRuntimeError((String)rhinoException.getMessage());
        }
    }
}

